/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.common.base.Preconditions;
import org.nd4j.evaluation.IEvaluation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.regularization.L1Regularization;
import org.nd4j.linalg.learning.regularization.L2Regularization;
import org.nd4j.linalg.learning.regularization.Regularization;
import org.nd4j.linalg.learning.regularization.WeightDecay;
import org.nd4j.serde.json.JsonMappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainingConfig {
    private static final Logger log = LoggerFactory.getLogger(TrainingConfig.class);
    private IUpdater updater;
    private List<Regularization> regularization = new ArrayList<Regularization>();
    private boolean minimize = true;
    private List<String> dataSetFeatureMapping;
    private List<String> dataSetLabelMapping;
    private List<String> dataSetFeatureMaskMapping;
    private List<String> dataSetLabelMaskMapping;
    private List<String> lossVariables;
    private int iterationCount;
    private int epochCount;
    private Map<String, List<IEvaluation>> trainEvaluations = new HashMap<String, List<IEvaluation>>();
    private Map<String, Integer> trainEvaluationLabels = new HashMap<String, Integer>();
    private Map<String, List<IEvaluation>> validationEvaluations = new HashMap<String, List<IEvaluation>>();
    private Map<String, Integer> validationEvaluationLabels = new HashMap<String, Integer>();

    public TrainingConfig(IUpdater updater, List<Regularization> regularization, String dataSetFeatureMapping, String dataSetLabelMapping) {
        this(updater, regularization, true, Collections.singletonList(dataSetFeatureMapping), Collections.singletonList(dataSetLabelMapping), Collections.emptyList(), Collections.emptyList(), null);
    }

    public TrainingConfig(IUpdater updater, List<Regularization> regularization, boolean minimize, List<String> dataSetFeatureMapping, List<String> dataSetLabelMapping, List<String> dataSetFeatureMaskMapping, List<String> dataSetLabelMaskMapping, List<String> lossVariables) {
        this.updater = updater;
        this.regularization = regularization;
        this.minimize = minimize;
        this.dataSetFeatureMapping = dataSetFeatureMapping;
        this.dataSetLabelMapping = dataSetLabelMapping;
        this.dataSetFeatureMaskMapping = dataSetFeatureMaskMapping;
        this.dataSetLabelMaskMapping = dataSetLabelMaskMapping;
        this.lossVariables = lossVariables;
    }

    protected TrainingConfig(IUpdater updater, List<Regularization> regularization, boolean minimize, List<String> dataSetFeatureMapping, List<String> dataSetLabelMapping, List<String> dataSetFeatureMaskMapping, List<String> dataSetLabelMaskMapping, List<String> lossVariables, Map<String, List<IEvaluation>> trainEvaluations, Map<String, Integer> trainEvaluationLabels, Map<String, List<IEvaluation>> validationEvaluations, Map<String, Integer> validationEvaluationLabels) {
        this(updater, regularization, minimize, dataSetFeatureMapping, dataSetLabelMapping, dataSetFeatureMaskMapping, dataSetLabelMaskMapping, lossVariables);
        this.trainEvaluations = trainEvaluations;
        this.trainEvaluationLabels = trainEvaluationLabels;
        this.validationEvaluations = validationEvaluations;
        this.validationEvaluationLabels = validationEvaluationLabels;
    }

    public void incrementIterationCount() {
        ++this.iterationCount;
    }

    public void incrementEpochCount() {
        ++this.epochCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int labelIdx(String s) {
        return this.dataSetLabelMapping.indexOf(s);
    }

    public static void removeInstances(List<?> list, Class<?> remove) {
        TrainingConfig.removeInstancesWithWarning(list, remove, null);
    }

    public static void removeInstancesWithWarning(List<?> list, Class<?> remove, String warning) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator<?> iter = list.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!remove.isAssignableFrom(o.getClass())) continue;
            if (warning != null) {
                log.warn(warning);
            }
            iter.remove();
        }
    }

    public String toJson() {
        try {
            return JsonMappers.getMapper().writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static TrainingConfig fromJson(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        try {
            return (TrainingConfig)JsonMappers.getMapper().readValue(json, TrainingConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IUpdater getUpdater() {
        return this.updater;
    }

    public List<Regularization> getRegularization() {
        return this.regularization;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public List<String> getDataSetFeatureMapping() {
        return this.dataSetFeatureMapping;
    }

    public List<String> getDataSetLabelMapping() {
        return this.dataSetLabelMapping;
    }

    public List<String> getDataSetFeatureMaskMapping() {
        return this.dataSetFeatureMaskMapping;
    }

    public List<String> getDataSetLabelMaskMapping() {
        return this.dataSetLabelMaskMapping;
    }

    public List<String> getLossVariables() {
        return this.lossVariables;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public int getEpochCount() {
        return this.epochCount;
    }

    public Map<String, List<IEvaluation>> getTrainEvaluations() {
        return this.trainEvaluations;
    }

    public Map<String, Integer> getTrainEvaluationLabels() {
        return this.trainEvaluationLabels;
    }

    public Map<String, List<IEvaluation>> getValidationEvaluations() {
        return this.validationEvaluations;
    }

    public Map<String, Integer> getValidationEvaluationLabels() {
        return this.validationEvaluationLabels;
    }

    public void setUpdater(IUpdater updater) {
        this.updater = updater;
    }

    public void setRegularization(List<Regularization> regularization) {
        this.regularization = regularization;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public void setDataSetFeatureMapping(List<String> dataSetFeatureMapping) {
        this.dataSetFeatureMapping = dataSetFeatureMapping;
    }

    public void setDataSetLabelMapping(List<String> dataSetLabelMapping) {
        this.dataSetLabelMapping = dataSetLabelMapping;
    }

    public void setDataSetFeatureMaskMapping(List<String> dataSetFeatureMaskMapping) {
        this.dataSetFeatureMaskMapping = dataSetFeatureMaskMapping;
    }

    public void setDataSetLabelMaskMapping(List<String> dataSetLabelMaskMapping) {
        this.dataSetLabelMaskMapping = dataSetLabelMaskMapping;
    }

    public void setLossVariables(List<String> lossVariables) {
        this.lossVariables = lossVariables;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public void setEpochCount(int epochCount) {
        this.epochCount = epochCount;
    }

    public void setTrainEvaluations(Map<String, List<IEvaluation>> trainEvaluations) {
        this.trainEvaluations = trainEvaluations;
    }

    public void setTrainEvaluationLabels(Map<String, Integer> trainEvaluationLabels) {
        this.trainEvaluationLabels = trainEvaluationLabels;
    }

    public void setValidationEvaluations(Map<String, List<IEvaluation>> validationEvaluations) {
        this.validationEvaluations = validationEvaluations;
    }

    public void setValidationEvaluationLabels(Map<String, Integer> validationEvaluationLabels) {
        this.validationEvaluationLabels = validationEvaluationLabels;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrainingConfig)) {
            return false;
        }
        TrainingConfig other = (TrainingConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IUpdater this$updater = this.getUpdater();
        IUpdater other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !((Object)this$updater).equals(other$updater)) {
            return false;
        }
        List<Regularization> this$regularization = this.getRegularization();
        List<Regularization> other$regularization = other.getRegularization();
        if (this$regularization == null ? other$regularization != null : !((Object)this$regularization).equals(other$regularization)) {
            return false;
        }
        if (this.isMinimize() != other.isMinimize()) {
            return false;
        }
        List<String> this$dataSetFeatureMapping = this.getDataSetFeatureMapping();
        List<String> other$dataSetFeatureMapping = other.getDataSetFeatureMapping();
        if (this$dataSetFeatureMapping == null ? other$dataSetFeatureMapping != null : !((Object)this$dataSetFeatureMapping).equals(other$dataSetFeatureMapping)) {
            return false;
        }
        List<String> this$dataSetLabelMapping = this.getDataSetLabelMapping();
        List<String> other$dataSetLabelMapping = other.getDataSetLabelMapping();
        if (this$dataSetLabelMapping == null ? other$dataSetLabelMapping != null : !((Object)this$dataSetLabelMapping).equals(other$dataSetLabelMapping)) {
            return false;
        }
        List<String> this$dataSetFeatureMaskMapping = this.getDataSetFeatureMaskMapping();
        List<String> other$dataSetFeatureMaskMapping = other.getDataSetFeatureMaskMapping();
        if (this$dataSetFeatureMaskMapping == null ? other$dataSetFeatureMaskMapping != null : !((Object)this$dataSetFeatureMaskMapping).equals(other$dataSetFeatureMaskMapping)) {
            return false;
        }
        List<String> this$dataSetLabelMaskMapping = this.getDataSetLabelMaskMapping();
        List<String> other$dataSetLabelMaskMapping = other.getDataSetLabelMaskMapping();
        if (this$dataSetLabelMaskMapping == null ? other$dataSetLabelMaskMapping != null : !((Object)this$dataSetLabelMaskMapping).equals(other$dataSetLabelMaskMapping)) {
            return false;
        }
        List<String> this$lossVariables = this.getLossVariables();
        List<String> other$lossVariables = other.getLossVariables();
        if (this$lossVariables == null ? other$lossVariables != null : !((Object)this$lossVariables).equals(other$lossVariables)) {
            return false;
        }
        if (this.getIterationCount() != other.getIterationCount()) {
            return false;
        }
        if (this.getEpochCount() != other.getEpochCount()) {
            return false;
        }
        Map<String, List<IEvaluation>> this$trainEvaluations = this.getTrainEvaluations();
        Map<String, List<IEvaluation>> other$trainEvaluations = other.getTrainEvaluations();
        if (this$trainEvaluations == null ? other$trainEvaluations != null : !((Object)this$trainEvaluations).equals(other$trainEvaluations)) {
            return false;
        }
        Map<String, Integer> this$trainEvaluationLabels = this.getTrainEvaluationLabels();
        Map<String, Integer> other$trainEvaluationLabels = other.getTrainEvaluationLabels();
        if (this$trainEvaluationLabels == null ? other$trainEvaluationLabels != null : !((Object)this$trainEvaluationLabels).equals(other$trainEvaluationLabels)) {
            return false;
        }
        Map<String, List<IEvaluation>> this$validationEvaluations = this.getValidationEvaluations();
        Map<String, List<IEvaluation>> other$validationEvaluations = other.getValidationEvaluations();
        if (this$validationEvaluations == null ? other$validationEvaluations != null : !((Object)this$validationEvaluations).equals(other$validationEvaluations)) {
            return false;
        }
        Map<String, Integer> this$validationEvaluationLabels = this.getValidationEvaluationLabels();
        Map<String, Integer> other$validationEvaluationLabels = other.getValidationEvaluationLabels();
        return !(this$validationEvaluationLabels == null ? other$validationEvaluationLabels != null : !((Object)this$validationEvaluationLabels).equals(other$validationEvaluationLabels));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrainingConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IUpdater $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : $updater.hashCode());
        List<Regularization> $regularization = this.getRegularization();
        result = result * 59 + ($regularization == null ? 43 : ((Object)$regularization).hashCode());
        result = result * 59 + (this.isMinimize() ? 79 : 97);
        List<String> $dataSetFeatureMapping = this.getDataSetFeatureMapping();
        result = result * 59 + ($dataSetFeatureMapping == null ? 43 : ((Object)$dataSetFeatureMapping).hashCode());
        List<String> $dataSetLabelMapping = this.getDataSetLabelMapping();
        result = result * 59 + ($dataSetLabelMapping == null ? 43 : ((Object)$dataSetLabelMapping).hashCode());
        List<String> $dataSetFeatureMaskMapping = this.getDataSetFeatureMaskMapping();
        result = result * 59 + ($dataSetFeatureMaskMapping == null ? 43 : ((Object)$dataSetFeatureMaskMapping).hashCode());
        List<String> $dataSetLabelMaskMapping = this.getDataSetLabelMaskMapping();
        result = result * 59 + ($dataSetLabelMaskMapping == null ? 43 : ((Object)$dataSetLabelMaskMapping).hashCode());
        List<String> $lossVariables = this.getLossVariables();
        result = result * 59 + ($lossVariables == null ? 43 : ((Object)$lossVariables).hashCode());
        result = result * 59 + this.getIterationCount();
        result = result * 59 + this.getEpochCount();
        Map<String, List<IEvaluation>> $trainEvaluations = this.getTrainEvaluations();
        result = result * 59 + ($trainEvaluations == null ? 43 : ((Object)$trainEvaluations).hashCode());
        Map<String, Integer> $trainEvaluationLabels = this.getTrainEvaluationLabels();
        result = result * 59 + ($trainEvaluationLabels == null ? 43 : ((Object)$trainEvaluationLabels).hashCode());
        Map<String, List<IEvaluation>> $validationEvaluations = this.getValidationEvaluations();
        result = result * 59 + ($validationEvaluations == null ? 43 : ((Object)$validationEvaluations).hashCode());
        Map<String, Integer> $validationEvaluationLabels = this.getValidationEvaluationLabels();
        result = result * 59 + ($validationEvaluationLabels == null ? 43 : ((Object)$validationEvaluationLabels).hashCode());
        return result;
    }

    public String toString() {
        return "TrainingConfig(updater=" + this.getUpdater() + ", regularization=" + this.getRegularization() + ", minimize=" + this.isMinimize() + ", dataSetFeatureMapping=" + this.getDataSetFeatureMapping() + ", dataSetLabelMapping=" + this.getDataSetLabelMapping() + ", dataSetFeatureMaskMapping=" + this.getDataSetFeatureMaskMapping() + ", dataSetLabelMaskMapping=" + this.getDataSetLabelMaskMapping() + ", lossVariables=" + this.getLossVariables() + ", iterationCount=" + this.getIterationCount() + ", epochCount=" + this.getEpochCount() + ", trainEvaluations=" + this.getTrainEvaluations() + ", trainEvaluationLabels=" + this.getTrainEvaluationLabels() + ", validationEvaluations=" + this.getValidationEvaluations() + ", validationEvaluationLabels=" + this.getValidationEvaluationLabels() + ")";
    }

    public TrainingConfig() {
    }

    public TrainingConfig(IUpdater updater, List<Regularization> regularization, boolean minimize, List<String> dataSetFeatureMapping, List<String> dataSetLabelMapping, List<String> dataSetFeatureMaskMapping, List<String> dataSetLabelMaskMapping, List<String> lossVariables, int iterationCount, int epochCount, Map<String, List<IEvaluation>> trainEvaluations, Map<String, Integer> trainEvaluationLabels, Map<String, List<IEvaluation>> validationEvaluations, Map<String, Integer> validationEvaluationLabels) {
        this.updater = updater;
        this.regularization = regularization;
        this.minimize = minimize;
        this.dataSetFeatureMapping = dataSetFeatureMapping;
        this.dataSetLabelMapping = dataSetLabelMapping;
        this.dataSetFeatureMaskMapping = dataSetFeatureMaskMapping;
        this.dataSetLabelMaskMapping = dataSetLabelMaskMapping;
        this.lossVariables = lossVariables;
        this.iterationCount = iterationCount;
        this.epochCount = epochCount;
        this.trainEvaluations = trainEvaluations;
        this.trainEvaluationLabels = trainEvaluationLabels;
        this.validationEvaluations = validationEvaluations;
        this.validationEvaluationLabels = validationEvaluationLabels;
    }

    public static class Builder {
        private IUpdater updater;
        private List<Regularization> regularization = new ArrayList<Regularization>();
        private boolean minimize = true;
        private List<String> dataSetFeatureMapping;
        private List<String> dataSetLabelMapping;
        private List<String> dataSetFeatureMaskMapping;
        private List<String> dataSetLabelMaskMapping;
        private List<String> lossVariables;
        private boolean skipValidation = false;
        private boolean markLabelsUnused = false;
        private Map<String, List<IEvaluation>> trainEvaluations = new HashMap<String, List<IEvaluation>>();
        private Map<String, Integer> trainEvaluationLabels = new HashMap<String, Integer>();
        private Map<String, List<IEvaluation>> validationEvaluations = new HashMap<String, List<IEvaluation>>();
        private Map<String, Integer> validationEvaluationLabels = new HashMap<String, Integer>();

        public Builder updater(IUpdater updater) {
            this.updater = updater;
            return this;
        }

        public Builder l1(double l1) {
            Preconditions.checkState((l1 >= 0.0 ? 1 : 0) != 0, (String)"L1 regularization coefficient must be >= 0. Got %s", (double)l1);
            TrainingConfig.removeInstances(this.regularization, L1Regularization.class);
            this.regularization.add(new L1Regularization(l1));
            return this;
        }

        public Builder l2(double l2) {
            Preconditions.checkState((l2 >= 0.0 ? 1 : 0) != 0, (String)"L2 regularization coefficient must be >= 0. Got %s", (double)l2);
            TrainingConfig.removeInstances(this.regularization, L2Regularization.class);
            if (l2 > 0.0) {
                TrainingConfig.removeInstancesWithWarning(this.regularization, WeightDecay.class, "WeightDecay regularization removed: incompatible with added L2 regularization");
                this.regularization.add(new L2Regularization(l2));
            }
            return this;
        }

        public Builder weightDecay(double coefficient, boolean applyLR) {
            TrainingConfig.removeInstances(this.regularization, WeightDecay.class);
            if (coefficient > 0.0) {
                TrainingConfig.removeInstancesWithWarning(this.regularization, L2Regularization.class, "L2 regularization removed: incompatible with added WeightDecay regularization");
                this.regularization.add(new WeightDecay(coefficient, applyLR));
            }
            return this;
        }

        public Builder addRegularization(Regularization ... regularizations) {
            Collections.addAll(this.regularization, regularizations);
            return this;
        }

        public Builder regularization(Regularization ... regularization) {
            if (regularization == null || regularization.length == 0) {
                return this;
            }
            ArrayList<Regularization> r = new ArrayList<Regularization>();
            Collections.addAll(r, regularization);
            return this.regularization(r);
        }

        public Builder regularization(List<Regularization> regularization) {
            this.regularization = regularization;
            return this;
        }

        public Builder minimize(boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public Builder dataSetFeatureMapping(String ... dataSetFeatureMapping) {
            return this.dataSetFeatureMapping(Arrays.asList(dataSetFeatureMapping));
        }

        public Builder dataSetFeatureMapping(List<String> dataSetFeatureMapping) {
            Preconditions.checkNotNull((Object)(dataSetFeatureMapping != null && dataSetFeatureMapping.size() > 0 ? 1 : 0), (String)"No feature mapping was provided");
            this.dataSetFeatureMapping = dataSetFeatureMapping;
            return this;
        }

        public Builder dataSetLabelMapping(String ... dataSetLabelMapping) {
            return this.dataSetLabelMapping(Arrays.asList(dataSetLabelMapping));
        }

        public Builder dataSetLabelMapping(List<String> dataSetLabelMapping) {
            Preconditions.checkNotNull((Object)(dataSetLabelMapping != null && dataSetLabelMapping.size() > 0 ? 1 : 0), (String)"No label mapping was provided");
            this.dataSetLabelMapping = dataSetLabelMapping;
            return this;
        }

        public Builder markLabelsUnused() {
            this.markLabelsUnused = true;
            return this;
        }

        public Builder dataSetFeatureMaskMapping(String ... dataSetFeatureMaskMapping) {
            return this.dataSetFeatureMaskMapping(Arrays.asList(dataSetFeatureMaskMapping));
        }

        public Builder dataSetFeatureMaskMapping(List<String> dataSetFeatureMaskMapping) {
            this.dataSetFeatureMaskMapping = dataSetFeatureMaskMapping;
            return this;
        }

        public Builder dataSetLabelMaskMapping(String ... dataSetLabelMaskMapping) {
            return this.dataSetLabelMaskMapping(Arrays.asList(dataSetLabelMaskMapping));
        }

        public Builder dataSetLabelMaskMapping(List<String> dataSetLabelMaskMapping) {
            this.dataSetLabelMaskMapping = dataSetLabelMaskMapping;
            return this;
        }

        public Builder skipBuilderValidation(boolean skip) {
            this.skipValidation = skip;
            return this;
        }

        public Builder minimize(String ... lossVariables) {
            this.lossVariables = Arrays.asList(lossVariables);
            return this;
        }

        private void addEvaluations(boolean validation, @NonNull Map<String, List<IEvaluation>> evaluationMap, @NonNull Map<String, Integer> labelMap, @NonNull String variableName, int labelIndex, IEvaluation ... evaluations) {
            if (evaluationMap == null) {
                throw new NullPointerException("evaluationMap is marked non-null but is null");
            }
            if (labelMap == null) {
                throw new NullPointerException("labelMap is marked non-null but is null");
            }
            if (variableName == null) {
                throw new NullPointerException("variableName is marked non-null but is null");
            }
            if (evaluations == null) {
                throw new NullPointerException("evaluations is marked non-null but is null");
            }
            if (evaluationMap.containsKey(variableName) && labelMap.get(variableName) != labelIndex) {
                String s = validation ? "This ListenerEvaluations.Builder already has validation evaluations for " : "This ListenerEvaluations.Builder already has train evaluations for ";
                throw new IllegalArgumentException(s + "variable " + variableName + " with label index " + labelIndex + ".  You can't add  evaluations with a different label index.  Got label index " + labelIndex);
            }
            if (evaluationMap.containsKey(variableName)) {
                evaluationMap.get(variableName).addAll(Arrays.asList(evaluations));
            } else {
                evaluationMap.put(variableName, Arrays.asList(evaluations));
                labelMap.put(variableName, labelIndex);
            }
        }

        public Builder trainEvaluation(@NonNull String variableName, int labelIndex, IEvaluation ... evaluations) {
            if (variableName == null) {
                throw new NullPointerException("variableName is marked non-null but is null");
            }
            if (evaluations == null) {
                throw new NullPointerException("evaluations is marked non-null but is null");
            }
            this.addEvaluations(false, this.trainEvaluations, this.trainEvaluationLabels, variableName, labelIndex, evaluations);
            return this;
        }

        public Builder trainEvaluation(@NonNull SDVariable variable, int labelIndex, IEvaluation ... evaluations) {
            if (variable == null) {
                throw new NullPointerException("variable is marked non-null but is null");
            }
            if (evaluations == null) {
                throw new NullPointerException("evaluations is marked non-null but is null");
            }
            return this.trainEvaluation(variable.name(), labelIndex, evaluations);
        }

        public Builder validationEvaluation(@NonNull String variableName, int labelIndex, IEvaluation ... evaluations) {
            if (variableName == null) {
                throw new NullPointerException("variableName is marked non-null but is null");
            }
            if (evaluations == null) {
                throw new NullPointerException("evaluations is marked non-null but is null");
            }
            this.addEvaluations(true, this.validationEvaluations, this.validationEvaluationLabels, variableName, labelIndex, evaluations);
            return this;
        }

        public Builder validationEvaluation(@NonNull SDVariable variable, int labelIndex, IEvaluation ... evaluations) {
            if (variable == null) {
                throw new NullPointerException("variable is marked non-null but is null");
            }
            if (evaluations == null) {
                throw new NullPointerException("evaluations is marked non-null but is null");
            }
            return this.validationEvaluation(variable.name(), labelIndex, evaluations);
        }

        public Builder addEvaluations(boolean validation, @NonNull String variableName, int labelIndex, IEvaluation ... evaluations) {
            if (variableName == null) {
                throw new NullPointerException("variableName is marked non-null but is null");
            }
            if (evaluations == null) {
                throw new NullPointerException("evaluations is marked non-null but is null");
            }
            if (validation) {
                return this.validationEvaluation(variableName, labelIndex, evaluations);
            }
            return this.trainEvaluation(variableName, labelIndex, evaluations);
        }

        public TrainingConfig build() {
            if (!this.skipValidation) {
                Preconditions.checkState((this.updater != null ? 1 : 0) != 0, (String)"Updater (optimizer) must not be null. Use updater(IUpdater) to set an updater");
                Preconditions.checkState((this.dataSetFeatureMapping != null ? 1 : 0) != 0, (String)"No DataSet feature mapping has been provided. A mapping between DataSet array positions and variables/placeholders must be provided - use dateSetFeatureMapping(...) to set this");
                Preconditions.checkState((this.markLabelsUnused || this.dataSetLabelMapping != null ? 1 : 0) != 0, (String)"No DataSet label mapping has been provided. A mapping between DataSet array positions and variables/placeholders must be provided - use dataSetLabelMapping(...) to set this, or use markLabelsUnused() to mark labels as unused (for example, for unsupervised learning)");
                Preconditions.checkArgument((boolean)this.trainEvaluations.keySet().equals(this.trainEvaluationLabels.keySet()), (String)"Must specify a label index for each train evaluation.  Expected: %s, got: %s", this.trainEvaluations.keySet(), this.trainEvaluationLabels.keySet());
                Preconditions.checkArgument((boolean)this.validationEvaluations.keySet().equals(this.validationEvaluationLabels.keySet()), (String)"Must specify a label index for each validation evaluation.  Expected: %s, got: %s", this.validationEvaluations.keySet(), this.validationEvaluationLabels.keySet());
            }
            return new TrainingConfig(this.updater, this.regularization, this.minimize, this.dataSetFeatureMapping, this.dataSetLabelMapping, this.dataSetFeatureMaskMapping, this.dataSetLabelMaskMapping, this.lossVariables, this.trainEvaluations, this.trainEvaluationLabels, this.validationEvaluations, this.validationEvaluationLabels);
        }
    }
}

