/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import net.ericaro.neoitertools.Generator;
import net.ericaro.neoitertools.Itertools;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.PointIndex;
import org.nd4j.linalg.util.LongUtils;

public class SpecifiedIndex
implements INDArrayIndex {
    private long[] indexes;

    public SpecifiedIndex(int ... indexes) {
        this.indexes = LongUtils.toLongs(indexes);
    }

    public SpecifiedIndex(long ... indexes) {
        this.indexes = indexes;
    }

    @Override
    public long end() {
        return this.indexes[this.indexes.length - 1];
    }

    @Override
    public long offset() {
        return this.indexes[0];
    }

    @Override
    public long length() {
        return this.indexes.length;
    }

    @Override
    public long stride() {
        return 1L;
    }

    @Override
    public void reverse() {
    }

    @Override
    public boolean isInterval() {
        return false;
    }

    @Override
    public void init(INDArray arr, long begin, int dimension) {
    }

    @Override
    public void init(INDArray arr, int dimension) {
    }

    @Override
    public void init(long begin, long end, long max) {
    }

    @Override
    public void init(long begin, long end) {
    }

    public static Generator<List<List<Long>>> iterate(INDArrayIndex ... indexes) {
        Generator gen = Itertools.product((Generator)new SpecifiedIndexesGenerator(indexes));
        return gen;
    }

    public static Generator<List<List<Long>>> iterateOverSparse(INDArrayIndex ... indexes) {
        Generator gen = Itertools.product((Generator)new SparseSpecifiedIndexesGenerator(indexes));
        return gen;
    }

    public Generator<List<Long>> generator() {
        return new SingleGenerator();
    }

    public Generator<List<Long>> sparseGenerator() {
        return new SparseSingleGenerator();
    }

    public long[] getIndexes() {
        return this.indexes;
    }

    public void setIndexes(long[] indexes) {
        this.indexes = indexes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpecifiedIndex)) {
            return false;
        }
        SpecifiedIndex other = (SpecifiedIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getIndexes(), other.getIndexes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpecifiedIndex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getIndexes());
        return result;
    }

    public String toString() {
        return "SpecifiedIndex(indexes=" + Arrays.toString(this.getIndexes()) + ")";
    }

    public class SparseSingleGenerator
    implements Generator<List<Long>> {
        public List<Long> next() throws NoSuchElementException {
            throw new RuntimeException();
        }
    }

    public class SingleGenerator
    implements Generator<List<Long>> {
        public List<Long> next() throws NoSuchElementException {
            throw new RuntimeException();
        }
    }

    public static class SparseSpecifiedIndexesGenerator
    implements Generator<Generator<List<Long>>> {
        private int index = 0;
        private INDArrayIndex[] indexes;

        public SparseSpecifiedIndexesGenerator(INDArrayIndex[] indexes) {
            this.indexes = indexes;
        }

        public Generator<List<Long>> next() throws NoSuchElementException {
            if (this.index >= this.indexes.length) {
                throw new NoSuchElementException("Done");
            }
            SpecifiedIndex specifiedIndex = (SpecifiedIndex)this.indexes[this.index++];
            Generator<List<Long>> ret = specifiedIndex.sparseGenerator();
            return ret;
        }
    }

    public static class SpecifiedIndexesGenerator
    implements Generator<Generator<List<Long>>> {
        private int index = 0;
        private INDArrayIndex[] indexes;

        public SpecifiedIndexesGenerator(INDArrayIndex[] indexes) {
            this.indexes = indexes;
            for (int i = 0; i < indexes.length; ++i) {
                if (!(indexes[i] instanceof PointIndex)) continue;
                indexes[i] = new SpecifiedIndex(indexes[i].offset());
            }
        }

        public Generator<List<Long>> next() throws NoSuchElementException {
            if (this.index >= this.indexes.length) {
                throw new NoSuchElementException("Done");
            }
            SpecifiedIndex specifiedIndex = (SpecifiedIndex)this.indexes[this.index++];
            Generator<List<Long>> ret = specifiedIndex.generator();
            return ret;
        }
    }
}

