/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.compression;

import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.compression.CompressionAlgorithm;
import org.nd4j.linalg.compression.CompressionType;
import org.nd4j.linalg.compression.NDArrayCompressor;

public class CompressionDescriptor
implements Cloneable,
Serializable {
    private CompressionType compressionType;
    private String compressionAlgorithm;
    private long originalLength;
    private long compressedLength;
    private long numberOfElements;
    private long originalElementSize;
    private DataType originalDataType;
    public static final int COMPRESSION_BYTE_BUFFER_LENGTH = 40;

    public CompressionDescriptor() {
    }

    public CompressionDescriptor(DataBuffer buffer) {
        this.originalLength = buffer.length() * (long)buffer.getElementSize();
        this.numberOfElements = buffer.length();
        this.originalElementSize = buffer.getElementSize();
        this.originalDataType = buffer.dataType();
    }

    public CompressionDescriptor(DataBuffer buffer, String algorithm) {
        this(buffer);
        this.compressionAlgorithm = algorithm;
    }

    public CompressionDescriptor(DataBuffer buffer, NDArrayCompressor compressor) {
        this(buffer, compressor.getDescriptor());
        this.compressionType = compressor.getCompressionType();
    }

    public static CompressionDescriptor fromByteBuffer(ByteBuffer byteBuffer) {
        CompressionDescriptor compressionDescriptor = new CompressionDescriptor();
        int compressionTypeOrdinal = byteBuffer.getInt();
        CompressionType compressionType = CompressionType.values()[compressionTypeOrdinal];
        compressionDescriptor.setCompressionType(compressionType);
        int compressionAlgoOrdinal = byteBuffer.getInt();
        CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.values()[compressionAlgoOrdinal];
        compressionDescriptor.setCompressionAlgorithm(compressionAlgorithm.name());
        compressionDescriptor.setOriginalLength(byteBuffer.getLong());
        compressionDescriptor.setCompressedLength(byteBuffer.getLong());
        compressionDescriptor.setNumberOfElements(byteBuffer.getLong());
        compressionDescriptor.setOriginalElementSize(byteBuffer.getLong());
        compressionDescriptor.setOriginalDataType(DataType.values()[byteBuffer.getInt()]);
        return compressionDescriptor;
    }

    public ByteBuffer toByteBuffer() {
        int enumSize = 12;
        int sizesLength = 32;
        ByteBuffer directAlloc = ByteBuffer.allocateDirect(enumSize + sizesLength).order(ByteOrder.nativeOrder());
        directAlloc.putInt(this.compressionType.ordinal());
        directAlloc.putInt(CompressionAlgorithm.valueOf(this.compressionAlgorithm).ordinal());
        directAlloc.putLong(this.originalLength);
        directAlloc.putLong(this.compressedLength);
        directAlloc.putLong(this.numberOfElements);
        directAlloc.putLong(this.originalElementSize);
        directAlloc.putInt(this.originalDataType.ordinal());
        ((Buffer)directAlloc).rewind();
        return directAlloc;
    }

    public CompressionDescriptor clone() {
        CompressionDescriptor descriptor = new CompressionDescriptor();
        descriptor.compressionType = this.compressionType;
        descriptor.compressionAlgorithm = this.compressionAlgorithm;
        descriptor.originalLength = this.originalLength;
        descriptor.compressedLength = this.compressedLength;
        descriptor.numberOfElements = this.numberOfElements;
        descriptor.originalElementSize = this.originalElementSize;
        descriptor.originalDataType = this.originalDataType;
        return descriptor;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public String getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public long getOriginalLength() {
        return this.originalLength;
    }

    public long getCompressedLength() {
        return this.compressedLength;
    }

    public long getNumberOfElements() {
        return this.numberOfElements;
    }

    public long getOriginalElementSize() {
        return this.originalElementSize;
    }

    public DataType getOriginalDataType() {
        return this.originalDataType;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public void setCompressionAlgorithm(String compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public void setOriginalLength(long originalLength) {
        this.originalLength = originalLength;
    }

    public void setCompressedLength(long compressedLength) {
        this.compressedLength = compressedLength;
    }

    public void setNumberOfElements(long numberOfElements) {
        this.numberOfElements = numberOfElements;
    }

    public void setOriginalElementSize(long originalElementSize) {
        this.originalElementSize = originalElementSize;
    }

    public void setOriginalDataType(DataType originalDataType) {
        this.originalDataType = originalDataType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompressionDescriptor)) {
            return false;
        }
        CompressionDescriptor other = (CompressionDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CompressionType this$compressionType = this.getCompressionType();
        CompressionType other$compressionType = other.getCompressionType();
        if (this$compressionType == null ? other$compressionType != null : !((Object)((Object)this$compressionType)).equals((Object)other$compressionType)) {
            return false;
        }
        String this$compressionAlgorithm = this.getCompressionAlgorithm();
        String other$compressionAlgorithm = other.getCompressionAlgorithm();
        if (this$compressionAlgorithm == null ? other$compressionAlgorithm != null : !this$compressionAlgorithm.equals(other$compressionAlgorithm)) {
            return false;
        }
        if (this.getOriginalLength() != other.getOriginalLength()) {
            return false;
        }
        if (this.getCompressedLength() != other.getCompressedLength()) {
            return false;
        }
        if (this.getNumberOfElements() != other.getNumberOfElements()) {
            return false;
        }
        if (this.getOriginalElementSize() != other.getOriginalElementSize()) {
            return false;
        }
        DataType this$originalDataType = this.getOriginalDataType();
        DataType other$originalDataType = other.getOriginalDataType();
        return !(this$originalDataType == null ? other$originalDataType != null : !this$originalDataType.equals(other$originalDataType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompressionDescriptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CompressionType $compressionType = this.getCompressionType();
        result = result * 59 + ($compressionType == null ? 43 : ((Object)((Object)$compressionType)).hashCode());
        String $compressionAlgorithm = this.getCompressionAlgorithm();
        result = result * 59 + ($compressionAlgorithm == null ? 43 : $compressionAlgorithm.hashCode());
        long $originalLength = this.getOriginalLength();
        result = result * 59 + (int)($originalLength >>> 32 ^ $originalLength);
        long $compressedLength = this.getCompressedLength();
        result = result * 59 + (int)($compressedLength >>> 32 ^ $compressedLength);
        long $numberOfElements = this.getNumberOfElements();
        result = result * 59 + (int)($numberOfElements >>> 32 ^ $numberOfElements);
        long $originalElementSize = this.getOriginalElementSize();
        result = result * 59 + (int)($originalElementSize >>> 32 ^ $originalElementSize);
        DataType $originalDataType = this.getOriginalDataType();
        result = result * 59 + ($originalDataType == null ? 43 : $originalDataType.hashCode());
        return result;
    }

    public String toString() {
        return "CompressionDescriptor(compressionType=" + (Object)((Object)this.getCompressionType()) + ", compressionAlgorithm=" + this.getCompressionAlgorithm() + ", originalLength=" + this.getOriginalLength() + ", compressedLength=" + this.getCompressedLength() + ", numberOfElements=" + this.getNumberOfElements() + ", originalElementSize=" + this.getOriginalElementSize() + ", originalDataType=" + this.getOriginalDataType() + ")";
    }
}

