/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.rng.distribution.impl;

import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Svd;
import org.nd4j.linalg.api.ops.random.impl.GaussianDistribution;
import org.nd4j.linalg.api.rng.distribution.BaseDistribution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrthogonalDistribution
extends BaseDistribution {
    private static final Logger log = LoggerFactory.getLogger(OrthogonalDistribution.class);
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private double gain;
    private INDArray gains;

    public OrthogonalDistribution(double gain) {
        this.gain = gain;
        this.random = Nd4j.getRandom();
    }

    public double getMean() {
        throw new UnsupportedOperationException();
    }

    public double getStandardDeviation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double density(double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double cumulativeProbability(double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double inverseCumulativeProbability(double p) throws OutOfRangeException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public double cumulativeProbability(double x0, double x1) throws NumberIsTooLargeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double probability(double x0, double x1) throws NumberIsTooLargeException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getNumericalMean() {
        return this.getMean();
    }

    @Override
    public double getNumericalVariance() {
        double s = this.getStandardDeviation();
        return s * s;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    @Override
    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public double sample() {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray sample(int[] shape) {
        return this.sample(ArrayUtil.toLongArray((int[])shape));
    }

    @Override
    public INDArray sample(long[] shape) {
        long numRows = 1L;
        for (int i = 0; i < shape.length - 1; ++i) {
            numRows *= shape[i];
        }
        long numCols = shape[shape.length - 1];
        DataType dtype = Nd4j.defaultFloatingPointType();
        long[] flatShape = new long[]{numRows, numCols};
        INDArray flatRng = Nd4j.getExecutioner().exec(new GaussianDistribution(Nd4j.createUninitialized(dtype, flatShape, Nd4j.order().charValue()), 0.0, 1.0), this.random);
        int m = flatRng.rows();
        int n = flatRng.columns();
        INDArray s = Nd4j.create(dtype, m < n ? (long)m : (long)n);
        INDArray u = Nd4j.create(dtype, m, m);
        INDArray v = Nd4j.create(dtype, new long[]{n, n}, 'f');
        Nd4j.exec(new Svd(flatRng, true, s, u, v));
        if (this.gains == null) {
            if ((long)u.rows() >= numRows && (long)u.columns() >= numCols) {
                return u.get(NDArrayIndex.interval(0L, numRows), NDArrayIndex.interval(0L, numCols)).mul(this.gain).reshape(shape);
            }
            return v.get(NDArrayIndex.interval(0L, numRows), NDArrayIndex.interval(0L, numCols)).mul(this.gain).reshape(shape);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray sample(INDArray target) {
        return target.assign(this.sample(target.shape()));
    }
}

