/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.gradient;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class SoftmaxBp
extends DynamicCustomOp {
    public SoftmaxBp() {
    }

    public SoftmaxBp(SameDiff sd, SDVariable input, SDVariable grad, Integer dimension) {
        super(null, sd, new SDVariable[]{input, grad});
        if (dimension != null) {
            this.addIArgument(dimension);
        }
    }

    public SoftmaxBp(@NonNull INDArray input, @NonNull INDArray grad, Integer dimension) {
        this(input, grad, null, dimension);
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (grad == null) {
            throw new NullPointerException("grad is marked @NonNull but is null");
        }
    }

    public SoftmaxBp(@NonNull INDArray input, @NonNull INDArray grad, INDArray output, Integer dimension) {
        super(new INDArray[]{input, grad}, SoftmaxBp.wrapOrNull(output));
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (grad == null) {
            throw new NullPointerException("grad is marked @NonNull but is null");
        }
        if (dimension != null) {
            this.addIArgument(dimension);
        }
    }

    @Override
    public String opName() {
        return "softmax_bp";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        throw new UnsupportedOperationException("Differentiating op softmax_bp not supported");
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 2 ? 1 : 0) != 0, (String)"Expected exactly 2 inputs datatype for %s, got %s", this.getClass(), dataTypes);
        Preconditions.checkState((boolean)dataTypes.get(0).isFPType(), (String)"Input 0 must be a floating point type, got %s", (Object)dataTypes.get(0));
        Preconditions.checkState((boolean)dataTypes.get(1).isFPType(), (String)"Input 1 must be a floating point type, got %s", (Object)dataTypes.get(1));
        Preconditions.checkState((dataTypes.get(0) == dataTypes.get(1) ? 1 : 0) != 0, (String)"Both input must be same type: got %s", dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

