/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.gradient;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class LeakyReLUBp
extends DynamicCustomOp {
    public static final double DEFAULT_ALPHA = 0.01;
    private double alpha = 0.01;

    public LeakyReLUBp() {
    }

    public LeakyReLUBp(SameDiff sd, SDVariable input, SDVariable gradient, double alpha) {
        super(sd, new SDVariable[]{input, gradient});
        this.alpha = alpha;
        this.addTArgument(alpha);
    }

    public LeakyReLUBp(@NonNull INDArray input, @NonNull INDArray gradient, INDArray output, double alpha) {
        super(new INDArray[]{input, gradient}, LeakyReLUBp.wrapOrNull(output));
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (gradient == null) {
            throw new NullPointerException("gradient is marked @NonNull but is null");
        }
        this.alpha = alpha;
        this.addTArgument(alpha);
    }

    @Override
    public String opName() {
        return "lrelu_bp";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkArgument((dataTypes != null && dataTypes.size() == 2 ? 1 : 0) != 0, (String)"Expected exactly 2 input datatypes, got %s", dataTypes);
        Preconditions.checkArgument((dataTypes.get(0).isFPType() && dataTypes.get(1).isFPType() ? 1 : 0) != 0, (String)"Input datatypes must be floating point, got %s", dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Not supported");
    }
}

