/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.gradient;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class DynamicPartitionBp
extends DynamicCustomOp {
    private int numPartitions;

    public DynamicPartitionBp() {
    }

    public DynamicPartitionBp(SameDiff sameDiff, SDVariable input, SDVariable partitions, SDVariable[] gradsAtOutput, int numPartitions) {
        super(null, sameDiff, DynamicPartitionBp.argsArray(input, partitions, gradsAtOutput), false);
        this.numPartitions = numPartitions;
        this.addArgs();
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        throw new UnsupportedOperationException("Backprop not supported");
    }

    protected void addArgs() {
        this.addIArgument(this.numPartitions);
    }

    @Override
    public String opName() {
        return "dynamic_partition_bp";
    }

    @Override
    public int getNumOutputs() {
        return 2;
    }

    private static SDVariable[] argsArray(SDVariable input, SDVariable partitions, SDVariable[] grads) {
        SDVariable[] out = new SDVariable[grads.length + 2];
        out[0] = input;
        out[1] = partitions;
        System.arraycopy(grads, 0, out, 2, grads.length);
        return out;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        return Arrays.asList(dataTypes.get(0), dataTypes.get(1));
    }
}

