/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.dtype;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.serde.FlatBuffersMapper;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.converters.DifferentialFunctionClassHolder;
import org.nd4j.imports.descriptors.properties.AttributeAdapter;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.descriptors.properties.adapters.DataTypeAdapter;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.impl.transforms.BaseDynamicTransformOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Cast
extends BaseDynamicTransformOp {
    private DataType typeDst;

    public Cast() {
    }

    public Cast(SameDiff sameDiff, SDVariable arg, @NonNull DataType dst) {
        super(sameDiff, new SDVariable[]{arg}, false);
        if (dst == null) {
            throw new NullPointerException("dst is marked @NonNull but is null");
        }
        this.typeDst = dst;
        this.addArgs();
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    protected void addArgs() {
        this.addIArgument(new int[]{FlatBuffersMapper.getDataTypeAsByte(this.typeDst)});
    }

    @Override
    public Map<String, Map<String, AttributeAdapter>> attributeAdaptersForFunction() {
        LinkedHashMap<String, Map<String, AttributeAdapter>> ret = new LinkedHashMap<String, Map<String, AttributeAdapter>>();
        LinkedHashMap<String, DataTypeAdapter> tfAdapters = new LinkedHashMap<String, DataTypeAdapter>();
        Map<String, Field> fields = DifferentialFunctionClassHolder.getInstance().getFieldsForFunction(this);
        tfAdapters.put("typeDst", new DataTypeAdapter());
        ret.put(this.tensorflowName(), tfAdapters);
        return ret;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping dstMapping = PropertyMapping.builder().tfAttrName("DstT").propertyNames(new String[]{"typeDst"}).build();
        for (PropertyMapping propertyMapping : new PropertyMapping[]{dstMapping}) {
            for (String keys : propertyMapping.getPropertyNames()) {
                map.put(keys, propertyMapping);
            }
        }
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void setValueFor(Field target, Object value) {
        if (value == null || value instanceof String || value instanceof DataType) {
            super.setValueFor(target, value);
        }
    }

    @Override
    public String opName() {
        return "cast";
    }

    @Override
    public String tensorflowName() {
        return "Cast";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        if (this.arg().dataType().isFPType()) {
            return Collections.singletonList(i_v.get(0).castTo(this.arg().dataType()));
        }
        return Collections.singletonList(this.f().zerosLike(this.arg()));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got input %s", this.getClass(), dataTypes);
        return Collections.singletonList(this.typeDst);
    }
}

