/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class Trace
extends DynamicCustomOp {
    public Trace(SameDiff sd, SDVariable in) {
        super(null, sd, new SDVariable[]{in});
    }

    public Trace(@NonNull INDArray in) {
        super(Trace.wrapOrNull(in), null);
        if (in == null) {
            throw new NullPointerException("in is marked @NonNull but is null");
        }
    }

    public Trace() {
    }

    @Override
    public String opName() {
        return "trace";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradAtOutput) {
        SDVariable rows = this.f().reshape(this.f().sizeAt(this.arg(), -2), new long[]{1L});
        SDVariable cols = this.f().reshape(this.f().sizeAt(this.arg(), -1), new long[]{1L});
        SDVariable eye = this.sameDiff.math().eye(this.f().shape(gradAtOutput.get(0)), rows, cols);
        SDVariable reshapedGrad = this.f().expandDims(gradAtOutput.get(0), -1);
        reshapedGrad = this.f().expandDims(reshapedGrad, -1);
        return Collections.singletonList(reshapedGrad.mul(eye));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

