/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class SpaceToBatch
extends DynamicCustomOp {
    protected int[] blocks;
    protected int[][] padding;

    public SpaceToBatch() {
    }

    public SpaceToBatch(SameDiff sameDiff, SDVariable[] args, int[] blocks, int[][] padding, boolean inPlace) {
        super(null, sameDiff, args, inPlace);
        this.blocks = blocks;
        this.padding = padding;
        for (int b : blocks) {
            this.addIArgument(b);
        }
        for (int e = 0; e < padding.length; ++e) {
            this.addIArgument(padding[e][0], padding[e][1]);
        }
    }

    @Override
    public String opName() {
        return "space_to_batch";
    }

    @Override
    public String onnxName() {
        return "space_to_batch";
    }

    @Override
    public String tensorflowName() {
        return "SpaceToBatch";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable gradient = this.sameDiff.setupFunction(i_v.get(0));
        return Arrays.asList(this.sameDiff.cnn().batchToSpace(gradient, this.blocks, this.padding));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        return Collections.singletonList(dataTypes.get(0));
    }
}

