/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.BaseDynamicTransformOp;

public class SoftMax
extends BaseDynamicTransformOp {
    private int dimension = 1;

    public SoftMax() {
    }

    public SoftMax(SameDiff sameDiff, SDVariable[] args) {
        super(sameDiff, args, false);
    }

    public SoftMax(SameDiff sameDiff, SDVariable[] args, boolean inPlace) {
        super(sameDiff, args, inPlace);
    }

    public SoftMax(SameDiff sameDiff, SDVariable[] args, int dimension) {
        super(sameDiff, args, false);
        this.dimension = dimension;
        this.addIArgument(dimension);
    }

    public SoftMax(SameDiff sameDiff, SDVariable[] args, int dimension, boolean inPlace) {
        super(sameDiff, args, inPlace);
        this.dimension = dimension;
        this.addIArgument(dimension);
    }

    public SoftMax(@NonNull INDArray input, int dimension) {
        this(input, null, dimension);
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
    }

    public SoftMax(INDArray input, INDArray result, int dimension) {
        super(new INDArray[]{input}, SoftMax.wrapOrNull(result));
        this.dimension = dimension;
        this.addIArgument(dimension);
    }

    public SoftMax(INDArray input) {
        this(input, input);
    }

    public SoftMax(INDArray input, INDArray result) {
        this(input, result, -1);
    }

    @Override
    public String opName() {
        return "softmax";
    }

    @Override
    public String onnxName() {
        return "Softmax";
    }

    @Override
    public String tensorflowName() {
        return "Softmax";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable ret = this.f().softmaxDerivative(this.arg(), i_v.get(0), this.dimension);
        return Collections.singletonList(ret);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got %s", this.getClass(), dataTypes);
        Preconditions.checkState((boolean)dataTypes.get(0).isFPType(), (String)"Input must be a floating point type, got %s", (Object)dataTypes.get(0));
        return Collections.singletonList(dataTypes.get(0));
    }
}

