/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class MatrixInverse
extends DynamicCustomOp {
    public MatrixInverse() {
    }

    public MatrixInverse(@NonNull INDArray input) {
        super(new INDArray[]{input}, null);
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
    }

    public MatrixInverse(SameDiff sameDiff, SDVariable in, boolean inPlace) {
        super(null, sameDiff, new SDVariable[]{in}, inPlace);
    }

    @Override
    public String opName() {
        return "matrix_inverse";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"MatrixInverse", "BatchMatrixInverse"};
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable dOutdIn = this.outputVariable().mmul(this.outputVariable()).neg();
        return Collections.singletonList(i_v.get(0).mul(dOutdIn));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got %s", this.getClass(), dataTypes);
        Preconditions.checkState((boolean)dataTypes.get(0).isFPType(), (String)"Input datatype must be a floating point type, got %s", (Object)dataTypes.get(0));
        return Collections.singletonList(dataTypes.get(0));
    }
}

