/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class FakeQuantWithMinMaxArgs
extends DynamicCustomOp {
    protected boolean narrowRange;
    protected int numBits;
    protected float min;
    protected float max;

    public FakeQuantWithMinMaxArgs(SameDiff sd, SDVariable input, float min, float max, boolean narrowRange, int numBits) {
        super(sd, input);
        Preconditions.checkState((numBits >= 2 && numBits <= 16 ? 1 : 0) != 0, (String)"NumBits arg must be in range 2 to 16 inclusive, got %s", (int)numBits);
        this.narrowRange = narrowRange;
        this.numBits = numBits;
        this.min = min;
        this.max = max;
        this.addArgs();
    }

    public FakeQuantWithMinMaxArgs(INDArray x, INDArray min, INDArray max, int num_bits, boolean narrow) {
        Preconditions.checkArgument((min.isVector() && max.isVector() && min.length() == max.length() ? 1 : 0) != 0, (String)"FakeQuantWithMinMaxArgs: min and max should be 1D tensors with the same length");
        this.addInputArgument(x, min, max);
        this.addIArgument(num_bits);
        this.addBArgument(narrow);
    }

    public FakeQuantWithMinMaxArgs() {
    }

    protected void addArgs() {
        this.iArguments.clear();
        this.addIArgument(this.numBits);
        this.addBArgument(this.narrowRange);
        this.addTArgument(this.min, this.max);
    }

    @Override
    public String opName() {
        return "fake_quant_with_min_max_args";
    }

    @Override
    public String tensorflowName() {
        return "FakeQuantWithMinMaxArgs";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (attributesForNode.containsKey("narrow_range")) {
            this.narrowRange = attributesForNode.get("narrow_range").getB();
        }
        this.numBits = (int)attributesForNode.get("num_bits").getI();
        this.min = attributesForNode.get("min").getF();
        this.max = attributesForNode.get("max").getF();
        this.addArgs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input, got %s", inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradients) {
        return Arrays.asList(this.sameDiff.zerosLike(this.arg(0)), this.sameDiff.zerosLike(this.arg(1)), this.sameDiff.zerosLike(this.arg(2)));
    }
}

