/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.descriptors.properties.AttributeAdapter;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.descriptors.properties.adapters.BooleanAdapter;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class CumSum
extends DynamicCustomOp {
    protected boolean exclusive = false;
    protected boolean reverse = false;
    protected int[] jaxis = new int[0];

    public CumSum() {
    }

    public CumSum(SameDiff sameDiff, SDVariable x, int ... axis) {
        this(sameDiff, x, false, false, axis);
    }

    public CumSum(SameDiff sameDiff, SDVariable x, boolean exclusive, boolean reverse, int ... axis) {
        super(null, sameDiff, new SDVariable[]{x});
        this.sameDiff = sameDiff;
        this.exclusive = exclusive;
        this.reverse = reverse;
        this.jaxis = axis;
        this.addArgs();
    }

    public CumSum(INDArray in, INDArray result, boolean exclusive, boolean reverse, int ... axis) {
        super(null, new INDArray[]{in}, new INDArray[]{result}, null, (List<Integer>)null);
        this.exclusive = exclusive;
        this.reverse = reverse;
        this.jaxis = axis;
        this.addArgs();
    }

    @Override
    public String opName() {
        return "cumsum";
    }

    @Override
    public String tensorflowName() {
        return "Cumsum";
    }

    @Override
    public Map<String, Map<String, AttributeAdapter>> attributeAdaptersForFunction() {
        HashMap<String, Map<String, AttributeAdapter>> ret = new HashMap<String, Map<String, AttributeAdapter>>();
        LinkedHashMap<String, BooleanAdapter> tfMappings = new LinkedHashMap<String, BooleanAdapter>();
        tfMappings.put("exclusive", new BooleanAdapter());
        tfMappings.put("reverse", new BooleanAdapter());
        ret.put(this.tensorflowName(), tfMappings);
        return ret;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping exclusiveMapper = PropertyMapping.builder().tfAttrName("exclusive").propertyNames(new String[]{"exclusive"}).build();
        PropertyMapping reverseMapper = PropertyMapping.builder().tfAttrName("reverse").propertyNames(new String[]{"reverse"}).build();
        map.put("exclusive", exclusiveMapper);
        map.put("reverse", reverseMapper);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    protected void addArgs() {
        this.addIArgument(this.exclusive ? 1 : 0, this.reverse ? 1 : 0);
        for (int a : this.jaxis) {
            this.addIArgument(this.jaxis);
        }
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
        super.initFromOnnx(node, initWith, attributesForNode, graph);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        return Collections.singletonList(this.f().cumsumBp(this.arg(0), grad.get(0), this.exclusive, this.reverse, this.jaxis));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && (dataTypes.size() == 1 || dataTypes.size() == 2) ? 1 : 0) != 0, (String)"Expected 1 or 2 input datatype for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

