/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.LSTMConfiguration;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.weights.LSTMWeights;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class LSTMBlockCell
extends DynamicCustomOp {
    private LSTMConfiguration configuration;
    private LSTMWeights weights;

    public LSTMBlockCell() {
    }

    public LSTMBlockCell(SameDiff sameDiff, SDVariable x, SDVariable cLast, SDVariable yLast, LSTMWeights weights, LSTMConfiguration configuration) {
        super(null, sameDiff, weights.argsWithInputs(x, cLast, yLast));
        this.configuration = configuration;
        this.weights = weights;
        this.addIArgument(configuration.iArgs(false));
        this.addTArgument(configuration.tArgs());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 8 ? 1 : 0) != 0, (String)"Expected exactly 8 inputs to LSTMBlockCell, got %s", inputDataTypes);
        DataType dt = inputDataTypes.get(0);
        Preconditions.checkState((boolean)dt.isFPType(), (String)"Input type 0 must be a floating point type, got %s", (Object)dt);
        return Arrays.asList(dt, dt, dt, dt, dt, dt, dt);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grads) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        this.configuration = LSTMConfiguration.builder().forgetBias(attributesForNode.get("forget_bias").getF()).clippingCellValue(attributesForNode.get("cell_clip").getF()).peepHole(attributesForNode.get("use_peephole").getB()).build();
        this.addIArgument(this.configuration.iArgs(false));
        this.addTArgument(this.configuration.tArgs());
    }

    @Override
    public String opName() {
        return "lstmBlockCell";
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.configuration.toProperties(false);
    }

    @Override
    public String tensorflowName() {
        return "LSTMBlockCell";
    }

    public LSTMWeights getWeights() {
        return this.weights;
    }
}

