/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class MatrixBandPart
extends DynamicCustomOp {
    public MatrixBandPart() {
    }

    public MatrixBandPart(@NonNull INDArray input, int minLower, int maxUpper) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        Preconditions.checkArgument((input.rank() >= 2 ? 1 : 0) != 0, (String)"MatrixBandPart: Input rank should be 2 or higher");
        long N = input.size(-2);
        long M = input.size(-1);
        Preconditions.checkArgument(((long)minLower > -N && (long)minLower < N ? 1 : 0) != 0, (String)"MatrixBandPart: lower diagonal count %s should be less than %s", (long)minLower, (long)N);
        Preconditions.checkArgument(((long)maxUpper > -M && (long)maxUpper < M ? 1 : 0) != 0, (String)"MatrixBandPart: upper diagonal count %s should be less than %s.", (long)maxUpper, (long)M);
        this.addInputArgument(input);
        this.addIArgument(minLower, maxUpper);
    }

    public MatrixBandPart(@NonNull SameDiff sameDiff, @NonNull SDVariable input, SDVariable minLower, SDVariable maxUpper) {
        super("", sameDiff, new SDVariable[]{input, minLower, maxUpper});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked @NonNull but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
    }

    @Override
    public String opName() {
        return "matrix_band_part";
    }

    @Override
    public String tensorflowName() {
        return "MatrixBandPart";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

