/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class FusedBatchNorm
extends DynamicCustomOp {
    public FusedBatchNorm() {
    }

    public FusedBatchNorm(@NonNull INDArray x, @NonNull INDArray scale, @NonNull INDArray offset, int dataFormat, int isTraining, INDArray yOut, INDArray batchMeanOut, INDArray batchMeanVar) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (scale == null) {
            throw new NullPointerException("scale is marked @NonNull but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked @NonNull but is null");
        }
        this.addInputArgument(x, scale, offset);
        this.addIArgument(dataFormat, isTraining);
        if (yOut != null && batchMeanOut != null && batchMeanVar != null) {
            this.addOutputArgument(yOut, batchMeanOut, batchMeanVar);
        }
    }

    public FusedBatchNorm(@NonNull SameDiff sameDiff, @NonNull SDVariable x, @NonNull SDVariable scale, @NonNull SDVariable offset, @NonNull SDVariable dataFormat, @NonNull SDVariable isTraining) {
        super("", sameDiff, new SDVariable[]{x, scale, offset, dataFormat, isTraining});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked @NonNull but is null");
        }
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (scale == null) {
            throw new NullPointerException("scale is marked @NonNull but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked @NonNull but is null");
        }
        if (dataFormat == null) {
            throw new NullPointerException("dataFormat is marked @NonNull but is null");
        }
        if (isTraining == null) {
            throw new NullPointerException("isTraining is marked @NonNull but is null");
        }
    }

    @Override
    public String opName() {
        return "fused_batch_norm";
    }

    @Override
    public String tensorflowName() {
        return "FusedBatchNormV2";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

