/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class AdjustHue
extends DynamicCustomOp {
    public AdjustHue() {
    }

    public AdjustHue(@NonNull INDArray in, double delta, INDArray out) {
        this(in, delta);
        if (in == null) {
            throw new NullPointerException("in is marked @NonNull but is null");
        }
        if (out != null) {
            this.outputArguments.add(out);
        }
    }

    public AdjustHue(@NonNull INDArray in, double delta) {
        if (in == null) {
            throw new NullPointerException("in is marked @NonNull but is null");
        }
        Preconditions.checkArgument((in.rank() >= 3 ? 1 : 0) != 0, (String)"AdjustSaturation: op expects rank of input array to be >= 3, but got %s instead", (int)in.rank());
        Preconditions.checkArgument((-1.0 <= delta && delta <= 1.0 ? 1 : 0) != 0, (String)"AdjustHue: parameter delta must be within [-1, 1] interval, but got %s instead", (double)delta);
        this.inputArguments.add(in);
        this.addTArgument(delta);
    }

    public AdjustHue(@NonNull SameDiff sameDiff, @NonNull SDVariable in, @NonNull SDVariable factor) {
        super(sameDiff, new SDVariable[]{in, factor});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked @NonNull but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked @NonNull but is null");
        }
        if (factor == null) {
            throw new NullPointerException("factor is marked @NonNull but is null");
        }
    }

    @Override
    public String opName() {
        return "adjust_hue";
    }

    @Override
    public String tensorflowName() {
        return "AdjustHue";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

