/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformFloatOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseTransformFloatOp
extends BaseTransformOp
implements TransformFloatOp {
    public BaseTransformFloatOp(SameDiff sameDiff, SDVariable i_v, boolean inPlace) {
        super(sameDiff, i_v, inPlace);
    }

    public BaseTransformFloatOp(SameDiff sameDiff, SDVariable i_v, long[] shape, boolean inPlace, Object[] extraArgs) {
        super(sameDiff, i_v, shape, inPlace, extraArgs);
    }

    public BaseTransformFloatOp(SameDiff sameDiff, SDVariable i_v, Object[] extraArgs) {
        super(sameDiff, i_v, extraArgs);
    }

    public BaseTransformFloatOp(INDArray x, INDArray z) {
        super(x, z);
    }

    public BaseTransformFloatOp() {
    }

    public BaseTransformFloatOp(INDArray x) {
        super(x);
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.TRANSFORM_FLOAT;
    }

    @Override
    public Op.Type opType() {
        return Op.Type.TRANSFORM_FLOAT;
    }

    @Override
    public DataType resultType() {
        if (this.x() != null && this.x().isR()) {
            return this.x().dataType();
        }
        return Nd4j.defaultFloatingPointType();
    }

    @Override
    public boolean validateDataTypes(boolean experimentalMode) {
        if (this.y() != null && !experimentalMode) {
            Preconditions.checkArgument((this.x.dataType() == this.y.dataType() ? 1 : 0) != 0, (String)"Op.X must have same data type as Op.Y");
        }
        if (this.z() != null) {
            Preconditions.checkArgument((boolean)this.z().isR(), (String)"Op.Z must be one of floating types: z.datatype=%s for op %s", (Object)this.z().dataType(), this.getClass());
        }
        return true;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.x == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(LongShapeDescriptor.fromShape(this.x.shape(), this.x.isR() ? this.x.dataType() : Nd4j.defaultFloatingPointType()));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got input %s", this.getClass(), dataTypes);
        if (dataTypes.get(0).isFPType()) {
            return Collections.singletonList(dataTypes.get(0));
        }
        return Collections.singletonList(DataType.FLOAT);
    }
}

