/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.ops.SDOps;
import org.nd4j.autodiff.samediff.ops.SDValidation;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.impl.shape.ConfusionMatrix;
import org.nd4j.linalg.api.ops.impl.shape.Eye;
import org.nd4j.linalg.indexing.conditions.Condition;

public class SDMath
extends SDOps {
    public SDMath(SameDiff sameDiff) {
        super(sameDiff);
    }

    public SDVariable abs(SDVariable x) {
        return this.abs(null, x);
    }

    public SDVariable abs(String name, SDVariable x) {
        SDValidation.validateNumerical("abs", x);
        SDVariable result = this.f().abs(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable acos(SDVariable x) {
        return this.acos(null, x);
    }

    public SDVariable acos(String name, SDVariable x) {
        SDValidation.validateNumerical("acos", x);
        SDVariable result = this.f().acos(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable acosh(SDVariable x) {
        return this.acosh(null, x);
    }

    public SDVariable acosh(String name, SDVariable x) {
        SDValidation.validateNumerical("acosh", x);
        SDVariable result = this.f().acosh(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable amax(SDVariable in, int ... dimensions) {
        return this.amax(null, in, dimensions);
    }

    public SDVariable amax(String name, SDVariable in, int ... dimensions) {
        SDValidation.validateNumerical("amax", in);
        SDVariable ret = this.f().amax(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable amean(SDVariable in, int ... dimensions) {
        SDValidation.validateNumerical("amean", in);
        return this.amean(null, in, dimensions);
    }

    public SDVariable amean(String name, SDVariable in, int ... dimensions) {
        SDValidation.validateNumerical("amean", in);
        SDVariable ret = this.f().amean(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable amin(SDVariable in, int ... dimensions) {
        return this.amin(null, in, dimensions);
    }

    public SDVariable amin(String name, SDVariable in, int ... dimensions) {
        SDValidation.validateNumerical("amin", in);
        SDVariable ret = this.f().amin(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable and(SDVariable x, SDVariable y) {
        return this.and(null, x, y);
    }

    public SDVariable and(String name, SDVariable x, SDVariable y) {
        SDValidation.validateBool("boolean and", x, y);
        SDVariable result = this.f().and(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable asin(SDVariable x) {
        return this.asin(null, x);
    }

    public SDVariable asin(String name, SDVariable x) {
        SDValidation.validateNumerical("asin", x);
        SDVariable result = this.f().asin(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable asinh(SDVariable x) {
        return this.asinh(null, x);
    }

    public SDVariable asinh(String name, SDVariable x) {
        SDValidation.validateNumerical("asinh", x);
        SDVariable result = this.f().asinh(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable asum(SDVariable in, int ... dimensions) {
        return this.asum(null, in, dimensions);
    }

    public SDVariable asum(String name, SDVariable in, int ... dimensions) {
        SDValidation.validateNumerical("asum", in);
        SDVariable ret = this.f().asum(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable atan(SDVariable x) {
        return this.atan(null, x);
    }

    public SDVariable atan(String name, SDVariable x) {
        SDValidation.validateNumerical("atan", x);
        SDVariable result = this.f().atan(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable atan2(SDVariable y, SDVariable x) {
        return this.atan2(null, y, x);
    }

    public SDVariable atan2(String name, SDVariable y, SDVariable x) {
        SDValidation.validateNumerical("atan2", y, x);
        SDVariable ret = this.f().atan2(y, x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable atanh(SDVariable x) {
        return this.atanh(null, x);
    }

    public SDVariable atanh(String name, SDVariable x) {
        SDValidation.validateNumerical("atanh", x);
        SDVariable result = this.f().atanh(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable ceil(SDVariable x) {
        return this.ceil(null, x);
    }

    public SDVariable ceil(String name, SDVariable x) {
        SDValidation.validateFloatingPoint("ceil", x);
        SDVariable ret = this.f().ceil(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable clipByNorm(SDVariable x, double clipValue) {
        return this.clipByNorm(null, x, clipValue);
    }

    public SDVariable clipByNorm(String name, SDVariable x, double clipValue) {
        SDValidation.validateFloatingPoint("clip by norm", x);
        SDVariable ret = this.f().clipByNorm(x, clipValue);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable clipByNorm(SDVariable x, double clipValue, int ... dimensions) {
        return this.clipByNorm(null, x, clipValue, dimensions);
    }

    public SDVariable clipByNorm(String name, SDVariable x, double clipValue, int ... dimensions) {
        SDValidation.validateFloatingPoint("clip by norm", x);
        SDVariable ret = this.f().clipByNorm(x, clipValue, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable clipByValue(SDVariable x, double clipValueMin, double clipValueMax) {
        return this.clipByValue(null, x, clipValueMin, clipValueMax);
    }

    public SDVariable clipByValue(String name, SDVariable x, double clipValueMin, double clipValueMax) {
        SDValidation.validateNumerical("clip by value", x);
        SDVariable ret = this.f().clipByValue(x, clipValueMin, clipValueMax);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable predictions) {
        return this.confusionMatrix((String)null, labels, predictions);
    }

    public SDVariable confusionMatrix(String name, SDVariable labels, SDVariable pred) {
        return this.confusionMatrix(name, labels, pred, ConfusionMatrix.DEFAULT_DTYPE);
    }

    public SDVariable confusionMatrix(String name, SDVariable labels, SDVariable pred, DataType dataType) {
        SDValidation.validateInteger("confusionMatrix", "labels", labels);
        SDValidation.validateInteger("confusionMatrix", "prediction", pred);
        SDVariable result = this.f().confusionMatrix(labels, pred, dataType);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable pred, Integer numClasses) {
        return this.confusionMatrix(null, labels, pred, numClasses);
    }

    public SDVariable confusionMatrix(String name, SDVariable labels, SDVariable pred, Integer numClasses) {
        SDValidation.validateInteger("confusionMatrix", "labels", labels);
        SDValidation.validateInteger("confusionMatrix", "prediction", pred);
        SDVariable result = this.f().confusionMatrix(labels, pred, numClasses);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable pred, SDVariable weights) {
        return this.confusionMatrix(null, labels, pred, weights);
    }

    public SDVariable confusionMatrix(String name, SDVariable labels, SDVariable pred, SDVariable weights) {
        SDValidation.validateInteger("confusionMatrix", "labels", labels);
        SDValidation.validateInteger("confusionMatrix", "prediction", pred);
        SDValidation.validateNumerical("confusionMatrix", "weights", weights);
        SDVariable result = this.f().confusionMatrix(labels, pred, weights);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable pred, Integer numClasses, SDVariable weights) {
        return this.confusionMatrix(null, labels, pred, numClasses, weights);
    }

    public SDVariable confusionMatrix(String name, SDVariable labels, SDVariable pred, Integer numClasses, SDVariable weights) {
        SDValidation.validateInteger("confusionMatrix", "labels", labels);
        SDValidation.validateInteger("confusionMatrix", "prediction", pred);
        SDValidation.validateNumerical("confusionMatrix", "weights", weights);
        SDVariable result = this.f().confusionMatrix(labels, pred, numClasses, weights);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable cos(SDVariable x) {
        return this.cos(null, x);
    }

    public SDVariable cos(String name, SDVariable x) {
        SDValidation.validateNumerical("cos", x);
        SDVariable result = this.f().cos(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable cosh(SDVariable x) {
        return this.cosh(null, x);
    }

    public SDVariable cosh(String name, SDVariable x) {
        SDValidation.validateNumerical("cosh", x);
        SDVariable result = this.f().cosh(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable cosineDistance(SDVariable x, SDVariable y, int ... dimensions) {
        return this.cosineDistance(null, x, y, dimensions);
    }

    public SDVariable cosineDistance(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDValidation.validateNumerical("cosine distance", x, y);
        SDVariable result = this.f().cosineDistance(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable cosineSimilarity(SDVariable x, SDVariable y, int ... dimensions) {
        return this.cosineSimilarity(this.sd.generateNewVarName("cosinesimilarity", 0), x, y, dimensions);
    }

    public SDVariable cosineSimilarity(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDValidation.validateNumerical("cosine similarity", x, y);
        SDVariable cosim = this.f().cosineSimilarity(x, y, dimensions);
        return this.updateVariableNameAndReference(cosim, name);
    }

    public SDVariable countNonZero(SDVariable input, int ... dimensions) {
        return this.countNonZero(null, input, dimensions);
    }

    public SDVariable countNonZero(String name, SDVariable input, int ... dimensions) {
        SDValidation.validateNumerical("countNonZero", input);
        SDVariable res = this.f().countNonZero(input, dimensions);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable countZero(SDVariable input, int ... dimensions) {
        return this.countZero(null, input, dimensions);
    }

    public SDVariable countZero(String name, SDVariable input, int ... dimensions) {
        SDValidation.validateNumerical("countNonZero", input);
        SDVariable res = this.f().countZero(input, dimensions);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable cross(SDVariable a, SDVariable b) {
        return this.cross(null, a, b);
    }

    public SDVariable cross(String name, SDVariable a, SDVariable b) {
        SDValidation.validateNumerical("cross", a, b);
        SDVariable ret = this.f().cross(a, b);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable cube(SDVariable x) {
        return this.cube(null, x);
    }

    public SDVariable cube(String name, SDVariable x) {
        SDValidation.validateNumerical("cube", x);
        SDVariable result = this.f().cube(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable diag(SDVariable x) {
        return this.diag(null, x);
    }

    public SDVariable diag(String name, SDVariable x) {
        SDVariable ret = this.f().diag(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable diagPart(SDVariable x) {
        return this.diagPart(null, x);
    }

    public SDVariable diagPart(String name, SDVariable x) {
        SDVariable ret = this.f().diagPart(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable entropy(SDVariable in, int ... dimensions) {
        return this.entropy(null, in, dimensions);
    }

    public SDVariable entropy(String name, SDVariable in, int ... dimensions) {
        SDValidation.validateNumerical("entropy reduction", in);
        SDVariable ret = this.f().entropy(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable erf(SDVariable x) {
        return this.erf(null, x);
    }

    public SDVariable erf(String name, SDVariable x) {
        SDValidation.validateNumerical("erf (error function)", x);
        SDVariable ret = this.f().erf(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable erfc(SDVariable x) {
        return this.erfc(null, x);
    }

    public SDVariable erfc(String name, SDVariable x) {
        SDValidation.validateNumerical("erfc", x);
        SDVariable ret = this.f().erfc(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable euclideanDistance(SDVariable x, SDVariable y, int ... dimensions) {
        return this.euclideanDistance(this.sd.generateNewVarName("euclidean", 0), x, y, dimensions);
    }

    public SDVariable euclideanDistance(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDValidation.validateNumerical("euclidean distance", x, y);
        SDVariable result = this.f().euclideanDistance(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable exp(SDVariable x) {
        return this.exp(null, x);
    }

    public SDVariable exp(String name, SDVariable x) {
        SDValidation.validateNumerical("exp", x);
        SDVariable result = this.f().exp(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable expm1(SDVariable x) {
        return this.expm1(null, x);
    }

    public SDVariable expm1(String name, SDVariable x) {
        SDValidation.validateNumerical("expm1", x);
        SDVariable result = this.f().expm1(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable eye(int rows) {
        return this.eye(rows, rows);
    }

    public SDVariable eye(String name, int rows) {
        return this.eye(name, rows, rows);
    }

    public SDVariable eye(int rows, int cols) {
        return this.eye(null, rows, cols);
    }

    public SDVariable eye(String name, int rows, int cols) {
        return this.eye(name, rows, cols, Eye.DEFAULT_DTYPE);
    }

    public SDVariable eye(String name, int rows, int cols, DataType dataType) {
        return this.eye(name, rows, cols, dataType);
    }

    public SDVariable eye(int rows, int cols, DataType dataType, int ... batchDimension) {
        return this.eye(null, rows, cols, dataType, batchDimension);
    }

    public SDVariable eye(String name, int rows, int cols, DataType dataType, int ... batchDimension) {
        SDVariable eye = new Eye(this.sd, rows, cols, dataType, batchDimension).outputVariables()[0];
        return this.updateVariableNameAndReference(eye, name);
    }

    public SDVariable eye(SDVariable rows, SDVariable cols, SDVariable batchDimension) {
        return this.eye(null, rows, cols, batchDimension);
    }

    public SDVariable eye(String name, SDVariable rows, SDVariable cols, SDVariable batchDimension) {
        SDVariable eye = new Eye(this.sd, rows, cols, batchDimension).outputVariable();
        return this.updateVariableNameAndReference(eye, name);
    }

    public SDVariable eye(String name, SDVariable rows, SDVariable cols) {
        SDVariable eye = new Eye(this.sd, rows, cols).outputVariables()[0];
        return this.updateVariableNameAndReference(eye, name);
    }

    public SDVariable eye(SDVariable rows, SDVariable cols) {
        SDVariable eye = new Eye(this.sd, rows, cols).outputVariables()[0];
        return this.updateVariableNameAndReference(eye, null);
    }

    public SDVariable eye(String name, SDVariable rows) {
        SDVariable eye = new Eye(this.sd, rows).outputVariables()[0];
        return this.updateVariableNameAndReference(eye, name);
    }

    public SDVariable eye(SDVariable rows) {
        SDVariable eye = new Eye(this.sd, rows).outputVariables()[0];
        return this.updateVariableNameAndReference(eye, null);
    }

    public SDVariable firstIndex(SDVariable in, Condition condition, int ... dimensions) {
        return this.firstIndex(null, in, condition, dimensions);
    }

    public SDVariable firstIndex(String name, SDVariable in, Condition condition, int ... dimensions) {
        return this.firstIndex(name, in, condition, false, dimensions);
    }

    public SDVariable firstIndex(String name, SDVariable in, Condition condition, boolean keepDims, int ... dimensions) {
        SDVariable ret = this.f().firstIndex(in, condition, keepDims, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable firstIndex(SDVariable in, Condition condition, boolean keepDims, int ... dimensions) {
        return this.firstIndex(null, in, condition, keepDims, dimensions);
    }

    public SDVariable floor(SDVariable x) {
        return this.floor(null, x);
    }

    public SDVariable floor(String name, SDVariable x) {
        SDValidation.validateFloatingPoint("floor", x);
        SDVariable result = this.f().floor(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable hammingDistance(SDVariable x, SDVariable y, int ... dimensions) {
        return this.hammingDistance(null, x, y, dimensions);
    }

    public SDVariable hammingDistance(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDValidation.validateNumerical("hamming distance reduction", x, y);
        SDVariable result = this.f().hammingDistance(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable iamax(SDVariable in, int ... dimensions) {
        return this.iamax(null, in, dimensions);
    }

    public SDVariable iamax(String name, SDVariable in, int ... dimensions) {
        return this.iamax(name, in, false, dimensions);
    }

    public SDVariable iamax(String name, SDVariable in, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("iamax", in);
        SDVariable ret = this.f().iamax(in, keepDims, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable iamax(SDVariable in, boolean keepDims, int ... dimensions) {
        return this.iamax(null, in, keepDims, dimensions);
    }

    public SDVariable iamin(SDVariable in, int ... dimensions) {
        return this.iamin(null, in, dimensions);
    }

    public SDVariable iamin(String name, SDVariable in, int ... dimensions) {
        return this.iamin(name, in, false, dimensions);
    }

    public SDVariable iamin(String name, SDVariable in, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("iamin", in);
        SDVariable ret = this.f().iamin(in, keepDims, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable iamin(SDVariable in, boolean keepDims, int ... dimensions) {
        return this.iamin(null, in, keepDims, dimensions);
    }

    public SDVariable isFinite(SDVariable x) {
        return this.isFinite(null, x);
    }

    public SDVariable isFinite(String name, SDVariable x) {
        SDValidation.validateFloatingPoint("isFinite", x);
        SDVariable result = this.f().isFinite(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isInfinite(SDVariable x) {
        return this.isInfinite(null, x);
    }

    public SDVariable isInfinite(String name, SDVariable x) {
        SDValidation.validateFloatingPoint("isInfinite", x);
        SDVariable result = this.f().isInfinite(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isMax(SDVariable x) {
        return this.isMax(null, x);
    }

    public SDVariable isMax(String name, SDVariable x) {
        SDValidation.validateNumerical("isMax", x);
        SDVariable ret = this.f().isMax(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable isNaN(SDVariable x) {
        return this.isNaN(null, x);
    }

    public SDVariable isNaN(String name, SDVariable x) {
        SDValidation.validateFloatingPoint("isNaN", x);
        SDVariable result = this.f().isNaN(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isNonDecreasing(SDVariable x) {
        return this.isNonDecreasing(null, x);
    }

    public SDVariable isNonDecreasing(String name, SDVariable x) {
        SDValidation.validateNumerical("isNonDecreasing", x);
        SDVariable result = this.f().isNonDecreasing(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isStrictlyIncreasing(SDVariable x) {
        return this.isStrictlyIncreasing(null, x);
    }

    public SDVariable isStrictlyIncreasing(String name, SDVariable x) {
        SDValidation.validateNumerical("isStrictlyIncreasing", x);
        SDVariable result = this.f().isStrictlyIncreasing(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable jaccardDistance(SDVariable x, SDVariable y, int ... dimensions) {
        return this.jaccardDistance(null, x, y, dimensions);
    }

    public SDVariable jaccardDistance(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDValidation.validateNumerical("Jaccard distance reduction", x, y);
        SDVariable result = this.f().jaccardDistance(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lastIndex(SDVariable in, Condition condition, int ... dimensions) {
        return this.lastIndex(null, in, condition, dimensions);
    }

    public SDVariable lastIndex(String name, SDVariable in, Condition condition, int ... dimensions) {
        return this.lastIndex(name, in, condition, false, dimensions);
    }

    public SDVariable lastIndex(String name, SDVariable in, Condition condition, boolean keepDims, int ... dimensions) {
        SDVariable ret = this.f().lastIndex(in, condition, keepDims, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable lastIndex(SDVariable in, Condition condition, boolean keepDims, int ... dimensions) {
        return this.lastIndex(null, in, condition, keepDims, dimensions);
    }

    public SDVariable[] listDiff(SDVariable x, SDVariable y) {
        return this.f().listdiff(x, y);
    }

    public SDVariable log(SDVariable x) {
        return this.log(null, x);
    }

    public SDVariable log(String name, SDVariable x) {
        SDValidation.validateNumerical("log", x);
        SDVariable result = this.f().log(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable log(SDVariable in, double base) {
        return this.log(null, in, base);
    }

    public SDVariable log(String name, SDVariable in, double base) {
        SDValidation.validateNumerical("log", in);
        SDVariable ret = this.f().log(in, base);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable log1p(SDVariable x) {
        return this.log1p(null, x);
    }

    public SDVariable log1p(String name, SDVariable x) {
        SDValidation.validateNumerical("log1p", x);
        SDVariable result = this.f().log1p(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable logEntropy(SDVariable in, int ... dimensions) {
        return this.logEntropy(null, in, dimensions);
    }

    public SDVariable logEntropy(String name, SDVariable in, int ... dimensions) {
        SDValidation.validateNumerical("logEntropy reduction", in);
        SDVariable ret = this.f().logEntropy(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable logSumExp(SDVariable input, int ... dimensions) {
        return this.logSumExp(null, input, dimensions);
    }

    public SDVariable logSumExp(String name, SDVariable input, int ... dimensions) {
        return this.logSumExp(name, input, false, dimensions);
    }

    public SDVariable logSumExp(String name, SDVariable input, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("logSumExp reduction", input);
        SDVariable ret = this.f().logSumExp(input, keepDims, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable manhattanDistance(SDVariable x, SDVariable y, int ... dimensions) {
        return this.manhattanDistance(this.sd.generateNewVarName("manhattan", 0), x, y, dimensions);
    }

    public SDVariable manhattanDistance(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDValidation.validateNumerical("manhattan distance", x, y);
        SDVariable result = this.f().manhattanDistance(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable matrixDeterminant(SDVariable in) {
        return this.matrixDeterminant(null, in);
    }

    public SDVariable matrixDeterminant(String name, SDVariable in) {
        SDValidation.validateNumerical("matrix determinant", in);
        SDVariable ret = this.f().matrixDeterminant(in);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable matrixInverse(SDVariable in) {
        return this.matrixInverse(null, in);
    }

    public SDVariable matrixInverse(String name, SDVariable in) {
        SDValidation.validateFloatingPoint("matrix inverse", in);
        SDVariable ret = this.f().matrixInverse(in);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable mergeAdd(SDVariable ... x) {
        return this.mergeAdd((String)null, x);
    }

    public SDVariable mergeAdd(String name, SDVariable ... inputs) {
        SDValidation.validateSameType("mergeAdd", true, inputs);
        SDVariable ret = this.f().mergeAdd(inputs);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable mergeAvg(SDVariable ... inputs) {
        return this.mergeAvg((String)null, inputs);
    }

    public SDVariable mergeAvg(String name, SDVariable ... inputs) {
        SDValidation.validateSameType("mergeAvg", true, inputs);
        SDVariable ret = this.f().mergeAvg(inputs);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable mergeMax(SDVariable ... x) {
        return this.mergeMax((String)null, x);
    }

    public SDVariable mergeMax(String name, SDVariable ... inputs) {
        SDValidation.validateSameType("mergeMax", true, inputs);
        SDVariable ret = this.f().mergeMax(inputs);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable[] meshgrid(SDVariable ... inputs) {
        return this.meshgrid((List<String>)null, inputs);
    }

    public SDVariable[] meshgrid(List<String> names, SDVariable ... inputs) {
        return this.meshgrid(names, true, inputs);
    }

    public SDVariable[] meshgrid(List<String> names, boolean cartesian, SDVariable ... inputs) {
        Preconditions.checkState((names == null || names.size() == inputs.length ? 1 : 0) != 0, (String)"Got %s names but %s inputs", (int)(names == null ? 0 : names.size()), (int)inputs.length);
        SDValidation.validateSameType("meshgrid", false, inputs);
        SDVariable[] ret = this.f().meshgrid(cartesian, inputs);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.updateVariableNameAndReference(ret[i], names == null ? null : names.get(i));
        }
        return ret;
    }

    public SDVariable[] moments(SDVariable input, int ... axes) {
        return this.moments(null, input, axes);
    }

    public SDVariable[] moments(String[] name, SDVariable input, int ... axes) {
        SDValidation.validateNumerical("moments", input);
        SDVariable[] res = this.f().moments(input, axes);
        return this.sd.updateVariableNamesAndReferences(res, name);
    }

    public SDVariable neg(SDVariable x) {
        return this.neg(null, x);
    }

    public SDVariable neg(String name, SDVariable x) {
        SDValidation.validateNumerical("neg", x);
        SDVariable result = this.f().neg(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable[] normalizeMoments(SDVariable counts, SDVariable means, SDVariable variances, double shift) {
        return this.normalizeMoments(null, counts, means, variances, shift);
    }

    public SDVariable[] normalizeMoments(String[] name, SDVariable counts, SDVariable means, SDVariable variances, double shift) {
        SDVariable[] res = this.f().normalizeMoments(counts, means, variances, shift);
        return this.sd.updateVariableNamesAndReferences(res, name);
    }

    public SDVariable or(SDVariable x, SDVariable y) {
        return this.or(null, x, y);
    }

    public SDVariable or(String name, SDVariable x, SDVariable y) {
        SDValidation.validateBool("or", x, y);
        SDVariable result = this.f().or(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable pow(SDVariable x, double value) {
        return this.pow(null, x, value);
    }

    public SDVariable pow(String name, SDVariable x, double value) {
        SDValidation.validateNumerical("pow", x);
        SDVariable result = this.f().pow(x, value);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable pow(SDVariable x, SDVariable y) {
        return this.pow(null, x, y);
    }

    public SDVariable pow(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("pow", x, y);
        SDVariable result = this.f().pow(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable reciprocal(SDVariable a) {
        return this.reciprocal(null, a);
    }

    public SDVariable reciprocal(String name, SDVariable a) {
        SDValidation.validateNumerical("reciprocal", a);
        SDVariable ret = this.f().reciprocal(a);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable round(SDVariable x) {
        return this.round(null, x);
    }

    public SDVariable round(String name, SDVariable x) {
        SDValidation.validateFloatingPoint("round", x);
        SDVariable result = this.f().round(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable rsqrt(SDVariable x) {
        return this.rsqrt(null, x);
    }

    public SDVariable rsqrt(String name, SDVariable x) {
        SDValidation.validateNumerical("rsqrt", x);
        SDVariable result = this.f().rsqrt(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable setDiag(SDVariable in, SDVariable diag) {
        return this.setDiag(null, in, diag);
    }

    public SDVariable setDiag(String name, SDVariable in, SDVariable diag) {
        SDVariable ret = this.f().setDiag(in, diag);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable shannonEntropy(SDVariable in, int ... dimensions) {
        return this.shannonEntropy(null, in, dimensions);
    }

    public SDVariable shannonEntropy(String name, SDVariable in, int ... dimensions) {
        SDValidation.validateNumerical("shannon entropy reduction", in);
        SDVariable ret = this.f().shannonEntropy(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sign(SDVariable x) {
        return this.sign(null, x);
    }

    public SDVariable sign(String name, SDVariable x) {
        SDValidation.validateNumerical("sign", x);
        SDVariable result = this.f().sign(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sin(SDVariable x) {
        return this.sin(null, x);
    }

    public SDVariable sin(String name, SDVariable x) {
        SDValidation.validateNumerical("sin", x);
        SDVariable result = this.f().sin(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sinh(SDVariable x) {
        return this.sinh(null, x);
    }

    public SDVariable sinh(String name, SDVariable x) {
        SDValidation.validateNumerical("sinh", x);
        SDVariable result = this.f().sinh(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sqrt(SDVariable x) {
        return this.sqrt(null, x);
    }

    public SDVariable sqrt(String name, SDVariable x) {
        SDValidation.validateNumerical("sqrt", x);
        SDVariable result = this.f().sqrt(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable square(SDVariable x) {
        return this.square(null, x);
    }

    public SDVariable square(String name, SDVariable x) {
        SDValidation.validateNumerical("square", x);
        SDVariable result = this.f().square(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable step(SDVariable in, double cutoff) {
        return this.step(null, in, cutoff);
    }

    public SDVariable step(String name, SDVariable in, double cutoff) {
        SDValidation.validateNumerical("step", in);
        SDVariable ret = this.f().step(in, cutoff);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable standardize(SDVariable x, int ... dimensions) {
        return this.standardize(null, x, dimensions);
    }

    public SDVariable standardize(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateNumerical("standardize", x);
        SDVariable result = this.f().standardize(x, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable tan(SDVariable x) {
        return this.tan(null, x);
    }

    public SDVariable tan(String name, SDVariable x) {
        SDValidation.validateNumerical("tan", x);
        SDVariable result = this.f().tan(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable tanh(SDVariable x) {
        return this.tanh(null, x);
    }

    public SDVariable tanh(String name, SDVariable x) {
        SDValidation.validateNumerical("tanh", x);
        SDVariable result = this.f().tanh(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable trace(SDVariable in) {
        return this.trace(null, in);
    }

    public SDVariable trace(String name, SDVariable in) {
        SDValidation.validateNumerical("trace", in);
        SDVariable ret = this.f().trace(in);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable xor(SDVariable x, SDVariable y) {
        return this.xor(null, x, y);
    }

    public SDVariable xor(String name, SDVariable x, SDVariable y) {
        SDValidation.validateBool("xor", x, y);
        SDVariable result = this.f().xor(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable bitShift(String name, SDVariable x, SDVariable shift) {
        SDValidation.validateInteger("shift_bits", x);
        SDVariable result = this.f().shift(x, shift);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable bitShiftRight(String name, SDVariable x, SDVariable shift) {
        SDValidation.validateInteger("rshift_bits", x);
        SDVariable result = this.f().rshift(x, shift);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable bitRotl(String name, SDVariable x, SDVariable shift) {
        SDValidation.validateInteger("cyclic_shift_bits", x);
        SDVariable result = this.f().rotl(x, shift);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable bitRotr(String name, SDVariable x, SDVariable shift) {
        SDValidation.validateInteger("cyclic_rshift_bits", x);
        SDVariable result = this.f().rotr(x, shift);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable zeroFraction(SDVariable input) {
        return this.zeroFraction(null, input);
    }

    public SDVariable zeroFraction(String name, SDVariable input) {
        SDValidation.validateNumerical("zeroFraction", input);
        SDVariable res = this.f().zeroFraction(input);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable betainc(String name, SDVariable a, SDVariable b, SDVariable x) {
        SDVariable res = this.f().betainc(a, b, x);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable matrixBandPart(String name, SDVariable input, SDVariable minLower, SDVariable maxUpper) {
        SDVariable res = this.f().matrixBandPart(input, minLower, maxUpper);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable polygamma(String name, SDVariable n, SDVariable x) {
        SDVariable res = this.f().polygamma(n, x);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable roll(String name, SDVariable input, SDVariable shift) {
        SDVariable res = this.f().roll(input, shift);
        return this.updateVariableNameAndReference(res, name);
    }
}

