/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.ops.SDOps;
import org.nd4j.autodiff.samediff.ops.SDValidation;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv1DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv3DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv3DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.LocalResponseNormalizationConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling3DConfig;

public class SDCNN
extends SDOps {
    public SDCNN(SameDiff sameDiff) {
        super(sameDiff);
    }

    public SDVariable avgPooling2d(@NonNull SDVariable input, @NonNull Pooling2DConfig pooling2DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (pooling2DConfig == null) {
            throw new NullPointerException("pooling2DConfig is marked @NonNull but is null");
        }
        return this.avgPooling2d(null, input, pooling2DConfig);
    }

    public SDVariable avgPooling2d(String name, @NonNull SDVariable input, @NonNull Pooling2DConfig pooling2DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (pooling2DConfig == null) {
            throw new NullPointerException("pooling2DConfig is marked @NonNull but is null");
        }
        SDValidation.validateFloatingPoint("avgPooling2d", input);
        SDVariable ret = this.f().avgPooling2d(input, pooling2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable avgPooling3d(@NonNull SDVariable input, @NonNull Pooling3DConfig pooling3DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (pooling3DConfig == null) {
            throw new NullPointerException("pooling3DConfig is marked @NonNull but is null");
        }
        return this.avgPooling3d(null, input, pooling3DConfig);
    }

    public SDVariable avgPooling3d(String name, @NonNull SDVariable input, @NonNull Pooling3DConfig pooling3DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (pooling3DConfig == null) {
            throw new NullPointerException("pooling3DConfig is marked @NonNull but is null");
        }
        SDValidation.validateFloatingPoint("avgPooling3d", input);
        SDVariable ret = this.f().avgPooling3d(input, pooling3DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable batchToSpace(@NonNull SDVariable x, @NonNull int[] blocks, @NonNull int[][] crops) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (blocks == null) {
            throw new NullPointerException("blocks is marked @NonNull but is null");
        }
        if (crops == null) {
            throw new NullPointerException("crops is marked @NonNull but is null");
        }
        return this.batchToSpace(null, x, blocks, crops);
    }

    public SDVariable batchToSpace(String name, @NonNull SDVariable x, @NonNull int[] blocks, @NonNull int[][] crops) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (blocks == null) {
            throw new NullPointerException("blocks is marked @NonNull but is null");
        }
        if (crops == null) {
            throw new NullPointerException("crops is marked @NonNull but is null");
        }
        SDValidation.validateNumerical("batchToSpace", x);
        SDVariable ret = this.f().batchToSpace(x, blocks, crops);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable col2Im(@NonNull SDVariable in, @NonNull Conv2DConfig config) {
        if (in == null) {
            throw new NullPointerException("in is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.col2Im(null, in, config);
    }

    public SDVariable col2Im(String name, @NonNull SDVariable in, @NonNull Conv2DConfig config) {
        if (in == null) {
            throw new NullPointerException("in is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        SDVariable ret = this.f().col2Im(in, config);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv1d(@NonNull SDVariable input, @NonNull SDVariable weights, @NonNull Conv1DConfig conv1DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (conv1DConfig == null) {
            throw new NullPointerException("conv1DConfig is marked @NonNull but is null");
        }
        return this.conv1d((String)null, input, weights, conv1DConfig);
    }

    public SDVariable conv1d(String name, @NonNull SDVariable input, @NonNull SDVariable weights, @NonNull Conv1DConfig conv1DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (conv1DConfig == null) {
            throw new NullPointerException("conv1DConfig is marked @NonNull but is null");
        }
        SDValidation.validateFloatingPoint("conv1d", input);
        SDValidation.validateFloatingPoint("conv1d", weights);
        SDVariable ret = this.f().conv1d(input, weights, conv1DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv1d(@NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, @NonNull Conv1DConfig conv1DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (conv1DConfig == null) {
            throw new NullPointerException("conv1DConfig is marked @NonNull but is null");
        }
        return this.conv1d(null, input, weights, bias, conv1DConfig);
    }

    public SDVariable conv1d(String name, @NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, @NonNull Conv1DConfig conv1DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (conv1DConfig == null) {
            throw new NullPointerException("conv1DConfig is marked @NonNull but is null");
        }
        SDValidation.validateFloatingPoint("conv1d", input);
        SDValidation.validateFloatingPoint("conv1d", weights);
        SDValidation.validateFloatingPoint("conv1d", bias);
        SDVariable ret = this.f().conv1d(input, weights, bias, conv1DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv2d(@NonNull SDVariable layerInput, @NonNull SDVariable weights, @NonNull Conv2DConfig config) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.conv2d(layerInput, weights, null, config);
    }

    public SDVariable conv2d(String name, @NonNull SDVariable layerInput, @NonNull SDVariable weights, @NonNull Conv2DConfig config) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.conv2d(name, layerInput, weights, null, config);
    }

    public SDVariable conv2d(@NonNull SDVariable layerInput, @NonNull SDVariable weights, SDVariable bias, @NonNull Conv2DConfig config) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.conv2d(null, layerInput, weights, bias, config);
    }

    public SDVariable conv2d(String name, @NonNull SDVariable layerInput, @NonNull SDVariable weights, SDVariable bias, @NonNull Conv2DConfig config) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        SDValidation.validateFloatingPoint("conv2d", "input", layerInput);
        SDValidation.validateFloatingPoint("conv2d", "weights", weights);
        SDValidation.validateFloatingPoint("conv2d", "bias", bias);
        SDVariable[] arr = new SDVariable[bias == null ? 2 : 3];
        arr[0] = layerInput;
        arr[1] = weights;
        if (bias != null) {
            arr[2] = bias;
        }
        return this.conv2d(name, arr, config);
    }

    public SDVariable conv2d(@NonNull SDVariable[] inputs, @NonNull Conv2DConfig config) {
        if (inputs == null) {
            throw new NullPointerException("inputs is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.conv2d(null, inputs, config);
    }

    public SDVariable conv2d(String name, @NonNull SDVariable[] inputs, @NonNull Conv2DConfig config) {
        if (inputs == null) {
            throw new NullPointerException("inputs is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        for (SDVariable v : inputs) {
            SDValidation.validateNumerical("conv2d", v);
        }
        SDVariable ret = this.f().conv2d(inputs, config);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv3d(@NonNull SDVariable input, @NonNull SDVariable weights, @NonNull Conv3DConfig conv3DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (conv3DConfig == null) {
            throw new NullPointerException("conv3DConfig is marked @NonNull but is null");
        }
        return this.conv3d(null, input, weights, null, conv3DConfig);
    }

    public SDVariable conv3d(String name, @NonNull SDVariable input, @NonNull SDVariable weights, @NonNull Conv3DConfig conv3DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (conv3DConfig == null) {
            throw new NullPointerException("conv3DConfig is marked @NonNull but is null");
        }
        return this.conv3d(name, input, weights, null, conv3DConfig);
    }

    public SDVariable conv3d(@NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, @NonNull Conv3DConfig conv3DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (conv3DConfig == null) {
            throw new NullPointerException("conv3DConfig is marked @NonNull but is null");
        }
        return this.conv3d(null, input, weights, bias, conv3DConfig);
    }

    public SDVariable conv3d(String name, @NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, @NonNull Conv3DConfig conv3DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (conv3DConfig == null) {
            throw new NullPointerException("conv3DConfig is marked @NonNull but is null");
        }
        SDValidation.validateFloatingPoint("conv3d", "input", input);
        SDValidation.validateFloatingPoint("conv3d", "weights", weights);
        SDValidation.validateFloatingPoint("conv3d", "bias", bias);
        SDVariable[] args = bias == null ? new SDVariable[]{input, weights} : new SDVariable[]{input, weights, bias};
        SDVariable ret = this.f().conv3d(args, conv3DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable deconv2d(@NonNull SDVariable layerInput, @NonNull SDVariable weights, @NonNull DeConv2DConfig deconv2DConfig) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (deconv2DConfig == null) {
            throw new NullPointerException("deconv2DConfig is marked @NonNull but is null");
        }
        return this.deconv2d(layerInput, weights, null, deconv2DConfig);
    }

    public SDVariable deconv2d(String name, @NonNull SDVariable layerInput, @NonNull SDVariable weights, @NonNull DeConv2DConfig deconv2DConfig) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (deconv2DConfig == null) {
            throw new NullPointerException("deconv2DConfig is marked @NonNull but is null");
        }
        return this.deconv2d(name, layerInput, weights, null, deconv2DConfig);
    }

    public SDVariable deconv2d(@NonNull SDVariable layerInput, @NonNull SDVariable weights, SDVariable bias, @NonNull DeConv2DConfig deconv2DConfig) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (deconv2DConfig == null) {
            throw new NullPointerException("deconv2DConfig is marked @NonNull but is null");
        }
        return this.deconv2d(null, layerInput, weights, bias, deconv2DConfig);
    }

    public SDVariable deconv2d(String name, @NonNull SDVariable layerInput, @NonNull SDVariable weights, SDVariable bias, @NonNull DeConv2DConfig deconv2DConfig) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (deconv2DConfig == null) {
            throw new NullPointerException("deconv2DConfig is marked @NonNull but is null");
        }
        SDValidation.validateFloatingPoint("deconv2d", "input", layerInput);
        SDValidation.validateFloatingPoint("deconv2d", "weights", weights);
        SDValidation.validateFloatingPoint("deconv2d", "bias", bias);
        SDVariable[] arr = new SDVariable[bias == null ? 2 : 3];
        arr[0] = layerInput;
        arr[1] = weights;
        if (bias != null) {
            arr[2] = bias;
        }
        return this.deconv2d(name, arr, deconv2DConfig);
    }

    public SDVariable deconv2d(@NonNull SDVariable[] inputs, @NonNull DeConv2DConfig deconv2DConfig) {
        if (inputs == null) {
            throw new NullPointerException("inputs is marked @NonNull but is null");
        }
        if (deconv2DConfig == null) {
            throw new NullPointerException("deconv2DConfig is marked @NonNull but is null");
        }
        return this.deconv2d(null, inputs, deconv2DConfig);
    }

    public SDVariable deconv2d(String name, @NonNull SDVariable[] inputs, @NonNull DeConv2DConfig deconv2DConfig) {
        if (inputs == null) {
            throw new NullPointerException("inputs is marked @NonNull but is null");
        }
        if (deconv2DConfig == null) {
            throw new NullPointerException("deconv2DConfig is marked @NonNull but is null");
        }
        for (SDVariable v : inputs) {
            SDValidation.validateNumerical("deconv2d", v);
        }
        SDVariable ret = this.f().deconv2d(inputs, deconv2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable deconv3d(@NonNull SDVariable input, @NonNull SDVariable weights, @NonNull DeConv3DConfig config) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.deconv3d(input, weights, null, config);
    }

    public SDVariable deconv3d(String name, @NonNull SDVariable input, @NonNull SDVariable weights, @NonNull DeConv3DConfig config) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.deconv3d(name, input, weights, null, config);
    }

    public SDVariable deconv3d(@NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, @NonNull DeConv3DConfig config) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.deconv3d(null, input, weights, bias, config);
    }

    public SDVariable deconv3d(String name, @NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, @NonNull DeConv3DConfig config) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        SDValidation.validateFloatingPoint("conv3d", input);
        SDValidation.validateFloatingPoint("conv3d", weights);
        SDValidation.validateFloatingPoint("conv3d", bias);
        SDVariable ret = this.f().deconv3d(input, weights, bias, config);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable depthToSpace(@NonNull SDVariable x, @NonNull int blockSize, @NonNull String dataFormat) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (dataFormat == null) {
            throw new NullPointerException("dataFormat is marked @NonNull but is null");
        }
        return this.depthToSpace(null, x, blockSize, dataFormat);
    }

    public SDVariable depthToSpace(String name, @NonNull SDVariable x, @NonNull int blockSize, @NonNull String dataFormat) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (dataFormat == null) {
            throw new NullPointerException("dataFormat is marked @NonNull but is null");
        }
        SDVariable ret = this.f().depthToSpace(x, blockSize, dataFormat);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable depthWiseConv2d(@NonNull SDVariable layerInput, @NonNull SDVariable depthWeights, @NonNull Conv2DConfig config) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (depthWeights == null) {
            throw new NullPointerException("depthWeights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.depthWiseConv2d(layerInput, depthWeights, null, config);
    }

    public SDVariable depthWiseConv2d(String name, @NonNull SDVariable layerInput, @NonNull SDVariable depthWeights, @NonNull Conv2DConfig config) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (depthWeights == null) {
            throw new NullPointerException("depthWeights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.depthWiseConv2d(name, layerInput, depthWeights, null, config);
    }

    public SDVariable depthWiseConv2d(@NonNull SDVariable layerInput, @NonNull SDVariable depthWeights, SDVariable bias, @NonNull Conv2DConfig config) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (depthWeights == null) {
            throw new NullPointerException("depthWeights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.depthWiseConv2d(null, layerInput, depthWeights, bias, config);
    }

    public SDVariable depthWiseConv2d(String name, @NonNull SDVariable layerInput, @NonNull SDVariable depthWeights, SDVariable bias, @NonNull Conv2DConfig config) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (depthWeights == null) {
            throw new NullPointerException("depthWeights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        SDValidation.validateFloatingPoint("depthwiseConv2d", "input", layerInput);
        SDValidation.validateFloatingPoint("depthwiseConv2d", "depth weights", depthWeights);
        SDValidation.validateFloatingPoint("depthwiseConv2d", "bias", bias);
        SDVariable[] arr = new SDVariable[bias == null ? 2 : 3];
        arr[0] = layerInput;
        arr[1] = depthWeights;
        if (bias != null) {
            arr[2] = bias;
        }
        return this.depthWiseConv2d(name, arr, config);
    }

    public SDVariable depthWiseConv2d(@NonNull SDVariable[] inputs, @NonNull Conv2DConfig depthConv2DConfig) {
        if (inputs == null) {
            throw new NullPointerException("inputs is marked @NonNull but is null");
        }
        if (depthConv2DConfig == null) {
            throw new NullPointerException("depthConv2DConfig is marked @NonNull but is null");
        }
        return this.depthWiseConv2d(null, inputs, depthConv2DConfig);
    }

    public SDVariable depthWiseConv2d(String name, @NonNull SDVariable[] inputs, @NonNull Conv2DConfig depthConv2DConfig) {
        if (inputs == null) {
            throw new NullPointerException("inputs is marked @NonNull but is null");
        }
        if (depthConv2DConfig == null) {
            throw new NullPointerException("depthConv2DConfig is marked @NonNull but is null");
        }
        for (SDVariable v : inputs) {
            SDValidation.validateFloatingPoint("depthWiseConv2d", v);
        }
        SDVariable ret = this.f().depthWiseConv2d(inputs, depthConv2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable dilation2D(@NonNull SDVariable df, @NonNull SDVariable weights, @NonNull int[] strides, @NonNull int[] rates, @NonNull boolean isSameMode) {
        if (df == null) {
            throw new NullPointerException("df is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (strides == null) {
            throw new NullPointerException("strides is marked @NonNull but is null");
        }
        if (rates == null) {
            throw new NullPointerException("rates is marked @NonNull but is null");
        }
        return this.dilation2D(null, df, weights, strides, rates, isSameMode);
    }

    public SDVariable dilation2D(String name, @NonNull SDVariable df, @NonNull SDVariable weights, @NonNull int[] strides, @NonNull int[] rates, @NonNull boolean isSameMode) {
        if (df == null) {
            throw new NullPointerException("df is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        if (strides == null) {
            throw new NullPointerException("strides is marked @NonNull but is null");
        }
        if (rates == null) {
            throw new NullPointerException("rates is marked @NonNull but is null");
        }
        SDVariable ret = this.f().dilation2D(df, weights, strides, rates, isSameMode);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable extractImagePatches(String name, @NonNull SDVariable input, int kH, int kW, int sH, int sW, int rH, int rW, boolean sameMode) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        SDVariable ret = this.f().extractImagePatches(input, kH, kW, sH, sW, rH, rW, sameMode);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable im2Col(@NonNull SDVariable in, @NonNull Conv2DConfig config) {
        if (in == null) {
            throw new NullPointerException("in is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.im2Col(null, in, config);
    }

    public SDVariable im2Col(String name, @NonNull SDVariable in, @NonNull Conv2DConfig config) {
        if (in == null) {
            throw new NullPointerException("in is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        SDVariable ret = this.f().im2Col(in, config);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable localResponseNormalization(@NonNull SDVariable inputs, @NonNull LocalResponseNormalizationConfig lrnConfig) {
        if (inputs == null) {
            throw new NullPointerException("inputs is marked @NonNull but is null");
        }
        if (lrnConfig == null) {
            throw new NullPointerException("lrnConfig is marked @NonNull but is null");
        }
        return this.localResponseNormalization(null, inputs, lrnConfig);
    }

    public SDVariable localResponseNormalization(String name, @NonNull SDVariable input, @NonNull LocalResponseNormalizationConfig lrnConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (lrnConfig == null) {
            throw new NullPointerException("lrnConfig is marked @NonNull but is null");
        }
        SDValidation.validateFloatingPoint("local response normalization", input);
        SDVariable ret = this.f().localResponseNormalization(input, lrnConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable maxPooling2d(@NonNull SDVariable input, @NonNull Pooling2DConfig pooling2DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (pooling2DConfig == null) {
            throw new NullPointerException("pooling2DConfig is marked @NonNull but is null");
        }
        return this.maxPooling2d(null, input, pooling2DConfig);
    }

    public SDVariable maxPooling2d(String name, @NonNull SDVariable input, @NonNull Pooling2DConfig pooling2DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (pooling2DConfig == null) {
            throw new NullPointerException("pooling2DConfig is marked @NonNull but is null");
        }
        SDValidation.validateNumerical("maxPooling2d", input);
        SDVariable ret = this.f().maxPooling2d(input, pooling2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable maxPooling3d(@NonNull SDVariable input, @NonNull Pooling3DConfig pooling3DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (pooling3DConfig == null) {
            throw new NullPointerException("pooling3DConfig is marked @NonNull but is null");
        }
        return this.maxPooling3d(null, input, pooling3DConfig);
    }

    public SDVariable maxPooling3d(String name, @NonNull SDVariable input, @NonNull Pooling3DConfig pooling3DConfig) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (pooling3DConfig == null) {
            throw new NullPointerException("pooling3DConfig is marked @NonNull but is null");
        }
        SDValidation.validateNumerical("maxPooling3d", input);
        SDVariable ret = this.f().maxPooling3d(input, pooling3DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable separableConv2d(SDVariable layerInput, @NonNull SDVariable depthWeights, SDVariable pointWeights, @NonNull Conv2DConfig config) {
        if (depthWeights == null) {
            throw new NullPointerException("depthWeights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.separableConv2d(layerInput, depthWeights, pointWeights, null, config);
    }

    public SDVariable separableConv2d(String name, @NonNull SDVariable layerInput, @NonNull SDVariable depthWeights, SDVariable pointWeights, @NonNull Conv2DConfig config) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (depthWeights == null) {
            throw new NullPointerException("depthWeights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.separableConv2d(layerInput, depthWeights, pointWeights, null, config);
    }

    public SDVariable separableConv2d(@NonNull SDVariable layerInput, @NonNull SDVariable depthWeights, SDVariable pointWeights, SDVariable bias, @NonNull Conv2DConfig config) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (depthWeights == null) {
            throw new NullPointerException("depthWeights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return this.separableConv2d(null, layerInput, depthWeights, pointWeights, bias, config);
    }

    public SDVariable separableConv2d(String name, @NonNull SDVariable layerInput, @NonNull SDVariable depthWeights, SDVariable pointWeights, SDVariable bias, @NonNull Conv2DConfig config) {
        if (layerInput == null) {
            throw new NullPointerException("layerInput is marked @NonNull but is null");
        }
        if (depthWeights == null) {
            throw new NullPointerException("depthWeights is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        SDValidation.validateFloatingPoint("separableConv2d", "input", layerInput);
        SDValidation.validateFloatingPoint("separableConv2d", "depthWeights", depthWeights);
        SDValidation.validateFloatingPoint("separableConv2d", "pointWeights", pointWeights);
        SDValidation.validateFloatingPoint("separableConv2d", "bias", bias);
        SDVariable[] arr = new SDVariable[bias == null ? 3 : 4];
        arr[0] = layerInput;
        arr[1] = depthWeights;
        arr[2] = pointWeights;
        if (bias != null) {
            arr[3] = bias;
        }
        return this.sconv2d(name, arr, config);
    }

    public SDVariable sconv2d(@NonNull SDVariable[] inputs, @NonNull Conv2DConfig conv2DConfig) {
        if (inputs == null) {
            throw new NullPointerException("inputs is marked @NonNull but is null");
        }
        if (conv2DConfig == null) {
            throw new NullPointerException("conv2DConfig is marked @NonNull but is null");
        }
        return this.sconv2d(null, inputs, conv2DConfig);
    }

    public SDVariable sconv2d(String name, @NonNull SDVariable[] inputs, @NonNull Conv2DConfig conv2DConfig) {
        if (inputs == null) {
            throw new NullPointerException("inputs is marked @NonNull but is null");
        }
        if (conv2DConfig == null) {
            throw new NullPointerException("conv2DConfig is marked @NonNull but is null");
        }
        for (SDVariable v : inputs) {
            SDValidation.validateFloatingPoint("sconv2d", v);
        }
        SDVariable ret = this.f().sconv2d(inputs, conv2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable spaceToBatch(@NonNull SDVariable x, @NonNull int[] blocks, @NonNull int[][] padding) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (blocks == null) {
            throw new NullPointerException("blocks is marked @NonNull but is null");
        }
        if (padding == null) {
            throw new NullPointerException("padding is marked @NonNull but is null");
        }
        return this.spaceToBatch(null, x, blocks, padding);
    }

    public SDVariable spaceToBatch(String name, @NonNull SDVariable x, @NonNull int[] blocks, @NonNull int[][] padding) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (blocks == null) {
            throw new NullPointerException("blocks is marked @NonNull but is null");
        }
        if (padding == null) {
            throw new NullPointerException("padding is marked @NonNull but is null");
        }
        SDVariable ret = this.f().spaceToBatch(x, blocks, padding);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable spaceToDepth(@NonNull SDVariable x, int blockSize, @NonNull String dataFormat) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (dataFormat == null) {
            throw new NullPointerException("dataFormat is marked @NonNull but is null");
        }
        return this.spaceToDepth(null, x, blockSize, dataFormat);
    }

    public SDVariable spaceToDepth(String name, @NonNull SDVariable x, int blockSize, @NonNull String dataFormat) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (dataFormat == null) {
            throw new NullPointerException("dataFormat is marked @NonNull but is null");
        }
        SDVariable ret = this.f().spaceToDepth(x, blockSize, dataFormat);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable upsampling2d(@NonNull SDVariable input, int scale) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        return this.upsampling2d(null, input, true, scale, scale);
    }

    public SDVariable upsampling2d(String name, @NonNull SDVariable input, int scale) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        return this.upsampling2d(name, input, true, scale, scale);
    }

    public SDVariable upsampling2d(@NonNull SDVariable input, boolean nchw, int scaleH, int scaleW) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        return this.upsampling2d(null, input, nchw, scaleH, scaleW);
    }

    public SDVariable upsampling2d(String name, @NonNull SDVariable input, boolean nchw, int scaleH, int scaleW) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        SDVariable ret = this.f().upsampling2d(input, nchw, scaleH, scaleW);
        return this.updateVariableNameAndReference(ret, name);
    }
}

