/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.workspace;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.memory.abstracts.DummyWorkspace;
import org.nd4j.linalg.workspace.ND4JWorkspaceException;

public class WorkspaceUtils {
    private WorkspaceUtils() {
    }

    public static void assertNoWorkspacesOpen(String msg) throws ND4JWorkspaceException {
        WorkspaceUtils.assertNoWorkspacesOpen(msg, false);
    }

    public static void assertNoWorkspacesOpen(String msg, boolean allowScopedOut) throws ND4JWorkspaceException {
        if (Nd4j.getWorkspaceManager().anyWorkspaceActiveForCurrentThread()) {
            MemoryWorkspace currWs = Nd4j.getMemoryManager().getCurrentWorkspace();
            if (allowScopedOut && (currWs == null || currWs instanceof DummyWorkspace)) {
                return;
            }
            List l = Nd4j.getWorkspaceManager().getAllWorkspacesForCurrentThread();
            ArrayList<String> workspaces = new ArrayList<String>(l.size());
            for (MemoryWorkspace ws : l) {
                if (!ws.isScopeActive()) continue;
                workspaces.add(ws.getId());
            }
            throw new ND4JWorkspaceException(msg + " - Open/active workspaces: " + workspaces);
        }
    }

    public static void assertOpenAndActive(@NonNull String ws, @NonNull String errorMsg) throws ND4JWorkspaceException {
        if (ws == null) {
            throw new NullPointerException("ws is marked @NonNull but is null");
        }
        if (errorMsg == null) {
            throw new NullPointerException("errorMsg is marked @NonNull but is null");
        }
        if (!Nd4j.getWorkspaceManager().checkIfWorkspaceExistsAndActive(ws)) {
            throw new ND4JWorkspaceException(errorMsg);
        }
    }

    public static void assertOpenActiveAndCurrent(@NonNull String ws, @NonNull String errorMsg) throws ND4JWorkspaceException {
        if (ws == null) {
            throw new NullPointerException("ws is marked @NonNull but is null");
        }
        if (errorMsg == null) {
            throw new NullPointerException("errorMsg is marked @NonNull but is null");
        }
        if (!Nd4j.getWorkspaceManager().checkIfWorkspaceExistsAndActive(ws)) {
            throw new ND4JWorkspaceException(errorMsg + " - workspace is not open and active");
        }
        MemoryWorkspace currWs = Nd4j.getMemoryManager().getCurrentWorkspace();
        if (currWs == null || !ws.equals(currWs.getId())) {
            throw new ND4JWorkspaceException(errorMsg + " - not the current workspace (current workspace: " + (currWs == null ? null : currWs.getId()));
        }
    }

    public static void assertValidArray(INDArray array, String msg) {
        if (array == null || !array.isAttached()) {
            return;
        }
        MemoryWorkspace ws = array.data().getParentWorkspace();
        if (ws.getWorkspaceType() != MemoryWorkspace.Type.CIRCULAR) {
            if (!ws.isScopeActive()) {
                throw new ND4JWorkspaceException((msg == null ? "" : msg + ": ") + "Array uses leaked workspace pointer from workspace " + ws.getId() + "\nAll open workspaces: " + WorkspaceUtils.allOpenWorkspaces());
            }
            if (ws.getGenerationId() != array.data().getGenerationId()) {
                throw new ND4JWorkspaceException((msg == null ? "" : msg + ": ") + "Array outdated workspace pointer from workspace " + ws.getId() + " (array generation " + array.data().getGenerationId() + ", current workspace generation " + ws.getGenerationId() + ")\nAll open workspaces: " + WorkspaceUtils.allOpenWorkspaces());
            }
        }
    }

    private static List<String> allOpenWorkspaces() {
        List l = Nd4j.getWorkspaceManager().getAllWorkspacesForCurrentThread();
        ArrayList<String> workspaces = new ArrayList<String>(l.size());
        for (MemoryWorkspace ws : l) {
            if (!ws.isScopeActive()) continue;
            workspaces.add(ws.getId());
        }
        return workspaces;
    }
}

