/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import org.nd4j.base.Preconditions;

public class ConvConfigUtil {
    public static void validate2D(long kH, long kW, long sH, long sW, long pH, long pW, long dH, long dW) {
        Preconditions.checkArgument((kH != 0L ? 1 : 0) != 0, (String)"Kernel height can not be 0");
        Preconditions.checkArgument((kW != 0L ? 1 : 0) != 0, (String)"Kernel width can not be 0");
        Preconditions.checkArgument((sH > 0L ? 1 : 0) != 0, (String)"Stride height can not be negative or 0, got: %s", (long)sH);
        Preconditions.checkArgument((sW > 0L ? 1 : 0) != 0, (String)"Stride width can not be negative or 0, got: %s", (long)sW);
        Preconditions.checkArgument((pH >= 0L ? 1 : 0) != 0, (String)"Padding height can not be negative, got: %s", (long)pH);
        Preconditions.checkArgument((pW >= 0L ? 1 : 0) != 0, (String)"Padding width can not be negative, got: %s", (long)pW);
        Preconditions.checkArgument((dH > 0L ? 1 : 0) != 0, (String)"Dilation height can not be negative or 0, got: %s", (long)dH);
        Preconditions.checkArgument((dW > 0L ? 1 : 0) != 0, (String)"Dilation width can not be negative or 0, got: %s", (long)dW);
    }

    public static void validate3D(long kH, long kW, long kD, long sH, long sW, long sD, long pH, long pW, long pD, long dH, long dW, long dD) {
        Preconditions.checkArgument((kH != 0L ? 1 : 0) != 0, (String)"Kernel height can not be 0");
        Preconditions.checkArgument((kW != 0L ? 1 : 0) != 0, (String)"Kernel width can not be 0");
        Preconditions.checkArgument((kD != 0L ? 1 : 0) != 0, (String)"Kernel depth can not be 0");
        Preconditions.checkArgument((sH > 0L ? 1 : 0) != 0, (String)"Stride height can not be negative or 0, got: %s", (long)sH);
        Preconditions.checkArgument((sW > 0L ? 1 : 0) != 0, (String)"Stride width can not be negative or 0, got: %s", (long)sW);
        Preconditions.checkArgument((sD > 0L ? 1 : 0) != 0, (String)"Stride depth can not be negative or 0, got: %s", (long)sD);
        Preconditions.checkArgument((pH >= 0L ? 1 : 0) != 0, (String)"Padding height can not be negative, got: %s", (long)pH);
        Preconditions.checkArgument((pW >= 0L ? 1 : 0) != 0, (String)"Padding width can not be negative, got: %s", (long)pW);
        Preconditions.checkArgument((pD >= 0L ? 1 : 0) != 0, (String)"Padding depth can not be negative, got: %s", (long)pD);
        Preconditions.checkArgument((dH > 0L ? 1 : 0) != 0, (String)"Dilation height can not be negative or 0, got: %s", (long)dH);
        Preconditions.checkArgument((dW > 0L ? 1 : 0) != 0, (String)"Dilation width can not be negative or 0, got: %s", (long)dW);
        Preconditions.checkArgument((dD > 0L ? 1 : 0) != 0, (String)"Dilation depth can not be negative or 0, got: %s", (long)dD);
    }

    public static void validateExtra3D(long aH, long aW, long aD) {
        Preconditions.checkArgument((aH >= 0L ? 1 : 0) != 0, (String)"Output padding height can not be negative, got: %s", (long)aH);
        Preconditions.checkArgument((aW >= 0L ? 1 : 0) != 0, (String)"Output padding width can not be negative, got: %s", (long)aW);
        Preconditions.checkArgument((aD >= 0L ? 1 : 0) != 0, (String)"Output padding depth can not be negative, got: %s", (long)aD);
    }

    public static void validate1D(long k, long s, long p) {
        Preconditions.checkArgument((k != 0L ? 1 : 0) != 0, (String)"Kernel can not be 0");
        Preconditions.checkArgument((s > 0L ? 1 : 0) != 0, (String)"Stride can not be negative or 0, got: %s", (long)s);
        Preconditions.checkArgument((p >= 0L ? 1 : 0) != 0, (String)"Padding can not be negative, got: %s", (long)p);
    }

    public static void validateLRN(double alpha, double beta, double bias, int depth) {
        Preconditions.checkArgument((depth > 0 ? 1 : 0) != 0, (String)"Depth can not be 0 or negative, got: %s", (int)depth);
    }

    private ConvConfigUtil() {
    }
}

