/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent.weights;

import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.weights.RNNWeights;

public class GRUWeights
extends RNNWeights {
    @NonNull
    private SDVariable ruWeight;
    @NonNull
    private SDVariable cWeight;
    @NonNull
    private SDVariable ruBias;
    @NonNull
    private SDVariable cBias;

    @Override
    public SDVariable[] args() {
        return GRUWeights.filterNonNull(this.ruWeight, this.cWeight, this.ruBias, this.cBias);
    }

    GRUWeights(@NonNull SDVariable ruWeight, @NonNull SDVariable cWeight, @NonNull SDVariable ruBias, @NonNull SDVariable cBias) {
        if (ruWeight == null) {
            throw new NullPointerException("ruWeight is marked @NonNull but is null");
        }
        if (cWeight == null) {
            throw new NullPointerException("cWeight is marked @NonNull but is null");
        }
        if (ruBias == null) {
            throw new NullPointerException("ruBias is marked @NonNull but is null");
        }
        if (cBias == null) {
            throw new NullPointerException("cBias is marked @NonNull but is null");
        }
        this.ruWeight = ruWeight;
        this.cWeight = cWeight;
        this.ruBias = ruBias;
        this.cBias = cBias;
    }

    public static GRUWeightsBuilder builder() {
        return new GRUWeightsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GRUWeights)) {
            return false;
        }
        GRUWeights other = (GRUWeights)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SDVariable this$ruWeight = this.getRuWeight();
        SDVariable other$ruWeight = other.getRuWeight();
        if (this$ruWeight == null ? other$ruWeight != null : !((Object)this$ruWeight).equals(other$ruWeight)) {
            return false;
        }
        SDVariable this$cWeight = this.getCWeight();
        SDVariable other$cWeight = other.getCWeight();
        if (this$cWeight == null ? other$cWeight != null : !((Object)this$cWeight).equals(other$cWeight)) {
            return false;
        }
        SDVariable this$ruBias = this.getRuBias();
        SDVariable other$ruBias = other.getRuBias();
        if (this$ruBias == null ? other$ruBias != null : !((Object)this$ruBias).equals(other$ruBias)) {
            return false;
        }
        SDVariable this$cBias = this.getCBias();
        SDVariable other$cBias = other.getCBias();
        return !(this$cBias == null ? other$cBias != null : !((Object)this$cBias).equals(other$cBias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GRUWeights;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SDVariable $ruWeight = this.getRuWeight();
        result = result * 59 + ($ruWeight == null ? 43 : ((Object)$ruWeight).hashCode());
        SDVariable $cWeight = this.getCWeight();
        result = result * 59 + ($cWeight == null ? 43 : ((Object)$cWeight).hashCode());
        SDVariable $ruBias = this.getRuBias();
        result = result * 59 + ($ruBias == null ? 43 : ((Object)$ruBias).hashCode());
        SDVariable $cBias = this.getCBias();
        result = result * 59 + ($cBias == null ? 43 : ((Object)$cBias).hashCode());
        return result;
    }

    @NonNull
    public SDVariable getRuWeight() {
        return this.ruWeight;
    }

    @NonNull
    public SDVariable getCWeight() {
        return this.cWeight;
    }

    @NonNull
    public SDVariable getRuBias() {
        return this.ruBias;
    }

    @NonNull
    public SDVariable getCBias() {
        return this.cBias;
    }

    public void setRuWeight(@NonNull SDVariable ruWeight) {
        if (ruWeight == null) {
            throw new NullPointerException("ruWeight is marked @NonNull but is null");
        }
        this.ruWeight = ruWeight;
    }

    public void setCWeight(@NonNull SDVariable cWeight) {
        if (cWeight == null) {
            throw new NullPointerException("cWeight is marked @NonNull but is null");
        }
        this.cWeight = cWeight;
    }

    public void setRuBias(@NonNull SDVariable ruBias) {
        if (ruBias == null) {
            throw new NullPointerException("ruBias is marked @NonNull but is null");
        }
        this.ruBias = ruBias;
    }

    public void setCBias(@NonNull SDVariable cBias) {
        if (cBias == null) {
            throw new NullPointerException("cBias is marked @NonNull but is null");
        }
        this.cBias = cBias;
    }

    public String toString() {
        return "GRUWeights(ruWeight=" + this.getRuWeight() + ", cWeight=" + this.getCWeight() + ", ruBias=" + this.getRuBias() + ", cBias=" + this.getCBias() + ")";
    }

    public static class GRUWeightsBuilder {
        private SDVariable ruWeight;
        private SDVariable cWeight;
        private SDVariable ruBias;
        private SDVariable cBias;

        GRUWeightsBuilder() {
        }

        public GRUWeightsBuilder ruWeight(SDVariable ruWeight) {
            this.ruWeight = ruWeight;
            return this;
        }

        public GRUWeightsBuilder cWeight(SDVariable cWeight) {
            this.cWeight = cWeight;
            return this;
        }

        public GRUWeightsBuilder ruBias(SDVariable ruBias) {
            this.ruBias = ruBias;
            return this;
        }

        public GRUWeightsBuilder cBias(SDVariable cBias) {
            this.cBias = cBias;
            return this;
        }

        public GRUWeights build() {
            return new GRUWeights(this.ruWeight, this.cWeight, this.ruBias, this.cBias);
        }

        public String toString() {
            return "GRUWeights.GRUWeightsBuilder(ruWeight=" + this.ruWeight + ", cWeight=" + this.cWeight + ", ruBias=" + this.ruBias + ", cBias=" + this.cBias + ")";
        }
    }
}

