/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Broadcast;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public abstract class BaseBroadcastBoolOp
extends BaseOp
implements BroadcastOp {
    private static final Logger log = LoggerFactory.getLogger(BaseBroadcastBoolOp.class);
    protected int[] dimension;

    public BaseBroadcastBoolOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, int[] dimension) {
        this(sameDiff, i_v1, i_v2, false, dimension);
    }

    public BaseBroadcastBoolOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, boolean inPlace, int[] dimension) {
        super(sameDiff, inPlace, new Object[]{i_v2});
        if (i_v1 != null && i_v2 != null) {
            this.f().validateDifferentialFunctionsameDiff(i_v1);
            this.f().validateDifferentialFunctionsameDiff(i_v2);
            this.sameDiff = sameDiff;
            this.inPlace = inPlace;
            this.dimension = dimension;
            if (Shape.isPlaceholderShape(i_v1.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v1.getVarName());
            }
            if (Shape.isPlaceholderShape(i_v2.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v2.getVarName());
            }
        } else {
            throw new IllegalArgumentException("Input not null variables.");
        }
        sameDiff.addArgsFor(new SDVariable[]{i_v1, i_v2}, (DifferentialFunction)this);
    }

    public BaseBroadcastBoolOp(SameDiff sameDiff) {
        this.sameDiff = sameDiff;
    }

    public BaseBroadcastBoolOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, int[] dimension, Object[] extraArgs) {
        super(sameDiff, extraArgs);
        this.dimension = dimension;
        if (i_v1 == null || i_v2 == null) {
            throw new IllegalArgumentException("Input not null variables.");
        }
        this.f().validateDifferentialFunctionsameDiff(i_v1);
        this.f().validateDifferentialFunctionsameDiff(i_v2);
        this.sameDiff = sameDiff;
        sameDiff.addArgsFor(new SDVariable[]{i_v1, i_v2}, (DifferentialFunction)this);
    }

    public BaseBroadcastBoolOp(SameDiff sameDiff, SDVariable i_v, int[] dimension, boolean inPlace) {
        this(sameDiff, i_v, i_v.getShape(), inPlace, dimension, null);
    }

    public BaseBroadcastBoolOp(SameDiff sameDiff, SDVariable i_v, int[] shape, boolean inPlace, int[] dimension, Object[] extraArgs) {
        this(sameDiff, i_v, ArrayUtil.toLongArray((int[])shape), inPlace, dimension, extraArgs);
    }

    public BaseBroadcastBoolOp(SameDiff sameDiff, SDVariable i_v, long[] shape, boolean inPlace, int[] dimension, Object[] extraArgs) {
        super(sameDiff, inPlace, extraArgs);
        this.dimension = dimension;
        if (i_v == null) {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.f().validateDifferentialFunctionsameDiff(i_v);
        sameDiff.addArgsFor(new SDVariable[]{i_v}, (DifferentialFunction)this);
    }

    public BaseBroadcastBoolOp(SameDiff sameDiff, SDVariable i_v, int[] dimension, Object[] extraArgs) {
        this(sameDiff, i_v, i_v.getShape(), false, dimension, extraArgs);
    }

    public BaseBroadcastBoolOp(INDArray x, INDArray y, INDArray z, int ... dimension) {
        super(x, y, z);
        Broadcast.validateBroadcastDims(x, y, z, dimension);
        this.dimension = dimension;
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + x.rank();
        }
        this.defineDimensions(dimension);
    }

    @Override
    public Op.Type opType() {
        return Op.Type.BROADCAST;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.x == null || this.y == null) {
            return Collections.emptyList();
        }
        long[] shapeX = this.x.shape();
        long[] shapeY = this.y.shape();
        return Collections.singletonList(LongShapeDescriptor.fromShape(Shape.broadcastOutputShape(shapeX, shapeY), DataType.BOOL));
    }

    @Override
    public int[] getDimension() {
        if (this.dimension == null) {
            this.dimension = this.x != null && this.y != null ? Shape.getBroadcastDimensions(this.x.shape(), this.y.shape()) : Shape.getBroadcastDimensions(this.larg().getShape(), this.rarg().getShape());
        }
        return this.dimension;
    }

    @Override
    public void setDimension(int ... dimension) {
        this.dimension = dimension;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
    }

    @Override
    public boolean validateDataTypes(boolean experimentalMode) {
        int op = this.opNum();
        Preconditions.checkArgument((this.x().dataType() == this.y().dataType() ? 1 : 0) != 0, (String)"Op.X and Op.Y must have the same data type: x.dataType=%s, y.dataType=%s, op=%s", (Object)this.x.dataType(), (Object)this.y.dataType(), (Object)this.getClass().getName());
        Preconditions.checkArgument((boolean)this.z().isB(), (String)"Op.Z must have bool type: z has type %s for op %s", (Object)this.z().dataType(), this.getClass());
        return true;
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.BROADCAST_BOOL;
    }

    public BaseBroadcastBoolOp() {
    }
}

