/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import java.util.HashMap;
import java.util.HashSet;
import lombok.NonNull;
import org.nd4j.autodiff.functions.DifferentialFunctionFactory;
import org.nd4j.autodiff.samediff.ArgumentInterceptor;
import org.nd4j.autodiff.samediff.NameScope;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.SameDiffLambda;
import org.nd4j.autodiff.samediff.SameDiffNoArgSingleLambda;
import org.nd4j.autodiff.samediff.SameDiffSingleLambda;
import org.nd4j.autodiff.samediff.internal.SameDiffOp;
import org.nd4j.autodiff.samediff.ops.SDValidation;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Merge;
import org.nd4j.linalg.api.ops.impl.shape.OneHot;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.GradientBackwardsMarker;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.shade.guava.collect.Sets;

public abstract class SDBaseOps {
    protected SDVariable gradientBackwardsMarker(SDVariable x) {
        return this.gradientBackwardsMarker(this.generateNewVarName(new GradientBackwardsMarker().opName(), 0), x);
    }

    protected SDVariable gradientBackwardsMarker(String name, SDVariable x) {
        SDVariable result = this.f().gradientBackwardsMarker(x);
        return this.updateVariableNameAndReference(result, name);
    }

    protected abstract String generateNewVarName(String var1, int var2);

    protected abstract DifferentialFunctionFactory f();

    protected abstract SDVariable updateVariableNameAndReference(SDVariable var1, String var2);

    protected abstract SameDiff sd();

    public SDVariable argmax(SDVariable in, int ... dimensions) {
        return this.argmax(null, in, false, dimensions);
    }

    public SDVariable argmax(String name, SDVariable in, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("argmax", in);
        SDVariable ret = this.f().argmax(in, keepDims, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable argmax(SDVariable in, boolean keepDims, int ... dimensions) {
        return this.argmax(null, in, keepDims, dimensions);
    }

    public SDVariable argmax(String name, SDVariable in, int ... dimensions) {
        return this.argmax(name, in, false, dimensions);
    }

    public SDVariable argmin(SDVariable in, int ... dimensions) {
        return this.argmin(null, in, dimensions);
    }

    public SDVariable argmin(String name, SDVariable in, int ... dimensions) {
        return this.argmin(name, in, false, dimensions);
    }

    public SDVariable argmin(String name, SDVariable in, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("argmin", in);
        SDVariable ret = this.f().argmin(in, keepDims, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable argmin(SDVariable in, boolean keepDims, int ... dimensions) {
        return this.argmin(null, in, keepDims, dimensions);
    }

    public SDVariable assign(SDVariable x, SDVariable y) {
        return this.assign(null, x, y);
    }

    public SDVariable assign(String name, SDVariable x, SDVariable y) {
        SDVariable ret = this.f().assign(x, y);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable assign(SDVariable in, Number value) {
        return this.assign(null, in, value);
    }

    public SDVariable assign(String name, SDVariable in, Number value) {
        SDVariable ret = this.f().assign(in, value);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable[] batchMmul(SDVariable[] matricesA, SDVariable[] matricesB, boolean transposeA, boolean transposeB) {
        return this.batchMmul(null, matricesA, matricesB, transposeA, transposeB);
    }

    public SDVariable[] batchMmul(String[] names, SDVariable[] matricesA, SDVariable[] matricesB, boolean transposeA, boolean transposeB) {
        SDValidation.validateSameType("batchMmul", true, matricesA);
        SDValidation.validateSameType("batchMmul", true, matricesB);
        SDVariable[] result = this.f().batchMmul(matricesA, matricesB, transposeA, transposeB);
        return this.updateVariableNamesAndReferences(result, names);
    }

    protected abstract SDVariable[] updateVariableNamesAndReferences(SDVariable[] var1, String[] var2);

    public SDVariable[] batchMmul(SDVariable[] matricesA, SDVariable[] matricesB) {
        return this.batchMmul(null, matricesA, matricesB, false, false);
    }

    public SDVariable castTo(SDVariable toCast, DataType toType) {
        return this.castTo(null, toCast, toType);
    }

    public SDVariable castTo(String name, SDVariable toCast, DataType toType) {
        SDVariable ret = this.f().cast(toCast, toType);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable concat(int dimension, SDVariable ... inputs) {
        return this.concat(null, dimension, inputs);
    }

    public SDVariable concat(String name, int dimension, SDVariable ... inputs) {
        SDValidation.validateSameType("concat", false, inputs);
        SDVariable result = this.f().concat(dimension, inputs);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable cumprod(SDVariable in, boolean exclusive, boolean reverse, int ... axis) {
        return this.cumprod(null, in, exclusive, reverse, axis);
    }

    public SDVariable cumprod(String name, SDVariable in, boolean exclusive, boolean reverse, int ... axis) {
        SDValidation.validateNumerical("cumprod", in);
        SDVariable ret = this.f().cumprod(in, exclusive, reverse, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable cumsum(SDVariable in, boolean exclusive, boolean reverse, int ... axis) {
        return this.cumsum(null, in, exclusive, reverse, axis);
    }

    public SDVariable cumsum(String name, SDVariable in, boolean exclusive, boolean reverse, int ... axis) {
        SDValidation.validateNumerical("cumsum", in);
        SDVariable ret = this.f().cumsum(in, exclusive, reverse, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable dot(SDVariable x, SDVariable y, int ... dimensions) {
        return this.dot(null, x, y, dimensions);
    }

    public SDVariable dot(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDValidation.validateNumerical("dot", x, y);
        SDVariable ret = this.f().dot(x, y, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable[] dynamicPartition(SDVariable x, SDVariable partitions, int numPartitions) {
        return this.dynamicPartition(null, x, partitions, numPartitions);
    }

    public SDVariable[] dynamicPartition(String[] name, SDVariable x, SDVariable partitions, int numPartitions) {
        SDVariable[] ret = this.f().dynamicPartition(x, partitions, numPartitions);
        return this.updateVariableNamesAndReferences(ret, name);
    }

    public SDVariable dynamicStitch(SDVariable[] indices, SDVariable[] x) {
        return this.dynamicStitch(null, indices, x);
    }

    public SDVariable dynamicStitch(String name, SDVariable[] indices, SDVariable[] x) {
        SDVariable ret = this.f().dynamicStitch(indices, x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable eq(SDVariable x, double y) {
        return this.eq(null, x, y);
    }

    public SDVariable eq(String name, SDVariable x, double y) {
        SDVariable result = this.f().eq(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable eq(SDVariable x, SDVariable y) {
        return this.eq(null, x, y);
    }

    public SDVariable eq(String name, SDVariable x, SDVariable y) {
        SDVariable result = this.f().eq(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable expandDims(SDVariable x, int axis) {
        return this.expandDims(null, x, axis);
    }

    public SDVariable expandDims(String name, SDVariable x, int axis) {
        SDVariable result = this.f().expandDims(x, axis);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable fill(SDVariable shape, DataType dataType, double value) {
        return this.fill(null, shape, dataType, value);
    }

    public SDVariable fill(String name, SDVariable shape, DataType dataType, double value) {
        SDVariable result = this.f().fill(shape, dataType, value);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable gather(SDVariable df, int[] indices, int axis) {
        return this.gather(null, df, indices, axis);
    }

    public SDVariable gather(String name, SDVariable df, int[] indices, int axis) {
        SDVariable ret = this.f().gather(df, indices, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable gather(SDVariable df, SDVariable indices, int axis) {
        return this.gather(null, df, indices, axis);
    }

    public SDVariable gather(String name, SDVariable df, SDVariable indices, int axis) {
        SDVariable ret = this.f().gather(df, indices, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable gatherNd(SDVariable df, SDVariable indices) {
        return this.gatherNd(null, df, indices);
    }

    public SDVariable gatherNd(String name, SDVariable df, SDVariable indices) {
        SDVariable ret = this.f().gatherNd(df, indices);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable gt(SDVariable x, double y) {
        return this.gt(null, x, y);
    }

    public SDVariable gt(String name, SDVariable x, double y) {
        SDValidation.validateNumerical("greater than (gt)", x);
        SDVariable result = this.f().gt(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable gt(SDVariable x, SDVariable y) {
        return this.gt(null, x, y);
    }

    public SDVariable gt(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("greater than (gt)", x, y);
        SDVariable result = this.f().gt(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable gte(SDVariable x, double y) {
        return this.gte(null, x, y);
    }

    public SDVariable gte(String name, SDVariable x, double y) {
        SDValidation.validateNumerical("greater than or equal (gte)", x);
        SDVariable result = this.f().gte(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable gte(SDVariable x, SDVariable y) {
        return this.gte(null, x, y);
    }

    public SDVariable gte(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("greater than or equal (gte)", x, y);
        SDVariable result = this.f().gte(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable identity(SDVariable input) {
        return this.identity(null, input);
    }

    public SDVariable identity(String name, SDVariable input) {
        SDVariable s = this.f().identity(input);
        return this.updateVariableNameAndReference(s, name);
    }

    public SDVariable invertPermutation(SDVariable input) {
        return this.invertPermutation(null, input);
    }

    public SDVariable invertPermutation(String name, SDVariable input) {
        SDValidation.validateInteger("invert permutation", input);
        SDVariable ret = this.f().invertPermutation(input, false);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable isNumericTensor(SDVariable x) {
        return this.isNumericTensor(null, x);
    }

    public SDVariable isNumericTensor(String name, SDVariable x) {
        SDVariable result = this.f().isNumericTensor(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable linspace(DataType dataType, double start, double stop, long number) {
        return this.linspace(dataType, start, stop, number);
    }

    public SDVariable linspace(String name, DataType dataType, double start, double stop, long number) {
        SDVariable ret = this.f().linspace(this.sd().constant(start), this.sd().constant(stop), this.sd().constant(number), dataType);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable linspace(String name, SDVariable from, SDVariable to, SDVariable length, DataType dt) {
        SDVariable ret = this.f().linspace(from, to, length, dt);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable lt(SDVariable x, double y) {
        return this.lt(null, x, y);
    }

    public SDVariable lt(String name, SDVariable x, double y) {
        SDValidation.validateNumerical("less than (lt)", x);
        SDVariable result = this.f().lt(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lt(SDVariable x, SDVariable y) {
        return this.lt(null, x, y);
    }

    public SDVariable lt(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("less than (lt)", x, y);
        SDVariable result = this.f().lt(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lte(SDVariable x, double y) {
        return this.lte(null, x, y);
    }

    public SDVariable lte(String name, SDVariable x, double y) {
        SDValidation.validateNumerical("less than or equal (lte)", x);
        SDVariable result = this.f().lte(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lte(SDVariable x, SDVariable y) {
        return this.lte(null, x, y);
    }

    public SDVariable lte(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("less than or equal (lte)", x, y);
        SDVariable result = this.f().lte(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable matchCondition(SDVariable in, Condition condition) {
        return this.matchCondition(null, in, condition);
    }

    public SDVariable matchCondition(String name, SDVariable in, Condition condition) {
        SDVariable ret = this.f().matchCondition(in, condition);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable matchConditionCount(SDVariable in, Condition condition) {
        return this.matchConditionCount(null, in, condition);
    }

    public SDVariable matchConditionCount(String name, SDVariable in, Condition condition) {
        return this.matchConditionCount(name, in, condition, false, new int[0]);
    }

    public SDVariable matchConditionCount(String name, SDVariable in, Condition condition, boolean keepDim, int ... dimensions) {
        SDVariable ret = this.f().matchConditionCount(in, condition, keepDim, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable max(SDVariable x, int ... dimensions) {
        return this.max(null, x, dimensions);
    }

    public SDVariable max(String name, SDVariable x, int ... dimensions) {
        return this.max(name, x, false, dimensions);
    }

    public SDVariable max(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("max reduction", x);
        SDVariable result = this.f().max(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable max(SDVariable first, SDVariable second) {
        return this.max(null, first, second);
    }

    public SDVariable max(String name, SDVariable first, SDVariable second) {
        SDValidation.validateNumerical("pairwise maxiumum (max)", first, second);
        SDVariable result = this.f().max(first, second);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable mean(SDVariable x) {
        return this.mean(null, x, new int[0]);
    }

    public SDVariable mean(String name, SDVariable x, int ... dimension) {
        return this.mean(name, x, false, dimension);
    }

    public SDVariable mean(String name, SDVariable x, boolean keepDims, int ... dimension) {
        SDValidation.validateNumerical("mean reduction", x);
        SDVariable result = this.f().mean(x, keepDims, dimension);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable mean(SDVariable x, int ... dimension) {
        return this.mean(null, x, dimension);
    }

    public SDVariable min(SDVariable x, int ... dimensions) {
        return this.min(null, x, dimensions);
    }

    public SDVariable min(String name, SDVariable x, int ... dimensions) {
        return this.min(name, x, false, dimensions);
    }

    public SDVariable min(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("min reduction", x);
        SDVariable result = this.f().min(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable min(SDVariable first, SDVariable second) {
        return this.min(null, first, second);
    }

    public SDVariable min(String name, SDVariable first, SDVariable second) {
        SDValidation.validateNumerical("mean (pairwise)", first, second);
        SDVariable result = this.f().min(first, second);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable mmul(SDVariable x, SDVariable y, MMulTranspose transpose) {
        return this.mmul(null, x, y, transpose);
    }

    public SDVariable mmul(String name, SDVariable x, SDVariable y, MMulTranspose transpose) {
        SDValidation.validateNumerical("matrix multiplication (mmul)", x, y);
        SDVariable result = this.f().mmul(x, y, transpose);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable mmul(SDVariable x, SDVariable y) {
        return this.mmul(null, x, y);
    }

    public SDVariable mmul(String name, SDVariable x, SDVariable y) {
        return this.mmul(name, x, y, MMulTranspose.allFalse());
    }

    public SDVariable neq(SDVariable x, double y) {
        return this.neq(null, x, y);
    }

    public SDVariable neq(String name, SDVariable x, double y) {
        SDValidation.validateNumerical("not equals (neq)", x);
        SDVariable result = this.f().neq(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable neq(SDVariable x, SDVariable y) {
        return this.neq(null, x, y);
    }

    public SDVariable neq(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("not equals (neq)", x, y);
        SDVariable result = this.f().neq(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable norm1(String name, SDVariable x, int ... dimensions) {
        return this.norm1(name, x, false, dimensions);
    }

    public SDVariable norm1(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("norm1 reduction", x);
        SDVariable result = this.f().norm1(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable norm2(String name, SDVariable x, int ... dimensions) {
        return this.norm2(name, x, false, dimensions);
    }

    public SDVariable norm2(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("norm2 reduction", x);
        SDVariable result = this.f().norm2(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable normmax(String name, SDVariable x, int ... dimensions) {
        return this.normmax(name, x, false, dimensions);
    }

    public SDVariable normmax(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("norm max reduction", x);
        SDVariable result = this.f().normmax(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable oneHot(SDVariable indices, int depth) {
        return this.oneHot(null, indices, depth, -1, 1.0, 0.0);
    }

    public SDVariable oneHot(String name, SDVariable indices, int depth, int axis, double on, double off) {
        return this.oneHot(name, indices, depth, axis, on, off, OneHot.DEFAULT_DTYPE);
    }

    public SDVariable oneHot(String name, SDVariable indices, int depth, int axis, double on, double off, DataType dataType) {
        SDValidation.validateInteger("oneHot", "indices", indices);
        SDVariable ret = this.f().onehot(indices, depth, axis, on, off, dataType);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable oneHot(SDVariable indices, int depth, int axis, double on, double off) {
        return this.oneHot(null, indices, depth, axis, on, off, OneHot.DEFAULT_DTYPE);
    }

    public SDVariable oneHot(SDVariable indices, int depth, int axis, double on, double off, DataType dataType) {
        return this.oneHot(null, indices, depth, axis, on, off, dataType);
    }

    public SDVariable oneHot(String name, SDVariable indices, int depth) {
        return this.oneHot(name, indices, depth, -1, 1.0, 0.0);
    }

    public SDVariable onesLike(SDVariable input) {
        return this.onesLike(null, input);
    }

    public SDVariable onesLike(String name, SDVariable input) {
        return this.onesLike(name, input, input.dataType());
    }

    public SDVariable onesLike(String name, @NonNull SDVariable input, @NonNull DataType dataType) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked @NonNull but is null");
        }
        SDVariable ret = this.f().onesLike(name, input, dataType);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable parallel_stack(SDVariable[] values) {
        return this.parallel_stack(null, values);
    }

    public SDVariable parallel_stack(String name, SDVariable[] values) {
        SDValidation.validateSameType("parallel_stack", false, values);
        SDVariable ret = this.f().parallel_stack(values);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable permute(SDVariable x, int ... dimensions) {
        return this.permute(null, x, dimensions);
    }

    public SDVariable permute(String name, SDVariable x, int ... dimensions) {
        SDVariable result = this.f().permute(x, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable permute(String name, SDVariable x, SDVariable dimensions) {
        SDVariable result = this.f().permute(x, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable prod(SDVariable x, int ... dimensions) {
        return this.prod(null, x, dimensions);
    }

    public SDVariable prod(String name, SDVariable x, int ... dimensions) {
        return this.prod(name, x, false, dimensions);
    }

    public SDVariable prod(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("product reduction (prod)", x);
        SDVariable result = this.f().prod(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable range(double from, double to, double step, DataType dataType) {
        return this.range(null, from, to, step, dataType);
    }

    public SDVariable range(String name, double from, double to, double step, DataType dataType) {
        SDVariable ret = this.f().range(from, to, step, dataType);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable range(String name, SDVariable from, SDVariable to, SDVariable step, DataType dataType) {
        SDVariable ret = this.f().range(from, to, step, dataType);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable rank(SDVariable in) {
        return this.rank(null, in);
    }

    public SDVariable rank(String name, SDVariable in) {
        SDVariable ret = this.f().rank(in);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable repeat(SDVariable df, int axis) {
        return this.repeat(null, df, axis);
    }

    public SDVariable repeat(String name, SDVariable df, int axis) {
        SDVariable ret = this.f().repeat(df, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable replaceWhere(SDVariable update, SDVariable from, Condition condition) {
        return this.replaceWhere(null, update, from, condition);
    }

    public SDVariable replaceWhere(String name, SDVariable update, SDVariable from, Condition condition) {
        SDVariable ret = this.f().replaceWhere(update, from, condition);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable replaceWhere(SDVariable update, Number value, Condition condition) {
        return this.replaceWhere(null, update, value, condition);
    }

    public SDVariable replaceWhere(String name, SDVariable update, Number value, Condition condition) {
        SDVariable ret = this.f().replaceWhere(update, value, condition);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable reshape(SDVariable x, long ... shape) {
        return this.reshape(null, x, shape);
    }

    public SDVariable reshape(String name, SDVariable x, long ... shape) {
        SDVariable result = this.f().reshape(x, shape);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable reshape(SDVariable x, int ... shape) {
        return this.reshape((String)null, x, shape);
    }

    public SDVariable reshape(String name, SDVariable x, int ... shape) {
        SDVariable result = this.f().reshape(x, shape);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable reshape(SDVariable x, SDVariable shape) {
        return this.reshape(null, x, shape);
    }

    public SDVariable reshape(String name, SDVariable x, SDVariable shape) {
        SDValidation.validateInteger("reshape", "shape", shape);
        SDVariable result = this.f().reshape(x, shape);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable reverse(SDVariable x, int ... dimensions) {
        return this.reverse(null, x, dimensions);
    }

    public SDVariable reverse(String name, SDVariable x, int ... dimensions) {
        SDVariable ret = this.f().reverse(x, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable reverseSequence(SDVariable x, SDVariable seq_lengths, int seqDim, int batchDim) {
        return this.reverseSequence(null, x, seq_lengths, seqDim, batchDim);
    }

    public SDVariable reverseSequence(String name, SDVariable x, SDVariable seq_lengths, int seqDim, int batchDim) {
        SDVariable ret = this.f().reverseSequence(x, seq_lengths, seqDim, batchDim);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable reverseSequence(SDVariable x, SDVariable seq_lengths) {
        return this.reverseSequence(null, x, seq_lengths);
    }

    public SDVariable reverseSequence(String name, SDVariable x, SDVariable seq_lengths) {
        SDVariable ret = this.f().reverseSequence(x, seq_lengths);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scalarFloorMod(SDVariable in, Number value) {
        return this.scalarFloorMod(null, in, value);
    }

    public SDVariable scalarFloorMod(String name, SDVariable in, Number value) {
        SDValidation.validateNumerical("floorMod", in);
        SDVariable ret = this.f().scalarFloorMod(in, value);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scalarMax(SDVariable in, Number value) {
        return this.scalarMax(null, in, value);
    }

    public SDVariable scalarMax(String name, SDVariable in, Number value) {
        SDValidation.validateNumerical("max", in);
        SDVariable ret = this.f().scalarMax(in, value);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scalarMin(SDVariable in, Number value) {
        return this.scalarMin(null, in, value);
    }

    public SDVariable scalarMin(String name, SDVariable in, Number value) {
        SDValidation.validateNumerical("min", in);
        SDVariable ret = this.f().scalarMin(in, value);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scalarSet(SDVariable in, Number set) {
        return this.scalarSet(null, in, set);
    }

    public SDVariable scalarSet(String name, SDVariable in, Number set) {
        SDVariable ret = this.f().scalarSet(in, set);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterAdd(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterAdd(null, ref, indices, updates);
    }

    public SDVariable scatterAdd(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateInteger("scatterAdd", "indices", indices);
        SDVariable ret = this.f().scatterAdd(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterDiv(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterDiv(null, ref, indices, updates);
    }

    public SDVariable scatterDiv(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateInteger("scatterDiv", "indices", indices);
        SDVariable ret = this.f().scatterDiv(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterMax(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterMax(null, ref, indices, updates);
    }

    public SDVariable scatterMax(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateInteger("scatterMax", "indices", indices);
        SDVariable ret = this.f().scatterMax(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterMin(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterMin(null, ref, indices, updates);
    }

    public SDVariable scatterMin(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateInteger("scatterMin", "indices", indices);
        SDVariable ret = this.f().scatterMin(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterMul(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterMul(null, ref, indices, updates);
    }

    public SDVariable scatterMul(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateInteger("scatterMul", "indices", indices);
        SDVariable ret = this.f().scatterMul(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterSub(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterSub(null, ref, indices, updates);
    }

    public SDVariable scatterSub(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateInteger("scatterSub", "indices", indices);
        SDVariable ret = this.f().scatterSub(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterUpdate(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterUpdate(null, ref, indices, updates);
    }

    public SDVariable scatterUpdate(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDValidation.validateInteger("scatterUpdate", "indices", indices);
        SDVariable ret = this.f().scatterUpdate(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable segmentMax(SDVariable data, SDVariable segmentIds) {
        return this.segmentMax(null, data, segmentIds);
    }

    public SDVariable segmentMax(String name, SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentMax", "data", data);
        SDValidation.validateInteger("segmentMax", "segmentIds", segmentIds);
        SDVariable ret = this.f().segmentMax(data, segmentIds);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable segmentMean(SDVariable data, SDVariable segmentIds) {
        return this.segmentMean(null, data, segmentIds);
    }

    public SDVariable segmentMean(String name, SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentMean", "data", data);
        SDValidation.validateInteger("segmentMean", "segmentIds", segmentIds);
        SDVariable ret = this.f().segmentMean(data, segmentIds);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable segmentMin(SDVariable data, SDVariable segmentIds) {
        return this.segmentMin(null, data, segmentIds);
    }

    public SDVariable segmentMin(String name, SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentMin", "data", data);
        SDValidation.validateInteger("segmentMin", "segmentIds", segmentIds);
        SDVariable ret = this.f().segmentMin(data, segmentIds);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable segmentProd(SDVariable data, SDVariable segmentIds) {
        return this.segmentProd(null, data, segmentIds);
    }

    public SDVariable segmentProd(String name, SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentProd", "data", data);
        SDValidation.validateInteger("segmentProd", "segmentIds", segmentIds);
        SDVariable ret = this.f().segmentProd(data, segmentIds);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable segmentSum(SDVariable data, SDVariable segmentIds) {
        return this.segmentSum(null, data, segmentIds);
    }

    public SDVariable segmentSum(String name, SDVariable data, SDVariable segmentIds) {
        SDValidation.validateNumerical("segmentSum", "data", data);
        SDValidation.validateInteger("segmentSum", "segmentIds", segmentIds);
        SDVariable ret = this.f().segmentSum(data, segmentIds);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sequenceMask(SDVariable lengths, int maxLen, DataType dataType) {
        return this.sequenceMask(null, lengths, maxLen, dataType);
    }

    public SDVariable sequenceMask(String name, SDVariable lengths, int maxLen, DataType dataType) {
        SDValidation.validateInteger("sequenceMask", "lengths", lengths);
        SDVariable ret = this.f().sequenceMask(lengths, maxLen, dataType);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sequenceMask(String name, SDVariable lengths, DataType dataType) {
        SDVariable ret = this.f().sequenceMask(lengths, dataType);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sequenceMask(SDVariable lengths, DataType dataType) {
        return this.sequenceMask(lengths, null, dataType);
    }

    public SDVariable sequenceMask(SDVariable lengths, SDVariable maxLen, DataType dataType) {
        return this.sequenceMask(null, lengths, maxLen, dataType);
    }

    public SDVariable sequenceMask(String name, SDVariable lengths, SDVariable maxLen, DataType dataType) {
        SDValidation.validateInteger("sequenceMask", "lengths", lengths);
        SDVariable ret = this.f().sequenceMask(lengths, maxLen, dataType);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable shape(SDVariable input) {
        return this.shape(null, input);
    }

    public SDVariable shape(String name, SDVariable input) {
        SDVariable ret = this.f().shape(input);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable size(SDVariable in) {
        return this.size(null, in);
    }

    public SDVariable size(String name, SDVariable in) {
        SDVariable ret = this.f().size(in);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sizeAt(SDVariable in, int dimension) {
        return this.sizeAt(null, in, dimension);
    }

    public SDVariable sizeAt(String name, SDVariable in, int dimension) {
        SDVariable ret = this.f().sizeAt(in, dimension);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable slice(SDVariable input, int[] begin, int[] size) {
        return this.slice(null, input, begin, size);
    }

    public SDVariable slice(SDVariable input, SDVariable begin, SDVariable size) {
        return this.slice(null, input, begin, size);
    }

    public SDVariable slice(String name, SDVariable input, int[] begin, int[] size) {
        SDVariable ret = this.f().slice(input, begin, size);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable slice(String name, SDVariable input, @NonNull SDVariable begin, @NonNull SDVariable size) {
        if (begin == null) {
            throw new NullPointerException("begin is marked @NonNull but is null");
        }
        if (size == null) {
            throw new NullPointerException("size is marked @NonNull but is null");
        }
        SDVariable ret = this.f().slice(input, begin, size);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable squaredNorm(SDVariable x, int ... dimensions) {
        return this.squaredNorm(null, x, false, dimensions);
    }

    public SDVariable squaredNorm(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("squaredNorm", x);
        SDVariable result = this.f().squaredNorm(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable squaredNorm(String name, SDVariable x, int ... dimensions) {
        return this.squaredNorm(name, x, false, dimensions);
    }

    public SDVariable squaredNorm(SDVariable x, boolean keepDims, int ... dimensions) {
        return this.squaredNorm(null, x, keepDims, dimensions);
    }

    public SDVariable squeeze(SDVariable x, int axis) {
        return this.squeeze(null, x, axis);
    }

    public SDVariable squeeze(String name, SDVariable x, int axis) {
        SDVariable result = this.f().squeeze(x, axis);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable stack(int axis, SDVariable ... values) {
        return this.stack(null, axis, values);
    }

    public SDVariable stack(String name, int axis, SDVariable ... values) {
        SDValidation.validateSameType("stack", false, values);
        SDVariable ret = this.f().stack(values, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable standardDeviation(SDVariable x, boolean biasCorrected, int ... dimensions) {
        return this.standardDeviation(null, x, biasCorrected, dimensions);
    }

    public SDVariable standardDeviation(String name, SDVariable x, boolean biasCorrected, int ... dimensions) {
        return this.standardDeviation(name, x, biasCorrected, false, dimensions);
    }

    public SDVariable standardDeviation(String name, SDVariable x, boolean biasCorrected, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("standard deviation", x);
        SDVariable result = this.f().std(x, biasCorrected, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable stridedSlice(SDVariable input, int[] begin, int[] end, int[] strides) {
        return this.stridedSlice((String)null, input, begin, end, strides);
    }

    public SDVariable stridedSlice(String name, SDVariable input, int[] begin, int[] end, int[] strides) {
        return this.stridedSlice(name, input, begin, end, strides, 0, 0, 0, 0, 0);
    }

    public SDVariable stridedSlice(String name, SDVariable in, int[] begin, int[] end, int[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        SDVariable ret = this.f().stridedSlice(in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable stridedSlice(SDVariable input, long[] begin, long[] end, long[] strides) {
        return this.stridedSlice(null, input, begin, end, strides);
    }

    public SDVariable stridedSlice(String name, SDVariable input, long[] begin, long[] end, long[] strides) {
        return this.stridedSlice(name, input, begin, end, strides, 0, 0, 0, 0, 0);
    }

    public SDVariable stridedSlice(String name, SDVariable in, long[] begin, long[] end, long[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        SDVariable ret = this.f().stridedSlice(in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable stridedSlice(SDVariable in, int[] begin, int[] end, int[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        return this.stridedSlice((String)null, in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask);
    }

    public SDVariable stridedSlice(SDVariable in, long[] begin, long[] end, long[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        return this.stridedSlice(null, in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask);
    }

    public SDVariable sum(SDVariable x, int ... dimensions) {
        return this.sum(null, x, dimensions);
    }

    public SDVariable sum(String name, SDVariable x, int ... dimensions) {
        return this.sum(name, x, false, dimensions);
    }

    public SDVariable sum(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDValidation.validateNumerical("sum reduction", x);
        SDVariable result = this.f().sum(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sum(SDVariable x, boolean keepDims, int ... dimensions) {
        return this.sum(null, x, keepDims, dimensions);
    }

    public SDVariable tensorMmul(SDVariable x, SDVariable y, int[][] dimensions) {
        return this.tensorMmul(null, x, y, dimensions);
    }

    public SDVariable tensorMmul(String name, SDVariable x, SDVariable y, int[][] dimensions) {
        SDValidation.validateNumerical("tensorMmul", x, y);
        SDVariable result = this.f().tensorMmul(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable tile(SDVariable x, int ... repeat) {
        return this.tile(null, x, repeat);
    }

    public SDVariable tile(String name, SDVariable x, int ... repeat) {
        SDVariable result = this.f().tile(x, repeat);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable tile(SDVariable x, SDVariable repeat) {
        return this.tile(null, x, repeat);
    }

    public SDVariable tile(String name, SDVariable x, SDVariable repeat) {
        SDVariable result = this.f().tile(x, repeat);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable transpose(SDVariable x) {
        return this.transpose(null, x);
    }

    public SDVariable transpose(String name, SDVariable x) {
        SDVariable result = this.f().transpose(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable unsortedSegmentMax(SDVariable data, SDVariable segmentIds, int numSegments) {
        return this.unsortedSegmentMax(null, data, segmentIds, numSegments);
    }

    public SDVariable unsortedSegmentMax(String name, SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentMax", "data", data);
        SDValidation.validateInteger("unsortedSegmentMax", "segmentIds", segmentIds);
        SDVariable ret = this.f().unsortedSegmentMax(data, segmentIds, numSegments);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable unsortedSegmentMean(SDVariable data, SDVariable segmentIds, int numSegments) {
        return this.unsortedSegmentMean(null, data, segmentIds, numSegments);
    }

    public SDVariable unsortedSegmentMean(String name, SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentMean", "data", data);
        SDValidation.validateInteger("unsortedSegmentMean", "segmentIds", segmentIds);
        SDVariable ret = this.f().unsortedSegmentMean(data, segmentIds, numSegments);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable unsortedSegmentMin(SDVariable data, SDVariable segmentIds, int numSegments) {
        return this.unsortedSegmentMin(null, data, segmentIds, numSegments);
    }

    public SDVariable unsortedSegmentMin(String name, SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentMin", "data", data);
        SDValidation.validateInteger("unsortedSegmentMin", "segmentIds", segmentIds);
        SDVariable ret = this.f().unsortedSegmentMin(data, segmentIds, numSegments);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable unsortedSegmentProd(SDVariable data, SDVariable segmentIds, int numSegments) {
        return this.unsortedSegmentProd(null, data, segmentIds, numSegments);
    }

    public SDVariable unsortedSegmentProd(String name, SDVariable data, SDVariable segmentIds, int numSegments) {
        SDValidation.validateNumerical("unsortedSegmentProd", "data", data);
        SDValidation.validateInteger("unsortedSegmentProd", "segmentIds", segmentIds);
        SDVariable ret = this.f().unsortedSegmentProd(data, segmentIds, numSegments);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable unsortedSegmentSqrtN(SDVariable data, SDVariable segmentIds, int numSegments) {
        return this.unsortedSegmentSqrtN(null, data, segmentIds, numSegments);
    }

    public SDVariable unsortedSegmentSqrtN(String name, SDVariable data, SDVariable segmentIds, int numSegments) {
        SDVariable ret = this.f().unsortedSegmentSqrtN(data, segmentIds, numSegments);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable unsortedSegmentSum(@NonNull SDVariable data, @NonNull SDVariable segmentIds, int numSegments) {
        if (data == null) {
            throw new NullPointerException("data is marked @NonNull but is null");
        }
        if (segmentIds == null) {
            throw new NullPointerException("segmentIds is marked @NonNull but is null");
        }
        return this.unsortedSegmentSum(null, data, segmentIds, numSegments);
    }

    public SDVariable unsortedSegmentSum(String name, @NonNull SDVariable data, @NonNull SDVariable segmentIds, int numSegments) {
        if (data == null) {
            throw new NullPointerException("data is marked @NonNull but is null");
        }
        if (segmentIds == null) {
            throw new NullPointerException("segmentIds is marked @NonNull but is null");
        }
        SDValidation.validateNumerical("unsortedSegmentSum", "data", data);
        SDValidation.validateInteger("unsortedSegmentSum", "segmentIds", segmentIds);
        SDVariable ret = this.f().unsortedSegmentSum(data, segmentIds, numSegments);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable[] unstack(SDVariable value, int axis) {
        return this.unstack(null, value, axis);
    }

    public SDVariable[] unstack(String[] names, @NonNull SDVariable value, int axis) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        SDVariable[] ret = this.f().unstack(value, axis);
        return this.updateVariableNamesAndReferences(ret, names);
    }

    public SDVariable[] unstack(@NonNull SDVariable value, int axis, int num) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        return this.unstack(null, value, axis, num);
    }

    public SDVariable[] unstack(String[] names, @NonNull SDVariable value, int axis, int num) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        SDVariable[] ret = this.f().unstack(value, axis, num);
        return this.updateVariableNamesAndReferences(ret, names);
    }

    public SDVariable variance(@NonNull SDVariable x, boolean biasCorrected, int ... dimensions) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        return this.variance(null, x, biasCorrected, dimensions);
    }

    public SDVariable variance(String name, @NonNull SDVariable x, boolean biasCorrected, int ... dimensions) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        return this.variance(name, x, biasCorrected, false, dimensions);
    }

    public SDVariable variance(String name, @NonNull SDVariable x, boolean biasCorrected, boolean keepDims, int ... dimensions) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        SDValidation.validateNumerical("variance", x);
        SDVariable result = this.f().variance(x, biasCorrected, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable zerosLike(@NonNull SDVariable input) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        return this.zerosLike(null, input);
    }

    public SDVariable zerosLike(String name, @NonNull SDVariable input) {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        SDVariable ret = this.f().zerosLike(name, input);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable any(SDVariable x, int ... dimensions) {
        return this.any(null, x, dimensions);
    }

    public SDVariable any(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateBool("any", x);
        SDVariable ret = this.f().any(x, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable all(SDVariable x, int ... dimensions) {
        return this.all(null, x, dimensions);
    }

    public SDVariable all(String name, SDVariable x, int ... dimensions) {
        SDValidation.validateBool("all", x);
        SDVariable ret = this.f().all(x, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable[] whileLoop(@NonNull SDVariable[] loopVars, @NonNull SameDiffSingleLambda cond, @NonNull SameDiffLambda body) {
        if (loopVars == null) {
            throw new NullPointerException("loopVars is marked @NonNull but is null");
        }
        if (cond == null) {
            throw new NullPointerException("cond is marked @NonNull but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked @NonNull but is null");
        }
        return this.whileLoop(null, null, loopVars, cond, body);
    }

    public SDVariable[] whileLoop(String loopName, @NonNull SDVariable[] loopVars, @NonNull SameDiffSingleLambda cond, @NonNull SameDiffLambda body) {
        if (loopVars == null) {
            throw new NullPointerException("loopVars is marked @NonNull but is null");
        }
        if (cond == null) {
            throw new NullPointerException("cond is marked @NonNull but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked @NonNull but is null");
        }
        return this.whileLoop(null, loopName, loopVars, cond, body);
    }

    public SDVariable[] whileLoop(String[] outputNames, String loopName, @NonNull SDVariable[] loopVars, @NonNull SameDiffSingleLambda cond, @NonNull SameDiffLambda body) {
        if (loopVars == null) {
            throw new NullPointerException("loopVars is marked @NonNull but is null");
        }
        if (cond == null) {
            throw new NullPointerException("cond is marked @NonNull but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked @NonNull but is null");
        }
        final String frameName = this.sd().newBlockName(loopName == null ? "while" : loopName);
        NameScope loopScope = this.sd().withNameScope(frameName);
        SDVariable[] entered = new SDVariable[loopVars.length];
        for (int i = 0; i < loopVars.length; ++i) {
            entered[i] = this.f().enter(loopVars[i], frameName);
        }
        SDVariable[] merged = new SDVariable[loopVars.length];
        Merge[] mergeOps = new Merge[loopVars.length];
        for (int i = 0; i < loopVars.length; ++i) {
            mergeOps[i] = new Merge(this.sd(), entered[i], entered[i]);
            merged[i] = mergeOps[i].outputVariable();
        }
        NameScope condScope = this.sd().withNameScope("cond");
        SDVariable cond_result = cond.define(this.sd(), merged);
        condScope.close();
        if (cond_result.dataType() != DataType.BOOL) {
            throw new IllegalStateException("Can not use " + cond_result.getVarName() + " as the condition of an While loop, the condition must be a boolean.");
        }
        final HashSet alreadyEntered = Sets.newHashSet();
        SDVariable[] trueSwitches = new SDVariable[loopVars.length];
        SDVariable[] exits = new SDVariable[loopVars.length];
        for (int i = 0; i < loopVars.length; ++i) {
            SDVariable[] s = this.f().switchOp(merged[i], cond_result);
            trueSwitches[i] = s[1];
            alreadyEntered.add(s[1].getVarName());
            exits[i] = this.f().exit(s[0]);
        }
        final HashSet declared = Sets.newHashSet(this.sd().variableMap().keySet());
        final HashMap done = new HashMap();
        this.sd().addArgumentInterceptor(new ArgumentInterceptor(){

            @Override
            public SDVariable intercept(SDVariable argument) {
                if (!declared.contains(argument.getVarName())) {
                    return argument;
                }
                if (alreadyEntered.contains(argument.getVarName())) {
                    return argument;
                }
                if (done.containsKey(argument.getVarName())) {
                    return (SDVariable)done.get(argument.getVarName());
                }
                SDVariable e = SDBaseOps.this.f().enter(argument, frameName, true);
                done.put(argument.getVarName(), e);
                return e;
            }
        });
        NameScope bodyScope = this.sd().withNameScope("body");
        SDVariable[] outs = body.define(this.sd(), trueSwitches);
        bodyScope.close();
        this.sd().removeArgumentInterceptor();
        for (int i = 0; i < loopVars.length; ++i) {
            SDVariable n = this.f().nextIteration(outs[i]);
            mergeOps[i].replaceArg(1, n);
        }
        loopScope.close();
        return this.updateVariableNamesAndReferences(exits, outputNames);
    }

    public SDVariable ifCond(@NonNull SameDiffNoArgSingleLambda cond, @NonNull SameDiffNoArgSingleLambda trueBody, @NonNull SameDiffNoArgSingleLambda falseBody) {
        if (cond == null) {
            throw new NullPointerException("cond is marked @NonNull but is null");
        }
        if (trueBody == null) {
            throw new NullPointerException("trueBody is marked @NonNull but is null");
        }
        if (falseBody == null) {
            throw new NullPointerException("falseBody is marked @NonNull but is null");
        }
        return this.ifCond(null, null, cond, trueBody, falseBody);
    }

    public SDVariable ifCond(String ifName, @NonNull SameDiffNoArgSingleLambda cond, @NonNull SameDiffNoArgSingleLambda trueBody, @NonNull SameDiffNoArgSingleLambda falseBody) {
        if (cond == null) {
            throw new NullPointerException("cond is marked @NonNull but is null");
        }
        if (trueBody == null) {
            throw new NullPointerException("trueBody is marked @NonNull but is null");
        }
        if (falseBody == null) {
            throw new NullPointerException("falseBody is marked @NonNull but is null");
        }
        return this.ifCond(null, ifName, cond, trueBody, falseBody);
    }

    public SDVariable ifCond(String outputName, String ifName, @NonNull SameDiffNoArgSingleLambda cond, @NonNull SameDiffNoArgSingleLambda trueBody, @NonNull SameDiffNoArgSingleLambda falseBody) {
        if (cond == null) {
            throw new NullPointerException("cond is marked @NonNull but is null");
        }
        if (trueBody == null) {
            throw new NullPointerException("trueBody is marked @NonNull but is null");
        }
        if (falseBody == null) {
            throw new NullPointerException("falseBody is marked @NonNull but is null");
        }
        ifName = this.sd().newBlockName(ifName == null ? "if" : ifName);
        NameScope ifScope = this.sd().withNameScope(ifName);
        NameScope condScope = this.sd().withNameScope("cond");
        final SDVariable pred = cond.define(this.sd());
        condScope.close();
        if (pred.dataType() != DataType.BOOL) {
            for (SDVariable v : this.sd().getVariablesInScope(ifScope)) {
                this.sd().getVariables().remove(v.getVarName());
            }
            for (SameDiffOp op : this.sd().getOpsInScope(ifScope)) {
                for (String in : op.getInputsToOp()) {
                    this.sd().removeArgFromOp(in, op.getOp());
                }
                this.sd().getOps().remove(op.getName());
            }
            throw new IllegalStateException("Can not use " + pred.getVarName() + " as the condition of an If statement, the condition must be a boolean.");
        }
        final HashMap<String, SDVariable[]> switches = new HashMap<String, SDVariable[]>();
        final HashSet declared = Sets.newHashSet(this.sd().variableMap().keySet());
        this.sd().addArgumentInterceptor(new ArgumentInterceptor(){

            @Override
            public SDVariable intercept(SDVariable argument) {
                if (!declared.contains(argument.getVarName())) {
                    return argument;
                }
                if (switches.containsKey(argument.getVarName())) {
                    return ((SDVariable[])switches.get(argument.getVarName()))[1];
                }
                SDVariable[] s = SDBaseOps.this.f().switchOp(argument, pred);
                switches.put(argument.getVarName(), s);
                return s[1];
            }
        });
        NameScope trueScope = this.sd().withNameScope("trueBody");
        SDVariable trueOut = trueBody.define(this.sd());
        this.sd().removeArgumentInterceptor();
        if (declared.contains(trueOut.getVarName())) {
            SDVariable[] s = this.f().switchOp(trueOut, pred);
            switches.put(trueOut.getVarName(), s);
            trueOut = s[1];
        }
        trueScope.close();
        final HashSet declared2 = Sets.newHashSet(this.sd().variableMap().keySet());
        this.sd().addArgumentInterceptor(new ArgumentInterceptor(){

            @Override
            public SDVariable intercept(SDVariable argument) {
                if (!declared2.contains(argument.getVarName())) {
                    return argument;
                }
                if (switches.containsKey(argument.getVarName())) {
                    return ((SDVariable[])switches.get(argument.getVarName()))[0];
                }
                SDVariable[] s = SDBaseOps.this.f().switchOp(argument, pred);
                switches.put(argument.getVarName(), s);
                return s[0];
            }
        });
        NameScope falseScope = this.sd().withNameScope("falseBody");
        SDVariable falseOut = falseBody.define(this.sd());
        this.sd().removeArgumentInterceptor();
        if (declared2.contains(falseOut.getVarName())) {
            SDVariable[] s = this.f().switchOp(falseOut, pred);
            switches.put(falseOut.getVarName(), s);
            falseOut = s[0];
        }
        falseScope.close();
        SDVariable output = this.f().merge(trueOut, falseOut);
        ifScope.close();
        return this.updateVariableNameAndReference(output, outputName);
    }
}

