/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import lombok.NonNull;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.listeners.At;
import org.nd4j.autodiff.listeners.Listener;
import org.nd4j.autodiff.listeners.Operation;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.VariableType;
import org.nd4j.autodiff.samediff.internal.SameDiffOp;
import org.nd4j.autodiff.samediff.internal.Variable;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Enter;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Exit;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.LoopCond;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Merge;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.NextIteration;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Switch;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSession<T, O> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSession.class);
    public static final String OUTER_FRAME = "main";
    protected final SameDiff sameDiff;
    protected final Map<VarId, T> nodeOutputs = new HashMap<VarId, T>();
    protected final Map<VarId, List<T>> tensorArrays = new HashMap<VarId, List<T>>();
    protected final Queue<VarId> availableForExec = new LinkedList<VarId>();
    protected final Set<VarId> availableForExecSet = new HashSet<VarId>();
    protected final Set<String> subgraph = new HashSet<String>();
    protected final Map<VarId, Set<VarId>> execInputs = new HashMap<VarId, Set<VarId>>();
    protected final Map<VarId, Set<VarId>> execInputsAllIter = new HashMap<VarId, Set<VarId>>();
    protected final Map<String, Set<String>> execConstInputs = new HashMap<String, Set<String>>();
    protected final Map<String, FrameIter> frameParents = new HashMap<String, FrameIter>();

    public AbstractSession(@NonNull SameDiff sameDiff) {
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked @NonNull but is null");
        }
        this.sameDiff = sameDiff;
    }

    public boolean contains(String variable, String frame, int iteration, FrameIter parentFrameIter) {
        VarId varId = this.newVarId(variable, frame, iteration, parentFrameIter);
        return this.nodeOutputs.containsKey(varId);
    }

    public T get(String variable, String frame, int iteration, FrameIter parentFrameIter) {
        return this.get(variable, frame, iteration, parentFrameIter, true);
    }

    public T get(String variable, String frame, int iteration, FrameIter parentFrameIter, boolean enforceExistence) {
        VarId varId = this.newVarId(variable, frame, iteration, parentFrameIter);
        T out = this.nodeOutputs.get(varId);
        if (enforceExistence) {
            Preconditions.checkNotNull(out, (String)"No output found for variable %s (frame %s, iteration %s)", (Object)variable, (Object)frame, (Object)iteration);
        }
        return out;
    }

    public VarId newVarId(String variable, String frame, int iteration, FrameIter parentFrameIter) {
        return new VarId(variable, frame, iteration, parentFrameIter);
    }

    public VarId newVarId(String variable, FrameIter frameIter) {
        return this.newVarId(variable, frameIter.getFrame(), frameIter.getIteration(), frameIter.getParentFrame());
    }

    @Deprecated
    public Map<String, T> output(@NonNull List<String> variables, Map<String, T> placeholderValues, MultiDataSet batch, Collection<String> requiredActivations, boolean training, At at) {
        if (variables == null) {
            throw new NullPointerException("variables is marked @NonNull but is null");
        }
        if (at == null) {
            at = training ? At.defaultAt(Operation.TRAINING) : At.defaultAt(Operation.INFERENCE);
        }
        return this.output(variables, placeholderValues, batch, requiredActivations, Collections.emptyList(), at);
    }

    public Map<String, T> output(@NonNull List<String> variables, Map<String, T> placeholderValues, MultiDataSet batch, Collection<String> requiredActivations, List<Listener> listeners, At at) {
        if (variables == null) {
            throw new NullPointerException("variables is marked @NonNull but is null");
        }
        Preconditions.checkState((!variables.isEmpty() ? 1 : 0) != 0, (String)"Variables to perform forward pass for must not be empty");
        if (requiredActivations == null) {
            requiredActivations = Collections.emptyList();
        }
        if (at == null) {
            at = At.defaultAt();
        }
        for (String s : variables) {
            Preconditions.checkState((boolean)this.sameDiff.variableMap().containsKey(s), (String)"Requested output variable %s does not exist in SameDiff instance", (Object)s);
        }
        placeholderValues = this.preprocessPlaceholders(placeholderValues);
        this.availableForExec.clear();
        this.availableForExecSet.clear();
        this.subgraph.clear();
        this.execInputs.clear();
        this.execInputsAllIter.clear();
        this.execConstInputs.clear();
        this.nodeOutputs.clear();
        this.tensorArrays.clear();
        ArrayList<String> allRequired = new ArrayList<String>(requiredActivations);
        allRequired.addAll(variables);
        this.initSubgraph(allRequired);
        List<String> phNames = this.sameDiff.inputs();
        if (placeholderValues == null || !placeholderValues.keySet().containsAll(phNames)) {
            for (String s : phNames) {
                Variable v;
                boolean required = false;
                if (variables.contains(s)) {
                    required = true;
                }
                if (!required && (v = this.sameDiff.getVariables().get(s)).getInputsForOp() != null) {
                    for (String string : v.getInputsForOp()) {
                        if (!this.subgraph.contains(string)) continue;
                        required = true;
                        break;
                    }
                }
                if (!required || placeholderValues != null && placeholderValues.containsKey(s)) continue;
                if (s.endsWith("keras_learning_phase")) {
                    placeholderValues.put(s, Nd4j.scalar(at.operation().isTrainingPhase()));
                    continue;
                }
                throw new IllegalStateException("An input placeholder \"" + s + "\" is required to calculate the requested outputs, but a placeholder value was not provided");
            }
        }
        HashMap<String, T> out = new HashMap<String, T>();
        int step = 0;
        while (out.size() < variables.size()) {
            if (this.availableForExec.size() == 0) {
                int missingCount = variables.size() - out.size();
                StringBuilder sb = new StringBuilder();
                sb.append("No variable are available for execution at step ").append(step).append(": ").append(missingCount).append(" values remaining");
                HashSet<String> missing = new HashSet<String>();
                for (String s : variables) {
                    if (out.containsKey(s)) continue;
                    missing.add(s);
                }
                if (missingCount <= 10) {
                    sb.append(". Missing variables: ");
                    sb.append(missing);
                } else {
                    sb.append(". First 10 missing variables: ");
                    Iterator iterator = missing.iterator();
                    for (int i = 0; i < 10 && iterator.hasNext(); ++i) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append((String)iterator.next());
                    }
                }
                String string = sb.toString();
                throw new IllegalStateException(string);
            }
            VarId varToExec = this.availableForExec.remove();
            this.availableForExecSet.remove(varToExec);
            if (this.nodeOutputs.containsKey(varToExec)) {
                if (variables.contains(varToExec.getVariable())) {
                    out.put(varToExec.getVariable(), this.nodeOutputs.get(varToExec));
                }
                this.updateDescendentsForExec(step, varToExec);
                continue;
            }
            Set<VarId> inputsToVar = this.execInputs.get(varToExec);
            VarId allIterInputVar = this.newVarId(varToExec.getVariable(), varToExec.getFrame(), 0, varToExec.getParentFrame());
            Set<VarId> set = this.execInputsAllIter.get(allIterInputVar);
            Set<String> constPhForVar = this.execConstInputs.get(varToExec.getVariable());
            log.trace("Beginning execution step {}: variable {}", (Object)step, (Object)varToExec);
            if (this.sameDiff.getVariable(varToExec.getVariable()).isPlaceHolder()) {
                this.nodeOutputs.put(varToExec, placeholderValues.get(varToExec.getVariable()));
                this.updateDescendentsForExec(step, varToExec);
                if (variables.contains(varToExec.getVariable())) {
                    out.put(varToExec.getVariable(), placeholderValues.get(varToExec.getVariable()));
                }
            } else if (this.sameDiff.getVariable(varToExec.getVariable()).isConstant() || this.sameDiff.getVariable(varToExec.getVariable()).getVariableType() == VariableType.VARIABLE) {
                T phArr = this.getConstantOrVariable(varToExec.getVariable());
                Preconditions.checkNotNull(phArr, (String)"Encountered null placeholder array for constant: %s", (Object)varToExec);
                this.nodeOutputs.put(varToExec, phArr);
                this.updateDescendentsForExec(step, varToExec);
                if (variables.contains(varToExec.getVariable())) {
                    out.put(varToExec.getVariable(), phArr);
                }
            } else if (this.sameDiff.getVariableOutputOp(varToExec.getVariable()) != null) {
                String[] opOutputVarNames;
                FrameIter frameIter;
                String opName = this.sameDiff.getVariables().get(varToExec.getVariable()).getOutputOfOp();
                O parameterizedOp = this.getAndParameterizeOp(opName, frameIter = varToExec.toFrameIter(), inputsToVar, set, constPhForVar, placeholderValues);
                T[] opOutputValues = this.getOutputs(parameterizedOp, frameIter, inputsToVar, set, constPhForVar, listeners, at, batch);
                Preconditions.checkState((opOutputValues.length == (opOutputVarNames = this.sameDiff.getOpById(opName).outputVariablesNames()).length ? 1 : 0) != 0, (String)"Unexpected number of outputs from executed op %s: got %s outputs when %s outputs were expected (%s)", (Object)parameterizedOp.getClass().getSimpleName(), (Object)opOutputValues.length, (Object)opOutputVarNames.length, (Object)opOutputVarNames);
                for (int i = 0; i < opOutputVarNames.length; ++i) {
                    VarId outputVarId;
                    if (opOutputValues[i] == null && parameterizedOp instanceof Switch) continue;
                    Preconditions.checkNotNull(opOutputValues[i], (String)"Encountered null output (output %s) for op %s at execution step %s", (Object)i, (Object)parameterizedOp.getClass().getSimpleName(), (Object)step);
                    boolean addDummyOutput = false;
                    if (parameterizedOp instanceof Enter) {
                        String frame = ((Enter)parameterizedOp).getFrameName();
                        boolean isConstant = ((Enter)parameterizedOp).isConstant();
                        FrameIter outParentFrame = varToExec.getParentFrame();
                        if (isConstant && outParentFrame != null) {
                            for (FrameIter toZero = outParentFrame = outParentFrame.clone(); toZero != null; toZero = toZero.getParentFrame()) {
                                toZero.setIteration(0);
                            }
                        }
                        outputVarId = this.newVarId(opOutputVarNames[i], frame, 0, outParentFrame);
                        addDummyOutput = true;
                    } else if (parameterizedOp instanceof Exit) {
                        outputVarId = this.newVarId(opOutputVarNames[i], varToExec.getFrame(), varToExec.getIteration(), varToExec.getParentFrame());
                        addDummyOutput = true;
                    } else if (parameterizedOp instanceof NextIteration) {
                        outputVarId = this.newVarId(opOutputVarNames[i], varToExec.getFrame(), varToExec.getIteration(), varToExec.getParentFrame());
                        addDummyOutput = true;
                    } else if (parameterizedOp instanceof LoopCond) {
                        outputVarId = this.newVarId(opOutputVarNames[i], varToExec.getFrame(), varToExec.getIteration(), varToExec.getParentFrame());
                        addDummyOutput = true;
                    } else {
                        outputVarId = this.newVarId(opOutputVarNames[i], varToExec.getFrame(), varToExec.getIteration(), varToExec.getParentFrame());
                    }
                    if (addDummyOutput) {
                        this.nodeOutputs.put(this.newVarId(opOutputVarNames[i], varToExec.getFrame(), varToExec.getIteration(), varToExec.getParentFrame()), null);
                    }
                    this.nodeOutputs.put(outputVarId, opOutputValues[i]);
                    this.updateDescendentsForExec(step, outputVarId);
                    if (!variables.contains(opOutputVarNames[i])) continue;
                    out.put(opOutputVarNames[i], opOutputValues[i]);
                }
            } else {
                Variable v = this.sameDiff.getVariables().get(varToExec.getVariable());
                throw new IllegalStateException("Unable to execute variable " + varToExec + " of type " + (Object)((Object)v.getVariable().getVariableType()));
            }
            ++step;
        }
        return out;
    }

    protected void initSubgraph(List<String> variables) {
        LinkedList<String> processingQueue = new LinkedList<String>(variables);
        while (!processingQueue.isEmpty()) {
            String opName;
            String varName = (String)processingQueue.remove();
            String string = opName = this.sameDiff.getVariableOutputOp(varName) == null ? null : this.sameDiff.getVariableOutputOp(varName).getOwnName();
            if (!this.subgraph.contains(varName)) {
                Object vid;
                int numInputs;
                String[] opInputs = opName == null ? null : this.sameDiff.getInputsForOp(this.sameDiff.getOpById(opName));
                List<String> controlDeps = this.sameDiff.getVariables().get(varName).getControlDeps();
                int n = numInputs = opInputs == null ? 0 : opInputs.length;
                if (controlDeps != null) {
                    numInputs += controlDeps.size();
                }
                if (numInputs == 0) {
                    vid = this.newVarId(varName, OUTER_FRAME, 0, null);
                    if (!this.availableForExecSet.contains(vid)) {
                        this.availableForExec.add((VarId)vid);
                        this.availableForExecSet.add((VarId)vid);
                    }
                    this.execInputs.put((VarId)vid, new HashSet());
                }
                this.subgraph.add(varName);
                if (controlDeps != null) {
                    vid = controlDeps.iterator();
                    while (vid.hasNext()) {
                        String s = (String)vid.next();
                        if (this.subgraph.contains(s)) continue;
                        processingQueue.add(s);
                    }
                }
            }
            if (opName == null) continue;
            String[] inputs = this.sameDiff.getInputsForOp(this.sameDiff.getOpById(opName));
            for (String s2 : inputs) {
                if (this.subgraph.contains(s2)) continue;
                processingQueue.add(s2);
            }
            List<String> opControlDeps = this.sameDiff.getOps().get(opName).getControlDeps();
            if (opControlDeps == null) continue;
            for (String s2 : opControlDeps) {
                if (this.subgraph.contains(s2)) continue;
                processingQueue.add(s2);
            }
        }
    }

    protected void updateDescendentsForExec(int execStep, VarId executedVar) {
        VarId vid;
        boolean isConstOrPhInput;
        String varName = executedVar.getVariable();
        Variable var = this.sameDiff.getVariables().get(executedVar.getVariable());
        List<String> l = this.sameDiff.getVariables().get(executedVar.getVariable()).getInputsForOp();
        String[] inputForOps = l == null ? null : l.toArray(new String[l.size()]);
        List<String> controlDepForVars = var.getControlDepsForVar();
        List<String> controlDepForOps = var.getControlDepsForOp();
        SDVariable v = var.getVariable();
        boolean bl = isConstOrPhInput = v.isPlaceHolder() || v.isConstant();
        if (inputForOps != null) {
            for (String string : inputForOps) {
                List<String> opOutputs;
                List<String> opControlDeps;
                List<String> opOutputs2;
                DifferentialFunction fn = this.sameDiff.getOpById(string);
                if (fn instanceof Merge) {
                    List<String> opOutputs22 = this.sameDiff.getOps().get(string).getOutputsOfOp();
                    Preconditions.checkState((opOutputs22.size() == 1 ? 1 : 0) != 0, (String)"Expected only 1 output variable for merge op, got %s", opOutputs22);
                    VarId outVarId = this.newVarId(opOutputs22.get(0), executedVar.getFrame(), executedVar.getIteration(), executedVar.getParentFrame());
                    if (!this.nodeOutputs.containsKey(outVarId) && this.subgraph.contains(outVarId.getVariable()) && !this.availableForExecSet.contains(outVarId)) {
                        this.availableForExec.add(outVarId);
                        this.availableForExecSet.add(outVarId);
                        log.trace("Marked merge op ({}) variable {} as available for execution: input {} is now available", new Object[]{string, outVarId, executedVar});
                    }
                    this.addToExecInputs(isConstOrPhInput, executedVar, outVarId);
                    continue;
                }
                if (fn instanceof Enter) {
                    opOutputs2 = this.sameDiff.getOps().get(string).getOutputsOfOp();
                    Preconditions.checkState((opOutputs2.size() == 1 ? 1 : 0) != 0, (String)"Expected only 1 output variable for enter op, got %s", opOutputs2);
                    Enter e = (Enter)fn;
                    boolean isConstant = e.isConstant();
                    VarId outVarId = this.newVarId(opOutputs2.get(0), e.getFrameName(), 0, executedVar.toFrameIter());
                    if (isConstant && executedVar.getParentFrame() != null) {
                        outVarId.setParentFrame(outVarId.getParentFrame().clone());
                        for (FrameIter fi = outVarId.getParentFrame(); fi != null; fi = fi.getParentFrame()) {
                            fi.setIteration(0);
                        }
                    }
                    if (!this.nodeOutputs.containsKey(outVarId) && this.subgraph.contains(outVarId.getVariable()) && !this.availableForExecSet.contains(outVarId)) {
                        this.availableForExec.add(outVarId);
                        this.availableForExecSet.add(outVarId);
                        log.trace("Marked enter op ({}) variable {} as available for execution: input {} is now available", new Object[]{string, outVarId, executedVar});
                    }
                    this.frameParents.put(e.getFrameName(), executedVar.toFrameIter());
                    this.addToExecInputs(isConstOrPhInput, executedVar, outVarId);
                    continue;
                }
                if (fn instanceof Exit) {
                    opOutputs2 = this.sameDiff.getOps().get(string).getOutputsOfOp();
                    FrameIter parentFrame = this.frameParents.get(executedVar.getFrame());
                    Preconditions.checkNotNull((Object)parentFrame, (String)"Parent frame must not be null for exit op: variable to exec is %s", (Object)executedVar);
                    VarId outVarId = new VarId(opOutputs2.get(0), parentFrame.getFrame(), parentFrame.getIteration(), executedVar.getParentFrame().getParentFrame());
                    if (!this.nodeOutputs.containsKey(outVarId) && this.subgraph.contains(outVarId.getVariable()) && !this.availableForExecSet.contains(outVarId)) {
                        this.availableForExec.add(outVarId);
                        this.availableForExecSet.add(outVarId);
                        log.trace("Marked Exit op ({}) variable {} as available for execution: input {} is now available", new Object[]{string, outVarId, executedVar});
                    }
                    this.addToExecInputs(isConstOrPhInput, executedVar, outVarId);
                    continue;
                }
                if (fn instanceof NextIteration) {
                    opOutputs2 = this.sameDiff.getOps().get(string).getOutputsOfOp();
                    Preconditions.checkState((opOutputs2.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 output for NextIteration op: got %s", opOutputs2);
                    VarId outVarId = this.newVarId(opOutputs2.get(0), executedVar.getFrame(), executedVar.getIteration() + 1, executedVar.getParentFrame());
                    if (!this.nodeOutputs.containsKey(outVarId) && this.subgraph.contains(outVarId.getVariable()) && !this.availableForExecSet.contains(outVarId)) {
                        this.availableForExec.add(outVarId);
                        this.availableForExecSet.add(outVarId);
                        log.trace("Marked NextIteration op ({}) variable {} as available for execution: input {} is now available", new Object[]{string, outVarId, executedVar});
                    }
                    this.addToExecInputs(isConstOrPhInput, executedVar, outVarId);
                    continue;
                }
                Object[] inputsThisOp = fn.argNames();
                boolean allInputsAvailable = true;
                if (inputsThisOp != null) {
                    allInputsAvailable = this.allInputsAvailable(execStep, (String[])inputsThisOp, executedVar);
                }
                if ((opControlDeps = this.sameDiff.getOps().get(string).getControlDeps()) != null && allInputsAvailable) {
                    for (String cd : opControlDeps) {
                        VarId vcd = this.newVarId(cd, executedVar.getFrame(), executedVar.getIteration(), executedVar.getParentFrame());
                        if (this.nodeOutputs.containsKey(vcd)) continue;
                        allInputsAvailable = false;
                        break;
                    }
                }
                if ((opOutputs = this.sameDiff.getOps().get(string).getOutputsOfOp()) == null) continue;
                block3: for (String s : opOutputs) {
                    SDVariable sdv = this.sameDiff.getVariable(s);
                    Variable variable = this.sameDiff.getVariables().get(s);
                    VarId outVarId = sdv.isConstant() || sdv.isPlaceHolder() ? (variable.getControlDeps() == null || var.getControlDeps().isEmpty() ? this.newVarId(s, OUTER_FRAME, 0, null) : this.newVarId(s, executedVar.getFrame(), executedVar.getIteration(), executedVar.getParentFrame())) : this.newVarId(s, executedVar.getFrame(), executedVar.getIteration(), executedVar.getParentFrame());
                    this.addToExecInputs(isConstOrPhInput, executedVar, outVarId);
                    if (!allInputsAvailable || variable.getControlDeps() == null || variable.getControlDeps().isEmpty()) continue;
                    for (String cd : variable.getControlDeps()) {
                        Variable cdVar = this.sameDiff.getVariables().get(cd);
                        VarId cdVarId = null;
                        cdVarId = cdVar.getVariable().isConstant() || cdVar.getVariable().isPlaceHolder() ? (variable.getControlDeps() == null || var.getControlDeps().isEmpty() ? this.newVarId(cd, OUTER_FRAME, 0, null) : this.newVarId(cd, executedVar.getFrame(), executedVar.getIteration(), executedVar.getParentFrame())) : this.newVarId(cd, executedVar.getFrame(), executedVar.getIteration(), executedVar.getParentFrame());
                        if (allInputsAvailable &= this.nodeOutputs.containsKey(cdVarId)) continue;
                        continue block3;
                    }
                }
                if (!allInputsAvailable) continue;
                for (String s : opOutputs) {
                    if (!this.subgraph.contains(s) || this.availableForExecSet.contains(vid = this.newVarId(s, executedVar.getFrame(), executedVar.getIteration(), executedVar.getParentFrame()))) continue;
                    this.availableForExec.add(vid);
                    this.availableForExecSet.add(vid);
                    log.trace("Marked variable as available for execution: {} - output of op {} ({}) with op inputs {}", new Object[]{vid, string, fn.getClass().getSimpleName(), inputsThisOp == null ? "<none>" : Arrays.toString(inputsThisOp)});
                }
            }
        }
        if (controlDepForVars != null) {
            for (String s : controlDepForVars) {
                VarId outVarId;
                Iterator<String> inputList;
                if (!this.subgraph.contains(s)) continue;
                SDVariable depFor = this.sameDiff.getVariable(s);
                if (depFor.getVariableType() != VariableType.ARRAY) {
                    VarId varId = this.newVarId(s, executedVar.getFrame(), executedVar.getIteration(), executedVar.getParentFrame());
                    if (this.availableForExecSet.contains(varId)) continue;
                    this.availableForExec.add(varId);
                    this.availableForExecSet.add(varId);
                    log.trace("Marked variable as available for execution: {} - control dependency {} -> {} exists", new Object[]{varId, executedVar.getVariable(), s});
                    continue;
                }
                String string = this.sameDiff.getVariables().get(s).getOutputOfOp();
                if (string == null) continue;
                SameDiffOp op = this.sameDiff.getOps().get(string);
                boolean allInputsAvailable = true;
                if (op.getInputsToOp() != null && !op.getInputsToOp().isEmpty()) {
                    inputList = op.getInputsToOp();
                    allInputsAvailable = this.allInputsAvailable(execStep, inputList.toArray((String[])new String[inputList.size()]), executedVar);
                }
                if (allInputsAvailable && op.getControlDeps() != null) {
                    String cd;
                    VarId vid2;
                    inputList = op.getControlDeps().iterator();
                    while (inputList.hasNext() && (allInputsAvailable &= this.nodeOutputs.containsKey(vid2 = this.newVarId(cd = inputList.next(), executedVar.getFrame(), executedVar.getIteration(), executedVar.getParentFrame())))) {
                    }
                }
                if (allInputsAvailable) {
                    for (String opOutput : op.getOutputsOfOp()) {
                        String s2;
                        Variable v2 = this.sameDiff.getVariables().get(opOutput);
                        if (v2.getControlDeps() == null) continue;
                        Iterator<String> iterator = v2.getControlDeps().iterator();
                        while (iterator.hasNext() && (allInputsAvailable &= this.nodeOutputs.containsKey(vid = this.newVarId(s2 = iterator.next(), executedVar.getFrame(), executedVar.getIteration(), executedVar.getParentFrame())))) {
                        }
                    }
                }
                if (!allInputsAvailable || this.availableForExecSet.contains(outVarId = this.newVarId(s, executedVar.getFrame(), executedVar.getIteration(), executedVar.getParentFrame()))) continue;
                this.availableForExec.add(outVarId);
                log.trace("Marked variable as available for execution: {} - is output of op {} with no inputs (but has control dependencies)", (Object)outVarId, (Object)op.getName());
            }
        }
        if (controlDepForOps != null) {
            for (String opName : controlDepForOps) {
                SameDiffOp op = this.sameDiff.getOps().get(opName);
                if (op.getInputsToOp() != null && !op.getInputsToOp().isEmpty()) continue;
                for (String out : op.getOutputsOfOp()) {
                    VarId outVarId;
                    if (!this.subgraph.contains(out) || this.availableForExecSet.contains(outVarId = this.newVarId(out, OUTER_FRAME, 0, null))) continue;
                    this.availableForExec.add(outVarId);
                    this.availableForExecSet.add(outVarId);
                    log.trace("Marked variable as available for execution: {} - op control dependency variable {} -> op {} exists", new Object[]{outVarId, executedVar.getVariable(), opName});
                }
            }
        }
    }

    protected boolean allInputsAvailable(int execStep, String[] inputsThisOp, VarId executedVar) {
        for (String in : inputsThisOp) {
            VarId vid;
            SDVariable sdv = this.sameDiff.getVariable(in);
            Variable variable = this.sameDiff.getVariables().get(in);
            boolean nestedWhile = false;
            if (sdv.isConstant() || sdv.isPlaceHolder()) {
                vid = variable.getControlDeps() == null || variable.getControlDeps().isEmpty() ? this.newVarId(in, OUTER_FRAME, 0, null) : this.newVarId(in, executedVar.getFrame(), executedVar.getIteration(), executedVar.getParentFrame());
            } else {
                int iter = executedVar.getIteration();
                FrameIter parentFrame = executedVar.getParentFrame();
                if (sdv.getVariableType() == VariableType.ARRAY && this.sameDiff.getOps().get(variable.getOutputOfOp()).getOp() instanceof Enter) {
                    iter = 0;
                    Enter e = (Enter)this.sameDiff.getOps().get(variable.getOutputOfOp()).getOp();
                    if (e.isConstant()) {
                        for (FrameIter toZero = parentFrame = parentFrame.clone(); toZero != null; toZero = toZero.getParentFrame()) {
                            toZero.setIteration(0);
                        }
                    }
                }
                vid = this.newVarId(in, executedVar.getFrame(), iter, parentFrame);
            }
            if (this.nodeOutputs.containsKey(vid)) continue;
            return false;
        }
        return true;
    }

    protected Map<String, T> preprocessPlaceholders(Map<String, T> placeholders) {
        return placeholders;
    }

    public abstract T getConstantOrVariable(String var1);

    public abstract O getAndParameterizeOp(String var1, FrameIter var2, Set<VarId> var3, Set<VarId> var4, Set<String> var5, Map<String, T> var6);

    public abstract T[] getOutputs(O var1, FrameIter var2, Set<VarId> var3, Set<VarId> var4, Set<String> var5, List<Listener> var6, At var7, MultiDataSet var8);

    protected void addToExecInputs(boolean isConstOrPh, VarId inputVar, VarId forVariable) {
        if (!this.subgraph.contains(forVariable.getVariable())) {
            return;
        }
        if (isConstOrPh) {
            if (!this.execConstInputs.containsKey(forVariable.getVariable())) {
                this.execConstInputs.put(forVariable.getVariable(), new HashSet());
            }
            this.execConstInputs.get(forVariable.getVariable()).add(inputVar.getVariable());
        } else {
            Variable v = this.sameDiff.getVariables().get(inputVar.getVariable());
            boolean isEnter = this.sameDiff.getVariableOutputOp(v.getVariable().getVarName()) instanceof Enter;
            if (isEnter) {
                VarId iter0 = forVariable;
                if (iter0.getIteration() != 0) {
                    iter0 = this.newVarId(iter0.getVariable(), iter0.getFrame(), 0, forVariable.getParentFrame());
                }
                Variable var = this.sameDiff.getVariables().get(inputVar.getVariable());
                Enter e = (Enter)this.sameDiff.getOps().get(var.getOutputOfOp()).getOp();
                if (e.isConstant()) {
                    iter0.setParentFrame(iter0.getParentFrame().clone());
                    for (FrameIter toZero = iter0.getParentFrame(); toZero != null; toZero = toZero.getParentFrame()) {
                        toZero.setIteration(0);
                    }
                }
                if (!this.execInputsAllIter.containsKey(iter0)) {
                    this.execInputsAllIter.put(iter0, new HashSet());
                }
                this.execInputsAllIter.get(iter0).add(inputVar);
            } else {
                if (!this.execInputs.containsKey(forVariable)) {
                    this.execInputs.put(forVariable, new HashSet());
                }
                this.execInputs.get(forVariable).add(inputVar);
            }
        }
    }

    protected static VarId lookup(String name, Collection<VarId> varIds, boolean exceptionOnNotFound) {
        for (VarId vid : varIds) {
            if (!vid.getVariable().equals(name)) continue;
            return vid;
        }
        if (exceptionOnNotFound) {
            throw new RuntimeException("Could not find VarId to input " + name);
        }
        return null;
    }

    public Map<VarId, T> getNodeOutputs() {
        return this.nodeOutputs;
    }

    public Map<VarId, List<T>> getTensorArrays() {
        return this.tensorArrays;
    }

    public Map<String, FrameIter> getFrameParents() {
        return this.frameParents;
    }

    public static class FrameIter {
        private String frame;
        private int iteration;
        private FrameIter parentFrame;

        public String toString() {
            return "(\"" + this.frame + "\"," + this.iteration + (this.parentFrame == null ? "" : ",parent=" + this.parentFrame.toString()) + ")";
        }

        public FrameIter clone() {
            return new FrameIter(this.frame, this.iteration, this.parentFrame == null ? null : this.parentFrame.clone());
        }

        public String getFrame() {
            return this.frame;
        }

        public int getIteration() {
            return this.iteration;
        }

        public FrameIter getParentFrame() {
            return this.parentFrame;
        }

        public void setFrame(String frame) {
            this.frame = frame;
        }

        public void setIteration(int iteration) {
            this.iteration = iteration;
        }

        public void setParentFrame(FrameIter parentFrame) {
            this.parentFrame = parentFrame;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FrameIter)) {
                return false;
            }
            FrameIter other = (FrameIter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$frame = this.getFrame();
            String other$frame = other.getFrame();
            if (this$frame == null ? other$frame != null : !this$frame.equals(other$frame)) {
                return false;
            }
            if (this.getIteration() != other.getIteration()) {
                return false;
            }
            FrameIter this$parentFrame = this.getParentFrame();
            FrameIter other$parentFrame = other.getParentFrame();
            return !(this$parentFrame == null ? other$parentFrame != null : !((Object)this$parentFrame).equals(other$parentFrame));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FrameIter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $frame = this.getFrame();
            result = result * 59 + ($frame == null ? 43 : $frame.hashCode());
            result = result * 59 + this.getIteration();
            FrameIter $parentFrame = this.getParentFrame();
            result = result * 59 + ($parentFrame == null ? 43 : ((Object)$parentFrame).hashCode());
            return result;
        }

        public FrameIter(String frame, int iteration, FrameIter parentFrame) {
            this.frame = frame;
            this.iteration = iteration;
            this.parentFrame = parentFrame;
        }
    }

    public static class VarId {
        private String variable;
        private String frame;
        private int iteration;
        private FrameIter parentFrame;

        public String toString() {
            return "VarId(\"" + this.variable + "\",\"" + this.frame + "\"," + this.iteration + ",parent=" + this.parentFrame + ")";
        }

        public FrameIter toFrameIter() {
            return new FrameIter(this.frame, this.iteration, this.parentFrame);
        }

        public String getVariable() {
            return this.variable;
        }

        public String getFrame() {
            return this.frame;
        }

        public int getIteration() {
            return this.iteration;
        }

        public FrameIter getParentFrame() {
            return this.parentFrame;
        }

        public void setVariable(String variable) {
            this.variable = variable;
        }

        public void setFrame(String frame) {
            this.frame = frame;
        }

        public void setIteration(int iteration) {
            this.iteration = iteration;
        }

        public void setParentFrame(FrameIter parentFrame) {
            this.parentFrame = parentFrame;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VarId)) {
                return false;
            }
            VarId other = (VarId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$variable = this.getVariable();
            String other$variable = other.getVariable();
            if (this$variable == null ? other$variable != null : !this$variable.equals(other$variable)) {
                return false;
            }
            String this$frame = this.getFrame();
            String other$frame = other.getFrame();
            if (this$frame == null ? other$frame != null : !this$frame.equals(other$frame)) {
                return false;
            }
            if (this.getIteration() != other.getIteration()) {
                return false;
            }
            FrameIter this$parentFrame = this.getParentFrame();
            FrameIter other$parentFrame = other.getParentFrame();
            return !(this$parentFrame == null ? other$parentFrame != null : !((Object)this$parentFrame).equals(other$parentFrame));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VarId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $variable = this.getVariable();
            result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
            String $frame = this.getFrame();
            result = result * 59 + ($frame == null ? 43 : $frame.hashCode());
            result = result * 59 + this.getIteration();
            FrameIter $parentFrame = this.getParentFrame();
            result = result * 59 + ($parentFrame == null ? 43 : ((Object)$parentFrame).hashCode());
            return result;
        }

        public VarId(String variable, String frame, int iteration, FrameIter parentFrame) {
            this.variable = variable;
            this.frame = frame;
            this.iteration = iteration;
            this.parentFrame = parentFrame;
        }
    }
}

