/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDIndex;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.VariableType;
import org.nd4j.autodiff.samediff.internal.Variable;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.weightinit.WeightInitScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDVariable
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SDVariable.class);
    protected SameDiff sameDiff;
    protected String varName;
    protected VariableType variableType;
    protected WeightInitScheme weightInitScheme;
    protected long[] shape;
    protected DataType dataType;
    private DifferentialFunction creator;

    public SDVariable(@NonNull String varName, @NonNull VariableType varType, @NonNull SameDiff sameDiff, long[] shape, DataType dataType, WeightInitScheme weightInitScheme) {
        if (varName == null) {
            throw new NullPointerException("varName is marked @NonNull but is null");
        }
        if (varType == null) {
            throw new NullPointerException("varType is marked @NonNull but is null");
        }
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked @NonNull but is null");
        }
        Preconditions.checkState((weightInitScheme == null || varType == VariableType.VARIABLE ? 1 : 0) != 0, (String)"Weight initalization schemes can only be applied to VARIABLE type SDVariables - variable \"%s\" is of type %s but was provided a weight initialization scheme %s", (Object)varName, (Object)((Object)varType), (Object)weightInitScheme);
        Preconditions.checkState((dataType != DataType.UNKNOWN ? 1 : 0) != 0, (String)"Unknown datatype is not allowed for SDVariables (variable name: %s)", (Object)varName);
        varName = sameDiff.generateNewVarName(varName, 0, true);
        this.sameDiff = sameDiff;
        this.varName = varName;
        this.variableType = varType;
        this.dataType = dataType;
        this.weightInitScheme = weightInitScheme;
        this.shape = shape;
    }

    public boolean isPlaceHolder() {
        return this.variableType == VariableType.PLACEHOLDER;
    }

    public boolean isConstant() {
        return this.variableType == VariableType.CONSTANT;
    }

    public INDArray storeAndAllocateNewArray() {
        Preconditions.checkState((this.variableType == VariableType.VARIABLE ? 1 : 0) != 0, (String)"Unable to allocate and store array for variable of type %s: only VARIABLE type variables can be initialized using this method", (Object)((Object)this.variableType));
        if (!this.sameDiff.arrayAlreadyExistsForVarName(this.varName)) {
            long[] shape = this.getShape();
            INDArray arr = this.getWeightInitScheme().create(this.dataType(), shape);
            this.sameDiff.associateArrayWithVariable(arr, this);
            if (log.isTraceEnabled()) {
                log.trace("Generated and stored new array for variable \"{}\": shape {}", (Object)this.getVarName(), (Object)Arrays.toString(arr.shape()));
            }
            return arr;
        }
        INDArray ret = this.getArr();
        return ret;
    }

    public INDArray getArr() {
        return this.getArr(false);
    }

    public INDArray getArr(boolean enforceExistence) {
        if (this.sameDiff.arrayAlreadyExistsForVarName(this.getVarName())) {
            return this.sameDiff.getArrForVarName(this.getVarName());
        }
        if (this.variableType == VariableType.VARIABLE && this.weightInitScheme != null && this.shape != null) {
            INDArray arr = this.weightInitScheme.create(this.dataType, this.shape);
            this.sameDiff.associateArrayWithVariable(arr, this);
            if (log.isTraceEnabled()) {
                log.trace("getArr() for variable \"{}\" allocated new array: shape {}", (Object)this.getVarName(), (Object)Arrays.toString(this.getShape()));
            }
            return arr;
        }
        if (this.sameDiff.getShapeForVarName(this.getVarName()) == null) {
            if (enforceExistence) {
                throw new IllegalStateException("Cannot get array for SDVariable \"" + this.getVarName() + "\": no array has been defined, and array shape cannot be calculated");
            }
            if (log.isTraceEnabled()) {
                log.trace("SDVariable.getArr(): could not get array for variable {}: shape is null", (Object)this.getVarName());
            }
            return null;
        }
        return this.sameDiff.getArrForVarName(this.getVarName());
    }

    public SDVariable gradient() {
        return this.getGradient();
    }

    public SDVariable getGradient() {
        Preconditions.checkState((boolean)this.dataType().isFPType(), (String)"Cannot get gradient of %s variable \"%s\": only floating point variables have gradients", (Object)this.getVarName(), (Object)this.dataType());
        return this.sameDiff.getGradForVariable(this.getVarName());
    }

    public long[] getShape() {
        INDArray arr;
        if (this.variableType == VariableType.PLACEHOLDER && this.getArr() == null) {
            if (this.shape != null) {
                return this.shape;
            }
            return new long[0];
        }
        long[] initialShape = this.sameDiff.getShapeForVarName(this.getVarName());
        if (initialShape == null && (arr = this.getArr()) != null) {
            return arr.shape();
        }
        return initialShape;
    }

    public long[] placeholderShape() {
        if (this.variableType != VariableType.PLACEHOLDER) {
            throw new IllegalStateException("placeholderShape() can only be used for placeholder variables: variable \"" + this.getVarName() + " is a variable of type " + (Object)((Object)this.variableType));
        }
        return this.shape;
    }

    public DataType dataType() {
        if (this.dataType == null && this.getArr() != null) {
            this.dataType = this.getArr().dataType();
        }
        return this.dataType;
    }

    public LongShapeDescriptor getShapeDescriptor() {
        return LongShapeDescriptor.fromShape(this.getShape(), this.dataType());
    }

    public SDVariable castTo(@NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked @NonNull but is null");
        }
        return this.castTo(null, dataType);
    }

    public SDVariable castTo(String name, @NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked @NonNull but is null");
        }
        return this.sameDiff.castTo(name, this, dataType);
    }

    public SDVariable dup() {
        return this.sameDiff.var(this);
    }

    public SDVariable assign(Number value) {
        return this.sameDiff.scalarSet(this, value);
    }

    public SDVariable neg() {
        return this.sameDiff.f().neg(this);
    }

    public SDVariable neg(String name) {
        return this.sameDiff.math().neg(name, this);
    }

    public SDVariable lt(double value) {
        return this.lt(null, value);
    }

    public SDVariable lt(String name, double value) {
        return this.sameDiff.lt(name, this, value);
    }

    public SDVariable lte(double value) {
        return this.lte(null, value);
    }

    public SDVariable lte(String name, double value) {
        return this.sameDiff.lte(name, this, value);
    }

    public SDVariable gt(double value) {
        return this.gt(null, value);
    }

    public SDVariable gt(String name, double value) {
        return this.sameDiff.gt(name, this, value);
    }

    public SDVariable gte(double value) {
        return this.gte(null, value);
    }

    public SDVariable gte(String name, double value) {
        return this.sameDiff.gte(name, this, value);
    }

    public SDVariable eq(double value) {
        return this.eq(null, value);
    }

    public SDVariable eq(String name, double value) {
        return this.sameDiff.eq(name, this, value);
    }

    public SDVariable neq(double value) {
        return this.neq(null, value);
    }

    public SDVariable neq(String name, double value) {
        return this.sameDiff.neq(name, this, value);
    }

    public SDVariable lt(SDVariable other) {
        return this.lt(null, other);
    }

    public SDVariable lt(String name, SDVariable other) {
        return this.sameDiff.lt(name, this, other);
    }

    public SDVariable lte(SDVariable other) {
        return this.lte(null, other);
    }

    public SDVariable lte(String name, SDVariable other) {
        return this.sameDiff.lte(name, this, other);
    }

    public SDVariable gt(SDVariable other) {
        return this.gt(null, other);
    }

    public SDVariable gt(String name, SDVariable other) {
        return this.sameDiff.gt(name, this, other);
    }

    public SDVariable gte(SDVariable other) {
        return this.gte(null, other);
    }

    public SDVariable gte(String name, SDVariable other) {
        return this.sameDiff.gte(name, this, other);
    }

    public SDVariable eq(SDVariable other) {
        return this.eq(null, other);
    }

    public SDVariable eq(String name, SDVariable other) {
        return this.sameDiff.eq(name, this, other);
    }

    public SDVariable neq(SDVariable other) {
        return this.neq(null, other);
    }

    public SDVariable neq(String name, SDVariable other) {
        return this.sameDiff.neq(name, this, other);
    }

    public SDVariable mmul(SDVariable other) {
        return this.mmul(null, other);
    }

    public SDVariable mmul(String name, SDVariable other) {
        return this.sameDiff.mmul(name, this, other);
    }

    public SDVariable mmul(String name, SDVariable other, @NonNull MMulTranspose mMulTranspose) {
        if (mMulTranspose == null) {
            throw new NullPointerException("mMulTranspose is marked @NonNull but is null");
        }
        return this.sameDiff.mmul(name, this, other, mMulTranspose);
    }

    public SDVariable dot(SDVariable other, int ... dimensions) {
        return this.dot(null, other, dimensions);
    }

    public SDVariable dot(String name, SDVariable other, int ... dimensions) {
        return this.sameDiff.dot(name, this, other, dimensions);
    }

    public SDVariable add(double scalar) {
        return this.add(null, scalar);
    }

    public SDVariable add(String varName, double scalar) {
        SDVariable function = this.sameDiff.f().add(this, scalar);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable add(SDVariable other) {
        return this.add(null, other);
    }

    public SDVariable add(String name, SDVariable x) {
        SDVariable result = this.sameDiff.f().add(this, x);
        return this.sameDiff.updateVariableNameAndReference(result, name);
    }

    public SDVariable plus(SDVariable other) {
        return this.add(other);
    }

    public SDVariable plus(double other) {
        return this.add(other);
    }

    public SDVariable sub(double scalar) {
        return this.sub(null, scalar);
    }

    public SDVariable sub(String varName, double scalar) {
        SDVariable result = this.sameDiff.f().sub(this, scalar);
        return this.sameDiff.updateVariableNameAndReference(result, varName);
    }

    public SDVariable sub(SDVariable x) {
        return this.sub(null, x);
    }

    public SDVariable sub(String name, SDVariable x) {
        SDVariable result = this.sameDiff.f().sub(this, x);
        return this.sameDiff.updateVariableNameAndReference(result, name);
    }

    public SDVariable minus(SDVariable other) {
        return this.sub(other);
    }

    public SDVariable minus(double other) {
        return this.sub(other);
    }

    public SDVariable div(double scalar) {
        return this.div(null, scalar);
    }

    public SDVariable div(String varName, double scalar) {
        SDVariable function = this.sameDiff.f().div(this, scalar);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable div(SDVariable x) {
        return this.div(null, x);
    }

    public SDVariable div(String name, SDVariable x) {
        SDVariable result = this.sameDiff.f().div(this, x);
        return this.sameDiff.updateVariableNameAndReference(result, name);
    }

    public SDVariable fdiv(String name, SDVariable x) {
        SDVariable result = this.sameDiff.f().floorDiv(this, x);
        return this.sameDiff.updateVariableNameAndReference(result, name);
    }

    public SDVariable mod(String name, SDVariable x) {
        SDVariable result = this.sameDiff.f().mod(this, x);
        return this.sameDiff.updateVariableNameAndReference(result, name);
    }

    public SDVariable mul(double scalar) {
        return this.mul(null, scalar);
    }

    public SDVariable mul(String varName, double scalar) {
        SDVariable function = this.sameDiff.f().mul(this, scalar);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable mul(SDVariable x) {
        return this.mul(null, x);
    }

    public SDVariable mul(String name, SDVariable x) {
        SDVariable result = this.sameDiff.f().mul(this, x);
        return this.sameDiff.updateVariableNameAndReference(result, name);
    }

    public SDVariable times(SDVariable other) {
        return this.mul(other);
    }

    public SDVariable times(double other) {
        return this.mul(other);
    }

    public SDVariable pow(double scalar) {
        return this.pow(null, scalar);
    }

    public SDVariable pow(String varName, double scalar) {
        SDVariable ret = this.sameDiff.f().pow(this, scalar);
        return this.sameDiff.updateVariableNameAndReference(ret, varName);
    }

    public SDVariable rsub(double scalar) {
        return this.rsub(null, scalar);
    }

    public SDVariable rsub(String varName, double scalar) {
        SDVariable function = this.sameDiff.f().rsub(this, scalar);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable rsub(SDVariable x) {
        return this.rsub(null, x);
    }

    public SDVariable rsub(String name, SDVariable x) {
        SDVariable result = this.sameDiff.f().rsub(this, x);
        return this.sameDiff.updateVariableNameAndReference(result, name);
    }

    public SDVariable rdiv(double scalar) {
        return this.rdiv(null, scalar);
    }

    public SDVariable rdiv(String varName, double scalar) {
        SDVariable function = this.sameDiff.f().rdiv(this, scalar);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable rdiv(SDVariable sameDiffVariable) {
        return this.rdiv(null, sameDiffVariable);
    }

    public SDVariable rdiv(String name, SDVariable x) {
        SDVariable result = this.sameDiff.f().rdiv(this, x);
        return this.sameDiff.updateVariableNameAndReference(result, name);
    }

    public SDVariable truncatedDiv(SDVariable sameDiffVariable) {
        return this.truncatedDiv(null, sameDiffVariable);
    }

    public SDVariable truncatedDiv(String varName, SDVariable sameDiffVariable) {
        SDVariable function = this.sameDiff.f().truncatedDiv(this, sameDiffVariable);
        return this.sameDiff.updateVariableNameAndReference(function, varName);
    }

    public SDVariable squaredDifference(SDVariable x) {
        return this.squaredDifference(null, x);
    }

    public SDVariable squaredDifference(String name, SDVariable x) {
        SDVariable result = this.sameDiff.f().squaredDifference(this, x);
        return this.sameDiff.updateVariableNameAndReference(result, name);
    }

    public SDVariable sum(int ... dimensions) {
        return this.sum(null, dimensions);
    }

    public SDVariable sum(boolean keepDims, int ... dimensions) {
        return this.sum(null, keepDims, dimensions);
    }

    public SDVariable sum(String name, int ... dimensions) {
        return this.sum(name, false, dimensions);
    }

    public SDVariable sum(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.sum(name, this, keepDims, dimensions);
    }

    public SDVariable mean(boolean keepDims, int ... dimensions) {
        return this.mean(null, keepDims, dimensions);
    }

    public SDVariable mean(String name, int ... dimensions) {
        return this.mean(name, false, dimensions);
    }

    public SDVariable mean(int ... dimensions) {
        return this.mean(null, false, dimensions);
    }

    public SDVariable mean(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.mean(name, this, keepDims, dimensions);
    }

    public SDVariable std(boolean biasCorrected, int ... dimensions) {
        return this.std(null, biasCorrected, dimensions);
    }

    public SDVariable std(String name, boolean biasCorrected, int ... dimensions) {
        return this.sameDiff.standardDeviation(name, this, biasCorrected, dimensions);
    }

    public SDVariable std(String name, boolean biasCorrected, boolean keepDims, int ... dimensions) {
        return this.sameDiff.standardDeviation(name, this, biasCorrected, keepDims, dimensions);
    }

    public SDVariable prod(int ... dimensions) {
        return this.prod(null, dimensions);
    }

    public SDVariable prod(boolean keepDims, int ... dimensions) {
        return this.prod(null, keepDims, dimensions);
    }

    public SDVariable prod(String name, int ... dimensions) {
        return this.sameDiff.prod(name, this, dimensions);
    }

    public SDVariable prod(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.prod(name, this, keepDims, dimensions);
    }

    public SDVariable min(int ... dimensions) {
        return this.min(null, dimensions);
    }

    public SDVariable min(boolean keepDims, int ... dimensions) {
        return this.min(null, keepDims, dimensions);
    }

    public SDVariable min(String name, int ... dimensions) {
        return this.min(name, false, dimensions);
    }

    public SDVariable min(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.min(name, this, keepDims, dimensions);
    }

    public SDVariable max(int ... dimensions) {
        return this.max(null, dimensions);
    }

    public SDVariable max(String name, int ... dimensions) {
        return this.max(name, false, dimensions);
    }

    public SDVariable max(boolean keepDims, int ... dimensions) {
        return this.max(null, keepDims, dimensions);
    }

    public SDVariable max(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.max(name, this, keepDims, dimensions);
    }

    public SDVariable norm1(int ... dimensions) {
        return this.norm1(null, dimensions);
    }

    public SDVariable norm1(boolean keepDims, int ... dimensions) {
        return this.norm1(null, keepDims, dimensions);
    }

    public SDVariable norm1(String name, int ... dimensions) {
        return this.norm1(name, false, dimensions);
    }

    public SDVariable norm1(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.norm1(name, this, keepDims, dimensions);
    }

    public SDVariable norm2(int ... dimensions) {
        return this.norm2(null, dimensions);
    }

    public SDVariable norm2(boolean keepDims, int ... dimensions) {
        return this.norm2(null, keepDims, dimensions);
    }

    public SDVariable norm2(String name, int ... dimensions) {
        return this.norm2(name, false, dimensions);
    }

    public SDVariable norm2(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.norm2(name, this, keepDims, dimensions);
    }

    public SDVariable normmax(int ... dimensions) {
        return this.normmax(null, dimensions);
    }

    public SDVariable normmax(boolean keepDims, int ... dimensions) {
        return this.normmax(null, keepDims, dimensions);
    }

    public SDVariable normmax(String name, int ... dimensions) {
        return this.normmax(name, false, dimensions);
    }

    public SDVariable normmax(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.normmax(name, this, keepDims, dimensions);
    }

    public SDVariable argmax(int ... dimensions) {
        return this.argmax(null, dimensions);
    }

    public SDVariable argmax(String name, int ... dimensions) {
        return this.sameDiff.argmax(name, this, dimensions);
    }

    public SDVariable argmax(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.argmax(name, this, keepDims, dimensions);
    }

    public SDVariable argmin(int ... dimensions) {
        return this.argmin(null, dimensions);
    }

    public SDVariable argmin(String name, int ... dimensions) {
        return this.sameDiff.argmin(name, this, dimensions);
    }

    public SDVariable argmin(String name, boolean keepDims, int ... dimensions) {
        return this.sameDiff.argmax(name, this, keepDims, dimensions);
    }

    public SDVariable shape() {
        return this.sameDiff.shape(this);
    }

    public SDVariable rank() {
        return this.sameDiff.rank(this);
    }

    public SDVariable reshape(SDVariable newShape) {
        return this.sameDiff.reshape(this, newShape);
    }

    public SDVariable reshape(int ... newShape) {
        return this.sameDiff.reshape(this, newShape);
    }

    public SDVariable reshape(long ... newShape) {
        return this.sameDiff.reshape(this, newShape);
    }

    public SDVariable permute(int ... dimensions) {
        return this.sameDiff.permute(this, dimensions);
    }

    public SDVariable permute(SDVariable dimensions) {
        return this.sameDiff.permute(null, this, dimensions);
    }

    public SDVariable setArray(INDArray array) {
        this.sameDiff.associateArrayWithVariable(array, this);
        return this;
    }

    public INDArray eval() {
        this.sameDiff.exec(null, this.getVarName());
        return this.getArr();
    }

    public INDArray eval(Map<String, INDArray> placeholders) {
        this.sameDiff.exec(placeholders, this.getVarName());
        return this.getArr();
    }

    public String toString() {
        return "SDVariable(name=\"" + this.varName + "\",variableType=" + (Object)((Object)this.variableType) + ",dtype=" + this.dataType + (this.variableType == VariableType.PLACEHOLDER && this.shape != null ? ",shape=" + Arrays.toString(this.shape) : "") + ")";
    }

    public void addControlDependency(SDVariable controlDependency) {
        Variable v2;
        String cdN = controlDependency.getVarName();
        String n = this.getVarName();
        Variable v = this.sameDiff.getVariables().get(n);
        if (v.getControlDeps() == null) {
            v.setControlDeps(new ArrayList<String>());
        }
        if (!v.getControlDeps().contains(cdN)) {
            v.getControlDeps().add(cdN);
        }
        if ((v2 = this.sameDiff.getVariables().get(cdN)).getControlDepsForVar() == null) {
            v2.setControlDepsForVar(new ArrayList<String>());
        }
        if (!v2.getControlDepsForVar().contains(n)) {
            v2.getControlDepsForVar().add(n);
        }
    }

    public SDVariable get(SDIndex ... indices) {
        int ndims = indices.length;
        long[] begin = new long[ndims];
        long[] end = new long[ndims];
        long[] strides = new long[ndims];
        int[] begin_mask_arr = new int[ndims];
        int[] end_mask_arr = new int[ndims];
        int[] shrink_axis_mask_arr = new int[ndims];
        for (int i = 0; i < ndims; ++i) {
            strides[i] = 1L;
            SDIndex index = indices[i];
            SDIndex.IndexType indexType = index.getIndexType();
            if (indexType == SDIndex.IndexType.ALL) {
                begin_mask_arr[i] = 1;
                end_mask_arr[i] = 1;
                continue;
            }
            if (indexType == SDIndex.IndexType.POINT) {
                long pointIndex;
                begin[i] = pointIndex = index.getPointIndex();
                end[i] = pointIndex + 1L;
                if (index.isPointKeepDim()) continue;
                shrink_axis_mask_arr[i] = 1;
                continue;
            }
            if (indexType != SDIndex.IndexType.INTERVAL) continue;
            if (index.getIntervalBegin() == null) {
                begin_mask_arr[i] = 1;
            } else {
                begin[i] = index.getIntervalBegin();
            }
            if (index.getIntervalEnd() == null) {
                end_mask_arr[i] = 1;
            } else {
                end[i] = index.getIntervalEnd();
            }
            strides[i] = index.getIntervalStrides() == null ? 1L : index.getIntervalStrides();
        }
        int begin_mask = SDVariable.binArrToInt(begin_mask_arr);
        int end_mask = SDVariable.binArrToInt(end_mask_arr);
        int shrink_axis = SDVariable.binArrToInt(shrink_axis_mask_arr);
        return this.sameDiff.stridedSlice(this, begin, end, strides, begin_mask, end_mask, 0, 0, shrink_axis);
    }

    public SDVariable convertToConstant() {
        return this.sameDiff.convertToConstant(this);
    }

    public SDVariable convertToVariable() {
        return this.sameDiff.convertToVariable(this);
    }

    public SDVariable rename(String newName) {
        this.sameDiff.renameVariable(this.getVarName(), newName);
        return this;
    }

    public void markAsLoss() {
        this.sameDiff.addLossVariable(this.getVarName());
    }

    public boolean hasGradient() {
        return this.sameDiff.variableHasGradient(this.getVarName());
    }

    private static int binArrToInt(int[] arr) {
        int x = 0;
        int m = 1;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == 1) {
                x += m;
            }
            m *= 2;
        }
        return x;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SDVariable)) {
            return false;
        }
        SDVariable that = (SDVariable)o;
        if (!Objects.equals(this.varName, that.varName)) {
            return false;
        }
        if (this.variableType != that.variableType) {
            return false;
        }
        if (this.sameDiff != that.sameDiff) {
            return false;
        }
        return this.dataType == that.dataType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.varName != null ? this.varName.hashCode() : 0);
        result = 31 * result + (this.variableType != null ? this.variableType.hashCode() : 0);
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        return result;
    }

    public SDVariable clone(SameDiff sd) {
        SDVariable v = new SDVariable();
        v.varName = this.varName;
        v.variableType = this.variableType;
        v.weightInitScheme = this.weightInitScheme;
        v.shape = this.shape == null ? null : (long[])this.shape.clone();
        v.dataType = this.dataType;
        v.sameDiff = sd;
        return v;
    }

    public SameDiff getSameDiff() {
        return this.sameDiff;
    }

    public DifferentialFunction getCreator() {
        return this.creator;
    }

    public void setSameDiff(SameDiff sameDiff) {
        this.sameDiff = sameDiff;
    }

    public void setShape(long[] shape) {
        this.shape = shape;
    }

    public void setCreator(DifferentialFunction creator) {
        this.creator = creator;
    }

    public SDVariable() {
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    public WeightInitScheme getWeightInitScheme() {
        return this.weightInitScheme;
    }

    public void setWeightInitScheme(WeightInitScheme weightInitScheme) {
        this.weightInitScheme = weightInitScheme;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }
}

