/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.listeners.records;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.listeners.records.EvaluationRecord;
import org.nd4j.autodiff.listeners.records.LossCurve;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.evaluation.IEvaluation;
import org.nd4j.evaluation.IMetric;

public class History {
    private List<EvaluationRecord> trainingHistory;
    private List<EvaluationRecord> validationHistory;
    private LossCurve lossCurve;
    private long trainingTimeMillis;
    private List<Long> validationTimesMillis;

    public History(List<EvaluationRecord> training, List<EvaluationRecord> validation, LossCurve loss, long trainingTimeMillis, List<Long> validationTimesMillis) {
        this.trainingHistory = Collections.unmodifiableList(training);
        this.validationHistory = Collections.unmodifiableList(validation);
        this.lossCurve = loss;
        this.trainingTimeMillis = trainingTimeMillis;
        this.validationTimesMillis = Collections.unmodifiableList(validationTimesMillis);
    }

    public List<EvaluationRecord> trainingEval() {
        return this.trainingHistory;
    }

    public List<EvaluationRecord> validationEval() {
        return this.validationHistory;
    }

    public LossCurve lossCurve() {
        return this.lossCurve;
    }

    public long trainingTimeMillis() {
        return this.trainingTimeMillis;
    }

    public List<Long> validationTimesMillis() {
        return this.validationTimesMillis;
    }

    public int trainingEpochs() {
        return this.trainingHistory.size();
    }

    public int validationEpochs() {
        return this.validationHistory.size();
    }

    public List<Double> trainingEval(String param, IMetric metric) {
        ArrayList<Double> data = new ArrayList<Double>();
        for (EvaluationRecord er : this.trainingHistory) {
            data.add(er.getValue(param, metric));
        }
        return data;
    }

    public List<Double> trainingEval(SDVariable param, IMetric metric) {
        return this.trainingEval(param.getVarName(), metric);
    }

    public List<Double> trainingEval(String param, int index, IMetric metric) {
        ArrayList<Double> data = new ArrayList<Double>();
        for (EvaluationRecord er : this.trainingHistory) {
            data.add(er.getValue(param, index, metric));
        }
        return data;
    }

    public List<Double> trainingEval(SDVariable param, int index, IMetric metric) {
        return this.trainingEval(param.getVarName(), index, metric);
    }

    public List<Double> trainingEval(IMetric metric) {
        ArrayList<Double> data = new ArrayList<Double>();
        for (EvaluationRecord er : this.trainingHistory) {
            data.add(er.getValue(metric));
        }
        return data;
    }

    public List<IEvaluation> trainingEval(String param) {
        ArrayList<IEvaluation> data = new ArrayList<IEvaluation>();
        for (EvaluationRecord er : this.trainingHistory) {
            data.add((IEvaluation)er.evaluation(param));
        }
        return data;
    }

    public List<IEvaluation> trainingEval(SDVariable param) {
        return this.trainingEval(param.getVarName());
    }

    public List<IEvaluation> trainingEval(String param, int index) {
        ArrayList<IEvaluation> data = new ArrayList<IEvaluation>();
        for (EvaluationRecord er : this.trainingHistory) {
            data.add(er.evaluation(param, index));
        }
        return data;
    }

    public List<IEvaluation> trainingEval(SDVariable param, int index) {
        return this.trainingEval(param.getVarName(), index);
    }

    public List<Double> validationEval(String param, IMetric metric) {
        ArrayList<Double> data = new ArrayList<Double>();
        for (EvaluationRecord er : this.validationHistory) {
            data.add(er.getValue(param, metric));
        }
        return data;
    }

    public List<Double> validationEval(SDVariable param, IMetric metric) {
        return this.validationEval(param.getVarName(), metric);
    }

    public List<Double> validationEval(String param, int index, IMetric metric) {
        ArrayList<Double> data = new ArrayList<Double>();
        for (EvaluationRecord er : this.validationHistory) {
            data.add(er.getValue(param, index, metric));
        }
        return data;
    }

    public List<Double> validationEval(SDVariable param, int index, IMetric metric) {
        return this.validationEval(param.getVarName(), index, metric);
    }

    public List<Double> validationEval(IMetric metric) {
        ArrayList<Double> data = new ArrayList<Double>();
        for (EvaluationRecord er : this.validationHistory) {
            data.add(er.getValue(metric));
        }
        return data;
    }

    public List<IEvaluation> validationEval(String param) {
        ArrayList<IEvaluation> data = new ArrayList<IEvaluation>();
        for (EvaluationRecord er : this.validationHistory) {
            data.add((IEvaluation)er.evaluation(param));
        }
        return data;
    }

    public List<IEvaluation> validationEval(SDVariable param) {
        return this.validationEval(param.getVarName());
    }

    public List<IEvaluation> validationEval(String param, int index) {
        ArrayList<IEvaluation> data = new ArrayList<IEvaluation>();
        for (EvaluationRecord er : this.validationHistory) {
            data.add(er.evaluation(param, index));
        }
        return data;
    }

    public List<IEvaluation> validationEval(SDVariable param, int index) {
        return this.validationEval(param.getVarName(), index);
    }

    public EvaluationRecord finalTrainingEvaluations() {
        return this.trainingHistory.get(this.trainingHistory.size() - 1);
    }

    public EvaluationRecord finalValidationEvaluations() {
        return this.validationHistory.get(this.validationHistory.size() - 1);
    }

    public EvaluationRecord trainingEvaluations(int epoch) {
        if (epoch >= 0) {
            return this.trainingHistory.get(epoch);
        }
        return this.trainingHistory.get(this.trainingHistory.size() - epoch);
    }

    public EvaluationRecord validationEvaluations(int epoch) {
        if (epoch >= 0) {
            return this.trainingHistory.get(epoch);
        }
        return this.validationHistory.get(this.validationHistory.size() - epoch);
    }

    public List<EvaluationRecord> getTrainingHistory() {
        return this.trainingHistory;
    }

    public List<EvaluationRecord> getValidationHistory() {
        return this.validationHistory;
    }

    public LossCurve getLossCurve() {
        return this.lossCurve;
    }

    public long getTrainingTimeMillis() {
        return this.trainingTimeMillis;
    }

    public List<Long> getValidationTimesMillis() {
        return this.validationTimesMillis;
    }
}

