/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.listeners;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.listeners.ListenerVariables;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.base.Preconditions;
import org.nd4j.evaluation.IEvaluation;

public class ListenerEvaluations {
    private Map<String, List<IEvaluation>> trainEvaluations;
    private Map<String, Integer> trainEvaluationLabels;
    private Map<String, List<IEvaluation>> validationEvaluations;
    private Map<String, Integer> validationEvaluationLabels;

    public ListenerEvaluations(Map<String, List<IEvaluation>> trainEvaluations, Map<String, Integer> trainEvaluationLabels, Map<String, List<IEvaluation>> validationEvaluations, Map<String, Integer> validationEvaluationLabels) {
        this.trainEvaluations = trainEvaluations;
        this.trainEvaluationLabels = trainEvaluationLabels;
        this.validationEvaluations = validationEvaluations;
        this.validationEvaluationLabels = validationEvaluationLabels;
        Preconditions.checkArgument((boolean)trainEvaluations.keySet().equals(trainEvaluationLabels.keySet()), (String)"Must specify a label index for each train evaluation.  Expected: %s, got: %s", trainEvaluations.keySet(), trainEvaluationLabels.keySet());
        Preconditions.checkArgument((boolean)validationEvaluations.keySet().equals(validationEvaluationLabels.keySet()), (String)"Must specify a label index for each validation evaluation.  Expected: %s, got: %s", validationEvaluations.keySet(), validationEvaluationLabels.keySet());
    }

    private ListenerEvaluations() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, List<IEvaluation>> trainEvaluations() {
        return this.trainEvaluations;
    }

    public Map<String, Integer> trainEvaluationLabels() {
        return this.trainEvaluationLabels;
    }

    public Map<String, List<IEvaluation>> validationEvaluations() {
        return this.validationEvaluations;
    }

    public Map<String, Integer> validationEvaluationLabels() {
        return this.validationEvaluationLabels;
    }

    public ListenerVariables requiredVariables() {
        return new ListenerVariables(this.trainEvaluations.keySet(), this.validationEvaluations.keySet(), new HashSet<String>(), new HashSet<String>());
    }

    public boolean isEmpty() {
        return this.trainEvaluations.isEmpty() && this.validationEvaluations.isEmpty();
    }

    public Map<String, List<IEvaluation>> getTrainEvaluations() {
        return this.trainEvaluations;
    }

    public Map<String, Integer> getTrainEvaluationLabels() {
        return this.trainEvaluationLabels;
    }

    public Map<String, List<IEvaluation>> getValidationEvaluations() {
        return this.validationEvaluations;
    }

    public Map<String, Integer> getValidationEvaluationLabels() {
        return this.validationEvaluationLabels;
    }

    public static class Builder {
        private Map<String, List<IEvaluation>> trainEvaluations = new HashMap<String, List<IEvaluation>>();
        private Map<String, Integer> trainEvaluationLabels = new HashMap<String, Integer>();
        private Map<String, List<IEvaluation>> validationEvaluations = new HashMap<String, List<IEvaluation>>();
        private Map<String, Integer> validationEvaluationLabels = new HashMap<String, Integer>();

        private void addEvaluations(boolean validation, @NonNull Map<String, List<IEvaluation>> evaluationMap, @NonNull Map<String, Integer> labelMap, @NonNull String variableName, int labelIndex, IEvaluation ... evaluations) {
            if (evaluationMap == null) {
                throw new NullPointerException("evaluationMap is marked @NonNull but is null");
            }
            if (labelMap == null) {
                throw new NullPointerException("labelMap is marked @NonNull but is null");
            }
            if (variableName == null) {
                throw new NullPointerException("variableName is marked @NonNull but is null");
            }
            if (evaluations == null) {
                throw new NullPointerException("evaluations is marked @NonNull but is null");
            }
            if (evaluationMap.containsKey(variableName) && labelMap.get(variableName) != labelIndex) {
                String s = validation ? "This ListenerEvaluations.Builder already has validation evaluations for " : "This ListenerEvaluations.Builder already has train evaluations for ";
                throw new IllegalArgumentException(s + "variable " + variableName + " with label index " + labelIndex + ".  You can't add  evaluations with a different label index.  Got label index " + labelIndex);
            }
            if (evaluationMap.containsKey(variableName)) {
                evaluationMap.get(variableName).addAll(Arrays.asList(evaluations));
            } else {
                evaluationMap.put(variableName, Arrays.asList(evaluations));
                labelMap.put(variableName, labelIndex);
            }
        }

        public Builder trainEvaluation(@NonNull String variableName, int labelIndex, IEvaluation ... evaluations) {
            if (variableName == null) {
                throw new NullPointerException("variableName is marked @NonNull but is null");
            }
            if (evaluations == null) {
                throw new NullPointerException("evaluations is marked @NonNull but is null");
            }
            this.addEvaluations(false, this.trainEvaluations, this.trainEvaluationLabels, variableName, labelIndex, evaluations);
            return this;
        }

        public Builder trainEvaluation(@NonNull SDVariable variable, int labelIndex, IEvaluation ... evaluations) {
            if (variable == null) {
                throw new NullPointerException("variable is marked @NonNull but is null");
            }
            if (evaluations == null) {
                throw new NullPointerException("evaluations is marked @NonNull but is null");
            }
            return this.trainEvaluation(variable.getVarName(), labelIndex, evaluations);
        }

        public Builder validationEvaluation(@NonNull String variableName, int labelIndex, IEvaluation ... evaluations) {
            if (variableName == null) {
                throw new NullPointerException("variableName is marked @NonNull but is null");
            }
            if (evaluations == null) {
                throw new NullPointerException("evaluations is marked @NonNull but is null");
            }
            this.addEvaluations(true, this.validationEvaluations, this.validationEvaluationLabels, variableName, labelIndex, evaluations);
            return this;
        }

        public Builder validationEvaluation(@NonNull SDVariable variable, int labelIndex, IEvaluation ... evaluations) {
            if (variable == null) {
                throw new NullPointerException("variable is marked @NonNull but is null");
            }
            if (evaluations == null) {
                throw new NullPointerException("evaluations is marked @NonNull but is null");
            }
            return this.validationEvaluation(variable.getVarName(), labelIndex, evaluations);
        }

        public Builder addEvaluations(boolean validation, @NonNull String variableName, int labelIndex, IEvaluation ... evaluations) {
            if (variableName == null) {
                throw new NullPointerException("variableName is marked @NonNull but is null");
            }
            if (evaluations == null) {
                throw new NullPointerException("evaluations is marked @NonNull but is null");
            }
            if (validation) {
                return this.validationEvaluation(variableName, labelIndex, evaluations);
            }
            return this.trainEvaluation(variableName, labelIndex, evaluations);
        }

        public ListenerEvaluations build() {
            return new ListenerEvaluations(this.trainEvaluations, this.trainEvaluationLabels, this.validationEvaluations, this.validationEvaluationLabels);
        }

        public Map<String, List<IEvaluation>> getTrainEvaluations() {
            return this.trainEvaluations;
        }

        public Map<String, Integer> getTrainEvaluationLabels() {
            return this.trainEvaluationLabels;
        }

        public Map<String, List<IEvaluation>> getValidationEvaluations() {
            return this.validationEvaluations;
        }

        public Map<String, Integer> getValidationEvaluationLabels() {
            return this.validationEvaluationLabels;
        }

        public void setTrainEvaluations(Map<String, List<IEvaluation>> trainEvaluations) {
            this.trainEvaluations = trainEvaluations;
        }

        public void setTrainEvaluationLabels(Map<String, Integer> trainEvaluationLabels) {
            this.trainEvaluationLabels = trainEvaluationLabels;
        }

        public void setValidationEvaluations(Map<String, List<IEvaluation>> validationEvaluations) {
            this.validationEvaluations = validationEvaluations;
        }

        public void setValidationEvaluationLabels(Map<String, Integer> validationEvaluationLabels) {
            this.validationEvaluationLabels = validationEvaluationLabels;
        }
    }
}

