/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops.transforms;

import java.util.List;
import lombok.NonNull;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.reduce3.CosineDistance;
import org.nd4j.linalg.api.ops.impl.reduce3.CosineSimilarity;
import org.nd4j.linalg.api.ops.impl.reduce3.Dot;
import org.nd4j.linalg.api.ops.impl.reduce3.EuclideanDistance;
import org.nd4j.linalg.api.ops.impl.reduce3.HammingDistance;
import org.nd4j.linalg.api.ops.impl.reduce3.JaccardDistance;
import org.nd4j.linalg.api.ops.impl.reduce3.ManhattanDistance;
import org.nd4j.linalg.api.ops.impl.scalar.LeakyReLU;
import org.nd4j.linalg.api.ops.impl.scalar.LogX;
import org.nd4j.linalg.api.ops.impl.scalar.Pow;
import org.nd4j.linalg.api.ops.impl.scalar.RectifiedLinear;
import org.nd4j.linalg.api.ops.impl.scalar.Relu6;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMax;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMin;
import org.nd4j.linalg.api.ops.impl.scalar.Step;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarNot;
import org.nd4j.linalg.api.ops.impl.shape.Cross;
import org.nd4j.linalg.api.ops.impl.transforms.any.IsMax;
import org.nd4j.linalg.api.ops.impl.transforms.bool.BooleanNot;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.Eps;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldGreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldLessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldMax;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldMin;
import org.nd4j.linalg.api.ops.impl.transforms.floating.Sqrt;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.ELUDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.HardTanhDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.LeakyReLUDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SoftSignDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.OldAtan2Op;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.PowPairwise;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.bool.And;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.bool.Or;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.bool.Xor;
import org.nd4j.linalg.api.ops.impl.transforms.same.Abs;
import org.nd4j.linalg.api.ops.impl.transforms.same.Ceil;
import org.nd4j.linalg.api.ops.impl.transforms.same.Floor;
import org.nd4j.linalg.api.ops.impl.transforms.same.Negative;
import org.nd4j.linalg.api.ops.impl.transforms.same.OldIdentity;
import org.nd4j.linalg.api.ops.impl.transforms.same.OldReverse;
import org.nd4j.linalg.api.ops.impl.transforms.same.Round;
import org.nd4j.linalg.api.ops.impl.transforms.same.Sign;
import org.nd4j.linalg.api.ops.impl.transforms.same.TimesOneMinus;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ACos;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ASin;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ATan;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ATanh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Cos;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Cosh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.ELU;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Exp;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Expm1;
import org.nd4j.linalg.api.ops.impl.transforms.strict.HardSigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.strict.HardTanh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Log;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Log1p;
import org.nd4j.linalg.api.ops.impl.transforms.strict.OldSoftMax;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Sigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.strict.SigmoidDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Sin;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Sinh;
import org.nd4j.linalg.api.ops.impl.transforms.strict.SoftPlus;
import org.nd4j.linalg.api.ops.impl.transforms.strict.SoftSign;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Stabilize;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Tan;
import org.nd4j.linalg.api.ops.impl.transforms.strict.Tanh;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.inverse.InvertMatrix;

public class Transforms {
    private Transforms() {
    }

    public static double cosineSim(@NonNull INDArray d1, @NonNull INDArray d2) {
        if (d1 == null) {
            throw new NullPointerException("d1 is marked @NonNull but is null");
        }
        if (d2 == null) {
            throw new NullPointerException("d2 is marked @NonNull but is null");
        }
        return Nd4j.getExecutioner().exec(new CosineSimilarity(d1, d2, new int[0])).getDouble(0L);
    }

    public static double cosineDistance(@NonNull INDArray d1, @NonNull INDArray d2) {
        if (d1 == null) {
            throw new NullPointerException("d1 is marked @NonNull but is null");
        }
        if (d2 == null) {
            throw new NullPointerException("d2 is marked @NonNull but is null");
        }
        return Nd4j.getExecutioner().exec(new CosineDistance(d1, d2, new int[0])).getDouble(0L);
    }

    public static double hammingDistance(@NonNull INDArray d1, @NonNull INDArray d2) {
        if (d1 == null) {
            throw new NullPointerException("d1 is marked @NonNull but is null");
        }
        if (d2 == null) {
            throw new NullPointerException("d2 is marked @NonNull but is null");
        }
        return Nd4j.getExecutioner().exec(new HammingDistance(d1, d2, new int[0])).getDouble(0L);
    }

    public static double jaccardDistance(@NonNull INDArray d1, @NonNull INDArray d2) {
        if (d1 == null) {
            throw new NullPointerException("d1 is marked @NonNull but is null");
        }
        if (d2 == null) {
            throw new NullPointerException("d2 is marked @NonNull but is null");
        }
        return Nd4j.getExecutioner().exec(new JaccardDistance(d1, d2, new int[0])).getDouble(0L);
    }

    public static INDArray allCosineSimilarities(@NonNull INDArray d1, @NonNull INDArray d2, int ... dimensions) {
        if (d1 == null) {
            throw new NullPointerException("d1 is marked @NonNull but is null");
        }
        if (d2 == null) {
            throw new NullPointerException("d2 is marked @NonNull but is null");
        }
        return Nd4j.getExecutioner().exec(new CosineSimilarity(d1, d2, true, dimensions));
    }

    public static INDArray allCosineDistances(@NonNull INDArray d1, @NonNull INDArray d2, int ... dimensions) {
        if (d1 == null) {
            throw new NullPointerException("d1 is marked @NonNull but is null");
        }
        if (d2 == null) {
            throw new NullPointerException("d2 is marked @NonNull but is null");
        }
        return Nd4j.getExecutioner().exec(new CosineDistance(d1, d2, true, dimensions));
    }

    public static INDArray allEuclideanDistances(@NonNull INDArray d1, @NonNull INDArray d2, int ... dimensions) {
        if (d1 == null) {
            throw new NullPointerException("d1 is marked @NonNull but is null");
        }
        if (d2 == null) {
            throw new NullPointerException("d2 is marked @NonNull but is null");
        }
        return Nd4j.getExecutioner().exec(new EuclideanDistance(d1, d2, true, dimensions));
    }

    public static INDArray allManhattanDistances(@NonNull INDArray d1, @NonNull INDArray d2, int ... dimensions) {
        if (d1 == null) {
            throw new NullPointerException("d1 is marked @NonNull but is null");
        }
        if (d2 == null) {
            throw new NullPointerException("d2 is marked @NonNull but is null");
        }
        return Nd4j.getExecutioner().exec(new ManhattanDistance(d1, d2, true, dimensions));
    }

    public static INDArray reverse(INDArray x, boolean dup) {
        return Nd4j.getExecutioner().exec(new OldReverse(x, dup ? x.ulike() : x));
    }

    public static INDArray dot(INDArray x, INDArray y) {
        return Nd4j.getExecutioner().exec(new Dot(x, y, new int[0]));
    }

    public static INDArray cross(INDArray x, INDArray y) {
        Cross c = new Cross(x, y, null);
        List<LongShapeDescriptor> shape = c.calculateOutputShape();
        INDArray out = Nd4j.create(shape.get(0));
        c.addOutputArgument(out);
        Nd4j.getExecutioner().exec(c);
        return out;
    }

    public static double manhattanDistance(@NonNull INDArray d1, @NonNull INDArray d2) {
        if (d1 == null) {
            throw new NullPointerException("d1 is marked @NonNull but is null");
        }
        if (d2 == null) {
            throw new NullPointerException("d2 is marked @NonNull but is null");
        }
        return d1.distance1(d2);
    }

    public static INDArray atan2(@NonNull INDArray x, @NonNull INDArray y) {
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        if (y == null) {
            throw new NullPointerException("y is marked @NonNull but is null");
        }
        return Nd4j.getExecutioner().exec(new OldAtan2Op(x, y, x.ulike()));
    }

    public static double euclideanDistance(@NonNull INDArray d1, @NonNull INDArray d2) {
        if (d1 == null) {
            throw new NullPointerException("d1 is marked @NonNull but is null");
        }
        if (d2 == null) {
            throw new NullPointerException("d2 is marked @NonNull but is null");
        }
        return d1.distance2(d2);
    }

    public static INDArray normalizeZeroMeanAndUnitVariance(INDArray toNormalize) {
        INDArray columnMeans = toNormalize.mean(0);
        INDArray columnStds = toNormalize.std(0);
        toNormalize.subiRowVector(columnMeans);
        columnStds.addi(Nd4j.EPS_THRESHOLD);
        toNormalize.diviRowVector(columnStds);
        return toNormalize;
    }

    public static INDArray unitVec(INDArray toScale) {
        double length = toScale.norm2Number().doubleValue();
        if (length > 0.0) {
            if (toScale.data().dataType() == DataType.FLOAT) {
                return Nd4j.getBlasWrapper().scal(1.0f / (float)length, toScale);
            }
            return Nd4j.getBlasWrapper().scal(1.0 / length, toScale);
        }
        return toScale;
    }

    public static INDArray neg(INDArray ndArray) {
        return Transforms.neg(ndArray, true);
    }

    public static INDArray floor(INDArray ndArray) {
        return Transforms.floor(ndArray, true);
    }

    public static INDArray ceiling(INDArray ndArray) {
        return Transforms.ceiling(ndArray, true);
    }

    public static INDArray ceiling(INDArray ndArray, boolean copyOnOps) {
        return Transforms.exec(copyOnOps ? new Ceil(ndArray, ndArray.ulike()) : new Ceil(ndArray, ndArray));
    }

    public static INDArray sign(INDArray toSign) {
        return Transforms.sign(toSign, true);
    }

    public static INDArray stabilize(INDArray ndArray, double k) {
        return Transforms.stabilize(ndArray, k, true);
    }

    public static INDArray sin(INDArray in) {
        return Transforms.sin(in, true);
    }

    public static INDArray sin(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new Sin(in, copy ? in.ulike() : in));
    }

    public static INDArray atanh(INDArray in) {
        return Transforms.atanh(in, true);
    }

    public static INDArray atanh(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new ATanh(in, copy ? in.ulike() : in));
    }

    public static INDArray sinh(INDArray in) {
        return Transforms.sinh(in, true);
    }

    public static INDArray sinh(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new Sinh(in, copy ? in.ulike() : in));
    }

    public static INDArray cos(INDArray in) {
        return Transforms.cos(in, true);
    }

    public static INDArray cosh(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new Cosh(in, copy ? in.ulike() : in));
    }

    public static INDArray cosh(INDArray in) {
        return Transforms.cosh(in, true);
    }

    public static INDArray cos(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new Cos(in, copy ? in.ulike() : in));
    }

    public static INDArray acos(INDArray arr) {
        return Transforms.acos(arr, true);
    }

    public static INDArray acos(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new ACos(in, copy ? in.ulike() : in));
    }

    public static INDArray asin(INDArray arr) {
        return Transforms.asin(arr, true);
    }

    public static INDArray asin(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new ASin(copy ? in.dup() : in));
    }

    public static INDArray atan(INDArray arr) {
        return Transforms.atan(arr, true);
    }

    public static INDArray atan(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new ATan(in, copy ? in.ulike() : in));
    }

    public static INDArray ceil(INDArray arr) {
        return Transforms.ceil(arr, true);
    }

    public static INDArray ceil(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new Ceil(in, copy ? in.ulike() : in));
    }

    public static INDArray relu(INDArray arr) {
        return Transforms.relu(arr, true);
    }

    public static INDArray relu(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new RectifiedLinear(in, copy ? in.ulike() : in));
    }

    public static INDArray relu6(INDArray arr) {
        return Transforms.relu6(arr, true);
    }

    public static INDArray relu6(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new Relu6(in, copy ? in.ulike() : in));
    }

    public static INDArray leakyRelu(INDArray arr) {
        return Transforms.leakyRelu(arr, true);
    }

    public static INDArray leakyRelu(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new LeakyReLU(in, copy ? in.ulike() : in));
    }

    public static INDArray elu(INDArray arr) {
        return Transforms.elu(arr, true);
    }

    public static INDArray elu(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new ELU(in, copy ? in.ulike() : in));
    }

    public static INDArray eluDerivative(INDArray arr) {
        return Transforms.eluDerivative(arr, true);
    }

    public static INDArray eluDerivative(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new ELUDerivative(in, copy ? in.ulike() : in));
    }

    public static INDArray leakyRelu(INDArray arr, double cutoff) {
        return Transforms.leakyRelu(arr, cutoff, true);
    }

    public static INDArray leakyRelu(INDArray in, double cutoff, boolean copy) {
        return Nd4j.getExecutioner().exec(new LeakyReLU(in, copy ? in.ulike() : in, cutoff));
    }

    public static INDArray leakyReluDerivative(INDArray arr, double cutoff) {
        return Transforms.leakyReluDerivative(arr, cutoff, true);
    }

    public static INDArray leakyReluDerivative(INDArray in, double cutoff, boolean copy) {
        return Nd4j.getExecutioner().exec(new LeakyReLUDerivative(in, copy ? in.ulike() : in, cutoff));
    }

    public static INDArray softPlus(INDArray arr) {
        return Transforms.softPlus(arr, true);
    }

    public static INDArray softPlus(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new SoftPlus(in, copy ? in.ulike() : in));
    }

    public static INDArray step(INDArray arr) {
        return Transforms.step(arr, true);
    }

    public static INDArray step(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new Step(in, copy ? in.ulike() : in));
    }

    public static INDArray softsign(INDArray arr) {
        return Transforms.softsign(arr, true);
    }

    public static INDArray softsign(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new SoftSign(in, copy ? in.ulike() : in));
    }

    public static INDArray softsignDerivative(INDArray arr) {
        return Transforms.softsignDerivative(arr, true);
    }

    public static INDArray softsignDerivative(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new SoftSignDerivative(in, copy ? in.ulike() : in));
    }

    public static INDArray softmax(INDArray arr) {
        return Transforms.softmax(arr, true);
    }

    public static INDArray softmax(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new OldSoftMax(in, copy ? in.ulike() : in));
    }

    public static INDArray timesOneMinus(INDArray in, boolean copy) {
        return Nd4j.getExecutioner().exec(new TimesOneMinus(in, copy ? in.ulike() : in));
    }

    public static INDArray abs(INDArray ndArray) {
        return Transforms.abs(ndArray, true);
    }

    public static INDArray exp(INDArray ndArray) {
        return Transforms.exp(ndArray, true);
    }

    public static INDArray hardTanh(INDArray ndArray) {
        return Transforms.hardTanh(ndArray, true);
    }

    public static INDArray hardTanh(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new HardTanh(ndArray, ndArray.ulike()) : new HardTanh(ndArray));
    }

    public static INDArray hardSigmoid(INDArray arr, boolean dup) {
        return Nd4j.getExecutioner().exec(new HardSigmoid(arr, dup ? arr.ulike() : arr));
    }

    public static INDArray hardTanhDerivative(INDArray ndArray) {
        return Transforms.hardTanhDerivative(ndArray, true);
    }

    public static INDArray hardTanhDerivative(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new HardTanhDerivative(ndArray, ndArray.ulike()) : new HardTanhDerivative(ndArray));
    }

    public static INDArray identity(INDArray ndArray) {
        return Transforms.identity(ndArray, true);
    }

    public static INDArray pow(INDArray ndArray, Number power) {
        return Transforms.pow(ndArray, power, true);
    }

    public static INDArray pow(INDArray ndArray, INDArray power) {
        return Transforms.pow(ndArray, power, true);
    }

    public static INDArray pow(INDArray ndArray, INDArray power, boolean dup) {
        INDArray result = dup ? ndArray.ulike() : ndArray;
        return Transforms.exec(new PowPairwise(ndArray, power, result));
    }

    public static INDArray round(INDArray ndArray) {
        return Transforms.round(ndArray, true);
    }

    public static INDArray sigmoid(INDArray ndArray) {
        return Transforms.sigmoid(ndArray, true);
    }

    public static INDArray sigmoid(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Sigmoid(ndArray, ndArray.ulike()) : new Sigmoid(ndArray));
    }

    public static INDArray sigmoidDerivative(INDArray ndArray) {
        return Transforms.sigmoidDerivative(ndArray, true);
    }

    public static INDArray sigmoidDerivative(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new SigmoidDerivative(ndArray, ndArray.ulike()) : new SigmoidDerivative(ndArray));
    }

    public static INDArray sqrt(INDArray ndArray) {
        return Transforms.sqrt(ndArray, true);
    }

    public static INDArray tan(INDArray ndArray) {
        return Transforms.tan(ndArray, true);
    }

    public static INDArray tan(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Tan(ndArray, ndArray.ulike()) : new Tan(ndArray));
    }

    public static INDArray tanh(INDArray ndArray) {
        return Transforms.tanh(ndArray, true);
    }

    public static INDArray log(INDArray ndArray, double base) {
        return Transforms.log(ndArray, base, true);
    }

    public static INDArray log(INDArray ndArray, double base, boolean duplicate) {
        return Nd4j.getExecutioner().exec(new LogX(ndArray, duplicate ? ndArray.ulike() : ndArray, base));
    }

    public static INDArray log(INDArray ndArray) {
        return Transforms.log(ndArray, true);
    }

    public static INDArray eps(INDArray ndArray) {
        return Transforms.exec(new Eps(ndArray));
    }

    public static INDArray greaterThanOrEqual(INDArray first, INDArray ndArray) {
        return Transforms.greaterThanOrEqual(first, ndArray, true);
    }

    public static INDArray lessThanOrEqual(INDArray first, INDArray ndArray) {
        return Transforms.lessThanOrEqual(first, ndArray, true);
    }

    public static INDArray lessThanOrEqual(INDArray first, INDArray ndArray, boolean dup) {
        return Transforms.exec(new OldLessThanOrEqual(first, ndArray, Nd4j.createUninitialized(DataType.BOOL, first.shape(), first.ordering())));
    }

    public static INDArray greaterThanOrEqual(INDArray first, INDArray ndArray, boolean dup) {
        return Transforms.exec(new OldGreaterThanOrEqual(first, ndArray, Nd4j.createUninitialized(DataType.BOOL, first.shape(), first.ordering())));
    }

    public static INDArray floor(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Floor(ndArray, ndArray.ulike()) : new Floor(ndArray));
    }

    public static INDArray sign(INDArray toSign, boolean dup) {
        return Transforms.exec(dup ? new Sign(toSign, toSign.ulike()) : new Sign(toSign));
    }

    public static INDArray max(INDArray ndArray, double k, boolean dup) {
        return Transforms.exec(dup ? new ScalarMax(ndArray, null, ndArray.ulike(), k) : new ScalarMax(ndArray, k));
    }

    public static INDArray max(INDArray ndArray, double k) {
        return Transforms.max(ndArray, k, true);
    }

    public static INDArray max(INDArray first, INDArray second, boolean dup) {
        INDArray result = first;
        if (dup) {
            result = first.ulike();
        }
        return Transforms.exec(new OldMax(first, second, result));
    }

    public static INDArray max(INDArray first, INDArray second) {
        return Transforms.max(first, second, true);
    }

    public static INDArray min(INDArray ndArray, double k, boolean dup) {
        return Transforms.exec(dup ? new ScalarMin(ndArray, null, ndArray.ulike(), k) : new ScalarMin(ndArray, k));
    }

    public static INDArray min(INDArray ndArray, double k) {
        return Transforms.min(ndArray, k, true);
    }

    public static INDArray min(INDArray first, INDArray second, boolean dup) {
        if (dup) {
            first = first.dup();
        }
        return Transforms.exec(new OldMin(second, first, first));
    }

    public static INDArray min(INDArray first, INDArray second) {
        return Transforms.min(first, second, true);
    }

    public static INDArray stabilize(INDArray ndArray, double k, boolean dup) {
        return Transforms.exec(dup ? new Stabilize(ndArray, ndArray.ulike(), k) : new Stabilize(ndArray, k));
    }

    public static INDArray abs(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Abs(ndArray, ndArray.ulike()) : new Abs(ndArray));
    }

    public static INDArray exp(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Exp(ndArray, ndArray.ulike()) : new Exp(ndArray));
    }

    public static INDArray expm1(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Expm1(ndArray, ndArray.ulike()) : new Expm1(ndArray));
    }

    public static INDArray identity(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new OldIdentity(ndArray, ndArray.ulike()) : new OldIdentity(ndArray));
    }

    public static INDArray isMax(INDArray input, DataType dataType) {
        return Transforms.isMax(input, Nd4j.createUninitialized(dataType, input.shape(), input.ordering()));
    }

    public static INDArray isMax(INDArray input) {
        return Transforms.isMax(input, input);
    }

    public static INDArray isMax(INDArray input, INDArray output) {
        return Nd4j.getExecutioner().exec(new IsMax(input, output));
    }

    public static INDArray pow(INDArray ndArray, Number power, boolean dup) {
        return Transforms.exec(dup ? new Pow(ndArray, ndArray.ulike(), power.doubleValue()) : new Pow(ndArray, power.doubleValue()));
    }

    public static INDArray round(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Round(ndArray, ndArray.ulike()) : new Round(ndArray));
    }

    public static INDArray sqrt(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Sqrt(ndArray, ndArray.ulike()) : new Sqrt(ndArray));
    }

    public static INDArray tanh(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Tanh(ndArray, ndArray.ulike()) : new Tanh(ndArray));
    }

    public static INDArray log(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Log(ndArray, ndArray.ulike()) : new Log(ndArray));
    }

    public static INDArray log1p(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Log1p(ndArray, ndArray.ulike()) : new Log1p(ndArray));
    }

    public static INDArray neg(INDArray ndArray, boolean dup) {
        return Transforms.exec(dup ? new Negative(ndArray, ndArray.ulike()) : new Negative(ndArray));
    }

    public static INDArray and(INDArray x, INDArray y) {
        INDArray z = Nd4j.createUninitialized(DataType.BOOL, x.shape(), x.ordering());
        Nd4j.getExecutioner().exec(new And(x, y, z, (Number)0.0));
        return z;
    }

    public static INDArray or(INDArray x, INDArray y) {
        INDArray z = Nd4j.createUninitialized(DataType.BOOL, x.shape(), x.ordering());
        Nd4j.getExecutioner().exec(new Or(x, y, z, (Number)0.0));
        return z;
    }

    public static INDArray xor(INDArray x, INDArray y) {
        INDArray z = Nd4j.createUninitialized(DataType.BOOL, x.shape(), x.ordering());
        Nd4j.getExecutioner().exec(new Xor(x, y, z, (Number)0.0));
        return z;
    }

    public static INDArray not(INDArray x) {
        INDArray z = Nd4j.createUninitialized(DataType.BOOL, x.shape(), x.ordering());
        if (x.isB()) {
            Nd4j.getExecutioner().exec(new BooleanNot(x, z));
        } else {
            Nd4j.getExecutioner().exec(new ScalarNot(x, z, (Number)Float.valueOf(0.0f)));
        }
        return z;
    }

    private static INDArray exec(ScalarOp op) {
        return Nd4j.getExecutioner().exec(op);
    }

    private static INDArray exec(TransformOp op) {
        return Nd4j.getExecutioner().exec(op);
    }

    public static INDArray mpow(INDArray in, int n, boolean dup) {
        INDArray temp;
        Preconditions.checkState((in.isMatrix() && in.isSquare() ? 1 : 0) != 0, (String)"Input must be a square matrix: got input with shape %s", (Object)in.shape());
        if (n == 0) {
            if (dup) {
                return Nd4j.eye(in.rows());
            }
            return in.assign(Nd4j.eye(in.rows()));
        }
        if (n < 0) {
            temp = InvertMatrix.invert(in, !dup);
            n = -n;
        } else {
            temp = in.dup();
        }
        INDArray result = temp.dup();
        if (n < 4) {
            for (int i = 1; i < n; ++i) {
                result.mmuli(temp);
            }
            if (dup) {
                return result;
            }
            return in.assign(result);
        }
        int squares = (int)(Math.log(n) / Math.log(2.0));
        for (int i = 0; i < squares; ++i) {
            result = result.mmul(result);
        }
        int diff = (int)Math.round((double)n - Math.pow(2.0, squares));
        for (int i = 0; i < diff; ++i) {
            result.mmuli(temp);
        }
        if (dup) {
            return result;
        }
        return in.assign(result);
    }
}

