/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.clip;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class ClipByValue
extends DynamicCustomOp {
    private double clipValueMin;
    private double clipValueMax;

    public ClipByValue(INDArray[] inputs, INDArray[] outputs, double clipValueMin, double clipValueMax, boolean inPlace) {
        super(null, inputs, outputs);
        this.clipValueMin = clipValueMin;
        this.clipValueMax = clipValueMax;
        this.inplaceCall = inPlace;
        this.addTArgument(clipValueMin, clipValueMax);
    }

    public ClipByValue() {
    }

    public ClipByValue(SameDiff sameDiff, SDVariable x, double clipValueMin, double clipValueMax, boolean inPlace) {
        super(null, sameDiff, new SDVariable[]{x});
        this.clipValueMin = clipValueMin;
        this.clipValueMax = clipValueMax;
        this.inplaceCall = inPlace;
        this.addTArgument(clipValueMin, clipValueMax);
    }

    public ClipByValue(SameDiff sameDiff, SDVariable x, double clipValueMin, double clipValueMax) {
        super(null, sameDiff, new SDVariable[]{x});
        this.clipValueMin = clipValueMin;
        this.clipValueMax = clipValueMax;
        this.addTArgument(clipValueMin, clipValueMax);
    }

    @Override
    public String opName() {
        return "clipbyvalue";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        SDVariable notClippedLower = this.f().gt(this.arg(), this.clipValueMin).castTo(this.arg().dataType());
        SDVariable notClippedUpper = this.f().lt(this.arg(), this.clipValueMax).castTo(this.arg().dataType());
        SDVariable ret = notClippedLower.mul(notClippedUpper).mul(grad.get(0));
        return Collections.singletonList(ret);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got %s", this.getClass(), inputDataTypes);
        return inputDataTypes;
    }
}

