/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDIndex;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Pad
extends DynamicCustomOp {
    private Mode mode;
    private double constant;

    public Pad() {
    }

    public Pad(SameDiff sd, SDVariable in, SDVariable padding, Mode mode, double padValue) {
        super(sd, new SDVariable[]{in, padding}, false);
        Preconditions.checkState((boolean)padding.dataType().isIntType(), (String)"Padding array must be an integer datatype, got %s", (Object)padding.dataType());
        this.mode = mode;
        this.addIArgument(mode.ordinal());
        this.addTArgument(padValue);
    }

    @Override
    public String opName() {
        return "pad";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"Pad", "PadV2"};
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        this.mode = Mode.CONSTANT;
        this.addIArgument(this.mode.ordinal());
    }

    @Override
    public void resolvePropertiesFromSameDiffBeforeExecution() {
        if (this.args().length == 3) {
            INDArray arr = this.arg(2).getArr();
            this.tArguments.clear();
            this.tArguments.add(arr.getDouble(0L));
        }
        super.resolvePropertiesFromSameDiffBeforeExecution();
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable shape = this.arg().shape();
        SDVariable begin = this.arg(1).get(SDIndex.all(), SDIndex.point(0L));
        SDVariable gradAtIn = this.sameDiff.slice(i_v.get(0), begin, shape);
        SDVariable zeros = this.sameDiff.zerosLike(this.arg(1));
        return Arrays.asList(gradAtIn, zeros);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && (inputDataTypes.size() == 1 || inputDataTypes.size() == 2) ? 1 : 0) != 0, (String)"Expected 1 or 2 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static enum Mode {
        CONSTANT,
        REFLECT,
        SYMMETRIC;

    }
}

