/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.loss;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.loss.LossReduce;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ops.impl.loss.BaseLoss;

public class HuberLoss
extends BaseLoss {
    private double delta;

    public HuberLoss(SameDiff sameDiff, LossReduce lossReduce, SDVariable predictions, SDVariable weights, SDVariable labels, double delta) {
        super(sameDiff, lossReduce, predictions, weights, labels);
        Preconditions.checkState((delta >= 0.0 ? 1 : 0) != 0, (String)"Delta must be >= 0.0. Got: %s", (double)delta);
        this.delta = delta;
        this.tArguments.add(delta);
    }

    public HuberLoss() {
    }

    @Override
    public String opName() {
        return "huber_loss";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        SDVariable[] grads = this.f().lossHuberBp(this.arg(2), this.arg(0), this.arg(1), this.lossReduce, this.delta);
        return Arrays.asList(grads);
    }
}

