/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.BaseConvolutionConfig;

public class Conv2DConfig
extends BaseConvolutionConfig {
    public static final String NCHW = "NCHW";
    public static final String NHWC = "NHWC";
    private long kH;
    private long kW;
    private long sH;
    private long sW;
    private long pH;
    private long pW;
    private long dH;
    private long dW;
    private boolean isSameMode;
    private String dataFormat;

    public boolean isNHWC() {
        Preconditions.checkState((this.dataFormat.equalsIgnoreCase(NCHW) || this.dataFormat.equalsIgnoreCase(NHWC) ? 1 : 0) != 0, (String)"Data format must be one of %s or %s, got %s", (Object)NCHW, (Object)NHWC, (Object)this.dataFormat);
        return this.dataFormat.equalsIgnoreCase(NHWC);
    }

    public void isNHWC(boolean isNHWC) {
        this.dataFormat = isNHWC ? NHWC : NCHW;
    }

    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("kH", this.kH);
        ret.put("kW", this.kW);
        ret.put("sH", this.sH);
        ret.put("sW", this.sW);
        ret.put("pH", this.pH);
        ret.put("pW", this.pW);
        ret.put("dH", this.dH);
        ret.put("dW", this.dW);
        ret.put("isSameMode", this.isSameMode);
        ret.put("dataFormat", this.dataFormat);
        return ret;
    }

    private static long $default$kH() {
        return -1L;
    }

    private static long $default$kW() {
        return -1L;
    }

    private static long $default$sH() {
        return 1L;
    }

    private static long $default$sW() {
        return 1L;
    }

    private static long $default$pH() {
        return 0L;
    }

    private static long $default$pW() {
        return 0L;
    }

    private static long $default$dH() {
        return 1L;
    }

    private static long $default$dW() {
        return 1L;
    }

    private static String $default$dataFormat() {
        return NCHW;
    }

    public static Conv2DConfigBuilder builder() {
        return new Conv2DConfigBuilder();
    }

    public long getKH() {
        return this.kH;
    }

    public long getKW() {
        return this.kW;
    }

    public long getSH() {
        return this.sH;
    }

    public long getSW() {
        return this.sW;
    }

    public long getPH() {
        return this.pH;
    }

    public long getPW() {
        return this.pW;
    }

    public long getDH() {
        return this.dH;
    }

    public long getDW() {
        return this.dW;
    }

    public boolean isSameMode() {
        return this.isSameMode;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setKH(long kH) {
        this.kH = kH;
    }

    public void setKW(long kW) {
        this.kW = kW;
    }

    public void setSH(long sH) {
        this.sH = sH;
    }

    public void setSW(long sW) {
        this.sW = sW;
    }

    public void setPH(long pH) {
        this.pH = pH;
    }

    public void setPW(long pW) {
        this.pW = pW;
    }

    public void setDH(long dH) {
        this.dH = dH;
    }

    public void setDW(long dW) {
        this.dW = dW;
    }

    public void setSameMode(boolean isSameMode) {
        this.isSameMode = isSameMode;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Conv2DConfig)) {
            return false;
        }
        Conv2DConfig other = (Conv2DConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getKH() != other.getKH()) {
            return false;
        }
        if (this.getKW() != other.getKW()) {
            return false;
        }
        if (this.getSH() != other.getSH()) {
            return false;
        }
        if (this.getSW() != other.getSW()) {
            return false;
        }
        if (this.getPH() != other.getPH()) {
            return false;
        }
        if (this.getPW() != other.getPW()) {
            return false;
        }
        if (this.getDH() != other.getDH()) {
            return false;
        }
        if (this.getDW() != other.getDW()) {
            return false;
        }
        if (this.isSameMode() != other.isSameMode()) {
            return false;
        }
        String this$dataFormat = this.getDataFormat();
        String other$dataFormat = other.getDataFormat();
        return !(this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Conv2DConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $kH = this.getKH();
        result = result * 59 + (int)($kH >>> 32 ^ $kH);
        long $kW = this.getKW();
        result = result * 59 + (int)($kW >>> 32 ^ $kW);
        long $sH = this.getSH();
        result = result * 59 + (int)($sH >>> 32 ^ $sH);
        long $sW = this.getSW();
        result = result * 59 + (int)($sW >>> 32 ^ $sW);
        long $pH = this.getPH();
        result = result * 59 + (int)($pH >>> 32 ^ $pH);
        long $pW = this.getPW();
        result = result * 59 + (int)($pW >>> 32 ^ $pW);
        long $dH = this.getDH();
        result = result * 59 + (int)($dH >>> 32 ^ $dH);
        long $dW = this.getDW();
        result = result * 59 + (int)($dW >>> 32 ^ $dW);
        result = result * 59 + (this.isSameMode() ? 79 : 97);
        String $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        return result;
    }

    public String toString() {
        return "Conv2DConfig(kH=" + this.getKH() + ", kW=" + this.getKW() + ", sH=" + this.getSH() + ", sW=" + this.getSW() + ", pH=" + this.getPH() + ", pW=" + this.getPW() + ", dH=" + this.getDH() + ", dW=" + this.getDW() + ", isSameMode=" + this.isSameMode() + ", dataFormat=" + this.getDataFormat() + ")";
    }

    public Conv2DConfig(long kH, long kW, long sH, long sW, long pH, long pW, long dH, long dW, boolean isSameMode, String dataFormat) {
        this.kH = kH;
        this.kW = kW;
        this.sH = sH;
        this.sW = sW;
        this.pH = pH;
        this.pW = pW;
        this.dH = dH;
        this.dW = dW;
        this.isSameMode = isSameMode;
        this.dataFormat = dataFormat;
    }

    public Conv2DConfig() {
        this.kH = Conv2DConfig.$default$kH();
        this.kW = Conv2DConfig.$default$kW();
        this.sH = Conv2DConfig.$default$sH();
        this.sW = Conv2DConfig.$default$sW();
        this.pH = Conv2DConfig.$default$pH();
        this.pW = Conv2DConfig.$default$pW();
        this.dH = Conv2DConfig.$default$dH();
        this.dW = Conv2DConfig.$default$dW();
        this.dataFormat = Conv2DConfig.$default$dataFormat();
    }

    public static class Conv2DConfigBuilder {
        private boolean kH$set;
        private long kH;
        private boolean kW$set;
        private long kW;
        private boolean sH$set;
        private long sH;
        private boolean sW$set;
        private long sW;
        private boolean pH$set;
        private long pH;
        private boolean pW$set;
        private long pW;
        private boolean dH$set;
        private long dH;
        private boolean dW$set;
        private long dW;
        private boolean isSameMode;
        private boolean dataFormat$set;
        private String dataFormat;

        Conv2DConfigBuilder() {
        }

        public Conv2DConfigBuilder kH(long kH) {
            this.kH = kH;
            this.kH$set = true;
            return this;
        }

        public Conv2DConfigBuilder kW(long kW) {
            this.kW = kW;
            this.kW$set = true;
            return this;
        }

        public Conv2DConfigBuilder sH(long sH) {
            this.sH = sH;
            this.sH$set = true;
            return this;
        }

        public Conv2DConfigBuilder sW(long sW) {
            this.sW = sW;
            this.sW$set = true;
            return this;
        }

        public Conv2DConfigBuilder pH(long pH) {
            this.pH = pH;
            this.pH$set = true;
            return this;
        }

        public Conv2DConfigBuilder pW(long pW) {
            this.pW = pW;
            this.pW$set = true;
            return this;
        }

        public Conv2DConfigBuilder dH(long dH) {
            this.dH = dH;
            this.dH$set = true;
            return this;
        }

        public Conv2DConfigBuilder dW(long dW) {
            this.dW = dW;
            this.dW$set = true;
            return this;
        }

        public Conv2DConfigBuilder isSameMode(boolean isSameMode) {
            this.isSameMode = isSameMode;
            return this;
        }

        public Conv2DConfigBuilder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            this.dataFormat$set = true;
            return this;
        }

        public Conv2DConfig build() {
            long kH = this.kH;
            if (!this.kH$set) {
                kH = Conv2DConfig.$default$kH();
            }
            long kW = this.kW;
            if (!this.kW$set) {
                kW = Conv2DConfig.$default$kW();
            }
            long sH = this.sH;
            if (!this.sH$set) {
                sH = Conv2DConfig.$default$sH();
            }
            long sW = this.sW;
            if (!this.sW$set) {
                sW = Conv2DConfig.$default$sW();
            }
            long pH = this.pH;
            if (!this.pH$set) {
                pH = Conv2DConfig.$default$pH();
            }
            long pW = this.pW;
            if (!this.pW$set) {
                pW = Conv2DConfig.$default$pW();
            }
            long dH = this.dH;
            if (!this.dH$set) {
                dH = Conv2DConfig.$default$dH();
            }
            long dW = this.dW;
            if (!this.dW$set) {
                dW = Conv2DConfig.$default$dW();
            }
            String dataFormat = this.dataFormat;
            if (!this.dataFormat$set) {
                dataFormat = Conv2DConfig.$default$dataFormat();
            }
            return new Conv2DConfig(kH, kW, sH, sW, pH, pW, dH, dW, this.isSameMode, dataFormat);
        }

        public String toString() {
            return "Conv2DConfig.Conv2DConfigBuilder(kH=" + this.kH + ", kW=" + this.kW + ", sH=" + this.sH + ", sW=" + this.sW + ", pH=" + this.pH + ", pW=" + this.pW + ", dH=" + this.dH + ", dW=" + this.dW + ", isSameMode=" + this.isSameMode + ", dataFormat=" + this.dataFormat + ")";
        }
    }
}

