/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.SConv2DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SConv2D
extends Conv2D {
    private static final Logger log = LoggerFactory.getLogger(SConv2D.class);

    public SConv2D(SameDiff sameDiff, SDVariable[] inputFunctions, INDArray[] inputArrays, INDArray[] outputs, Conv2DConfig conv2DConfig) {
        super(sameDiff, inputFunctions, inputArrays, outputs, conv2DConfig);
    }

    public SConv2D() {
    }

    @Override
    public String opName() {
        return "sconv2d";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.add(this.arg(0));
        inputs.add(f1.get(0));
        SDVariable[] args = this.args();
        for (int i = 1; i < args.length; ++i) {
            inputs.add(args[i]);
        }
        SConv2DDerivative conv2DDerivative = SConv2DDerivative.sDerviativeBuilder().conv2DConfig(this.config).inputFunctions(inputs.toArray(new SDVariable[inputs.size()])).sameDiff(this.sameDiff).build();
        List<SDVariable> ret = Arrays.asList(conv2DDerivative.outputVariables());
        return ret;
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public String[] tensorflowNames() {
        throw new NoOpNameFoundException("No op name found for " + this.opName());
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for op " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "separable_conv2d";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static SConv2DBuilder sBuilder() {
        return new SConv2DBuilder();
    }

    public static class SConv2DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private Conv2DConfig conv2DConfig;

        SConv2DBuilder() {
        }

        public SConv2DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public SConv2DBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public SConv2DBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public SConv2DBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public SConv2DBuilder conv2DConfig(Conv2DConfig conv2DConfig) {
            this.conv2DConfig = conv2DConfig;
            return this;
        }

        public SConv2D build() {
            return new SConv2D(this.sameDiff, this.inputFunctions, this.inputArrays, this.outputs, this.conv2DConfig);
        }

        public String toString() {
            return "SConv2D.SConv2DBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", conv2DConfig=" + this.conv2DConfig + ")";
        }
    }
}

