/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv3DConfig;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class DeConv3D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(DeConv3D.class);
    protected DeConv3DConfig config;

    public DeConv3D(SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, DeConv3DConfig config) {
        super(sameDiff, DeConv3D.toArr(input, weights, bias));
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked @NonNull but is null");
        }
        this.config = config;
        this.addArgs();
    }

    private static SDVariable[] toArr(SDVariable input, SDVariable weights, SDVariable bias) {
        if (bias != null) {
            return new SDVariable[]{input, weights, bias};
        }
        return new SDVariable[]{input, weights};
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.config = DeConv3DConfig.builder().kD((Long)this.iArguments.get(0)).kH((Long)this.iArguments.get(1)).kW((Long)this.iArguments.get(2)).sD((Long)this.iArguments.get(3)).sH((Long)this.iArguments.get(4)).sW((Long)this.iArguments.get(5)).pD((Long)this.iArguments.get(6)).pH((Long)this.iArguments.get(7)).pW((Long)this.iArguments.get(8)).dD((Long)this.iArguments.get(9)).dH((Long)this.iArguments.get(10)).dW((Long)this.iArguments.get(11)).isSameMode((Long)this.iArguments.get(12) == 1L).dataFormat((Long)this.iArguments.get(13) == 1L ? "NDHWC" : "NCDHW").build();
        }
        return this.config.toProperties();
    }

    private void addArgs() {
        this.addIArgument(this.config.getKD());
        this.addIArgument(this.config.getKH());
        this.addIArgument(this.config.getKW());
        this.addIArgument(this.config.getSD());
        this.addIArgument(this.config.getSH());
        this.addIArgument(this.config.getSW());
        this.addIArgument(this.config.getPD());
        this.addIArgument(this.config.getPH());
        this.addIArgument(this.config.getPW());
        this.addIArgument(this.config.getDD());
        this.addIArgument(this.config.getDH());
        this.addIArgument(this.config.getDW());
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.config.isSameMode()));
        this.addIArgument(this.config.getDataFormat().equalsIgnoreCase("NCDHW") ? 0 : 1);
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null) {
            this.config = DeConv3DConfig.builder().build();
        }
        return this.config.getValue(property);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        DeConv3DConfig conv2DConfig;
        int kW;
        int kH;
        int kD;
        int sW;
        int sH;
        int sD;
        AttrValue aStrides = nodeDef.getAttrOrThrow("strides");
        List<Long> tfStrides = aStrides.getList().getIList();
        AttrValue aPadding = nodeDef.getAttrOrDefault("padding", null);
        String paddingMode = aPadding.getS().toStringUtf8();
        SDVariable[] args = this.args();
        INDArray arr = this.sameDiff.getVariable(args[1].getVarName()).getArr();
        if (arr == null) {
            arr = TFGraphMapper.getInstance().getNDArrayFromTensor(nodeDef.getInput(0), nodeDef, graph);
            SDVariable varForOp = initWith.getVariable(args[1].getVarName());
            if (arr != null) {
                initWith.associateArrayWithVariable(arr, varForOp);
            }
        }
        String dataFormat = "nhwc";
        if (nodeDef.containsAttr("data_format")) {
            AttrValue attr = nodeDef.getAttrOrThrow("data_format");
            dataFormat = attr.getS().toStringUtf8().toLowerCase();
        }
        if (dataFormat.equalsIgnoreCase("NCDHW")) {
            sD = tfStrides.get(2).intValue();
            sH = tfStrides.get(3).intValue();
            sW = tfStrides.get(4).intValue();
            kD = (int)arr.size(2);
            kH = (int)arr.size(3);
            kW = (int)arr.size(4);
        } else {
            sD = tfStrides.get(1).intValue();
            sH = tfStrides.get(2).intValue();
            sW = tfStrides.get(3).intValue();
            kD = (int)arr.size(0);
            kH = (int)arr.size(1);
            kW = (int)arr.size(2);
        }
        boolean isSameMode = paddingMode.equalsIgnoreCase("SAME");
        this.config = conv2DConfig = DeConv3DConfig.builder().kD(kD).kH(kH).kW(kW).sD(sD).sH(sW).sW(sH).isSameMode(isSameMode).dataFormat(dataFormat.equalsIgnoreCase("NCDHW") ? "NCDHW" : "NDHWC").build();
        this.addArgs();
    }

    @Override
    public String opName() {
        return "deconv3d";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        SDVariable bias = this.args().length > 2 ? this.arg(2) : null;
        SDVariable[] outVars = this.f().deconv3dDerivative(this.arg(0), this.arg(1), bias, f1.get(0), this.config);
        return Arrays.asList(outVars);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public DeConv3DConfig getConfig() {
        return this.config;
    }

    public DeConv3D() {
    }
}

