/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.executioner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.buffer.Utf8Buffer;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.INDArrayStatistics;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.GridOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.MetaOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.ops.ReduceOp;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.aggregates.Aggregate;
import org.nd4j.linalg.api.ops.aggregates.Batch;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutionerUtil;
import org.nd4j.linalg.api.ops.impl.scatter.ScatterUpdate;
import org.nd4j.linalg.api.ops.impl.summarystats.Variance;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.cache.TADManager;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.AtomicBoolean;
import org.nd4j.linalg.primitives.Optional;
import org.nd4j.linalg.profiler.OpProfiler;
import org.nd4j.linalg.profiler.ProfilerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOpExecutioner
implements OpExecutioner {
    private static final Logger log = LoggerFactory.getLogger(DefaultOpExecutioner.class);
    private static final String SCOPE_PANIC_MSG = "For more details, see the ND4J User Guide: deeplearning4j.org/docs/latest/nd4j-overview#workspaces-panic";
    protected OpExecutioner.ProfilingMode profilingMode = OpExecutioner.ProfilingMode.SCOPE_PANIC;
    protected AtomicBoolean verbose = new AtomicBoolean(false);
    protected AtomicBoolean debug = new AtomicBoolean(false);

    protected void checkForCompression(Op op) {
        this.interceptIntDataType(op);
        if (op.x() != null && op.x().isCompressed()) {
            Nd4j.getCompressor().decompressi(op.x());
        }
        if (op.y() != null && op.y().isCompressed()) {
            Nd4j.getCompressor().decompressi(op.y());
        }
        if (op.z() != null && op.z().isCompressed()) {
            Nd4j.getCompressor().decompressi(op.z());
        }
    }

    @Override
    public String getLastOp() {
        return "UNKNOWN";
    }

    protected void interceptIntDataType(Op op) {
    }

    @Override
    public INDArray exec(Op op) {
        throw new IllegalStateException("Java computation no longer supported");
    }

    @Override
    public Op execAndReturn(Op op) {
        if (op instanceof TransformOp) {
            return this.execAndReturn((TransformOp)op);
        }
        if (op instanceof ScalarOp) {
            return this.execAndReturn((ScalarOp)op);
        }
        if (op instanceof ReduceOp) {
            this.exec((ReduceOp)op);
            return op;
        }
        if (op instanceof IndexAccumulation) {
            this.exec((IndexAccumulation)op);
            return op;
        }
        throw new IllegalArgumentException("Illegal opType of op: " + op.getClass());
    }

    @Override
    public TransformOp execAndReturn(TransformOp op) {
        this.exec(op);
        return op;
    }

    @Override
    public ReduceOp execAndReturn(ReduceOp op) {
        this.exec(op);
        return op;
    }

    @Override
    public Variance execAndReturn(Variance op) {
        this.exec(op);
        return op;
    }

    @Override
    public ScalarOp execAndReturn(ScalarOp op) {
        this.exec(op);
        return op;
    }

    @Override
    public IndexAccumulation execAndReturn(IndexAccumulation op) {
        this.exec(op);
        return op;
    }

    @Override
    public BroadcastOp execAndReturn(BroadcastOp op) {
        this.exec(op);
        return op;
    }

    @Override
    public INDArray[] exec(CustomOp op) {
        return this.execAndReturn(op).outputArguments();
    }

    @Override
    public INDArray exec(ReduceOp op) {
        throw new UnsupportedOperationException("Java computation no longer supported");
    }

    @Override
    public INDArray exec(Variance accumulation) {
        throw new UnsupportedOperationException("Operation should use exec special");
    }

    @Override
    public INDArray exec(IndexAccumulation op) {
        throw new UnsupportedOperationException("Operation should use exec special");
    }

    @Override
    public INDArray exec(BroadcastOp broadcast) {
        throw new IllegalStateException("Java computation no longer supported");
    }

    @Override
    public void exec(MetaOp op) {
        throw new UnsupportedOperationException("MetaOp execution isn't supported for this OpExecutioner yet");
    }

    @Override
    public void exec(GridOp op) {
        throw new UnsupportedOperationException("GridOp execution isn't supported for this OpExecutioner yet");
    }

    @Override
    public <T extends Aggregate> void exec(Batch<T> batch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exec(Aggregate op) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray exec(ScalarOp op) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exec(List<Aggregate> batch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray exec(RandomOp op) {
        return this.exec(op, Nd4j.getRandom());
    }

    @Override
    public INDArray exec(RandomOp op, Random rng) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setProfilingMode(OpExecutioner.ProfilingMode mode) {
        this.profilingMode = mode;
        ProfilerConfig config = null;
        switch (this.profilingMode) {
            case ALL: {
                config = ProfilerConfig.builder().checkWorkspaces(true).checkElapsedTime(true).stackTrace(true).build();
                break;
            }
            case METHODS: {
                config = ProfilerConfig.builder().stackTrace(true).build();
                break;
            }
            case OPERATIONS: {
                config = ProfilerConfig.builder().stackTrace(true).checkElapsedTime(true).build();
                break;
            }
            case SCOPE_PANIC: {
                config = ProfilerConfig.builder().checkWorkspaces(true).build();
                break;
            }
            case ANY_PANIC: {
                config = ProfilerConfig.builder().checkForINF(true).checkForNAN(true).build();
                break;
            }
            case INF_PANIC: {
                config = ProfilerConfig.builder().checkForINF(true).build();
                break;
            }
            case NAN_PANIC: {
                config = ProfilerConfig.builder().checkForNAN(true).build();
                break;
            }
            default: {
                config = ProfilerConfig.builder().build();
            }
        }
        OpProfiler.getInstance().setConfig(config);
    }

    @Override
    public void setProfilingConfig(ProfilerConfig config) {
        OpProfiler.getInstance().setConfig(config);
    }

    @Override
    @Deprecated
    public OpExecutioner.ProfilingMode getProfilingMode() {
        return this.profilingMode;
    }

    protected void checkWorkspace(String opName, INDArray array) {
        MemoryWorkspace ws;
        if (array.isAttached() && (ws = array.data().getParentWorkspace()).getWorkspaceType() != MemoryWorkspace.Type.CIRCULAR) {
            if (!ws.isScopeActive()) {
                throw new ND4JIllegalStateException("Op [" + opName + "] X argument uses leaked workspace pointer from workspace [" + ws.getId() + "]: Workspace the array was defined in is no longer open.\nAll open workspaces: " + DefaultOpExecutioner.allOpenWorkspaces() + "\n" + SCOPE_PANIC_MSG);
            }
            if (ws.getGenerationId() != array.data().getGenerationId()) {
                throw new ND4JIllegalStateException("Op [" + opName + "] X argument uses outdated workspace pointer from workspace [" + ws.getId() + "]: Workspace array was defined in has been closed and reopened at least once since array creation. Array WS iteration: " + array.data().getGenerationId() + ". Workspace current iteration: " + ws.getGenerationId() + "\nAll open workspaces: " + DefaultOpExecutioner.allOpenWorkspaces() + "\n" + SCOPE_PANIC_MSG);
            }
        }
    }

    protected void checkForWorkspaces(CustomOp op) {
        for (INDArray input : op.inputArguments()) {
            this.checkWorkspace(op.opName(), input);
        }
        for (INDArray output : op.outputArguments()) {
            this.checkWorkspace(op.opName(), output);
        }
    }

    protected void checkForWorkspaces(Op op) {
        INDArray z;
        INDArray y;
        INDArray x = op.x();
        if (x != null) {
            this.checkWorkspace(op.opName(), x);
        }
        if ((y = op.y()) != null) {
            this.checkWorkspace(op.opName(), y);
        }
        if ((z = op.z()) != null) {
            this.checkWorkspace(op.opName(), z);
        }
    }

    public static List<String> allOpenWorkspaces() {
        List l = Nd4j.getWorkspaceManager().getAllWorkspacesForCurrentThread();
        ArrayList<String> workspaces = new ArrayList<String>(l.size());
        for (MemoryWorkspace ws : l) {
            if (!ws.isScopeActive()) continue;
            workspaces.add(ws.getId());
        }
        return workspaces;
    }

    @Deprecated
    public long profilingHookIn(Op op, DataBuffer ... tadBuffers) {
        switch (this.profilingMode) {
            case ALL: {
                OpProfiler.getInstance().processOpCall(op, tadBuffers);
                break;
            }
            case METHODS: {
                break;
            }
            case OPERATIONS: {
                OpProfiler.getInstance().processOpCall(op, tadBuffers);
                break;
            }
            case SCOPE_PANIC: {
                this.checkForWorkspaces(op);
                return 0L;
            }
            default: {
                return 0L;
            }
        }
        return System.nanoTime();
    }

    @Deprecated
    public long profilingHookIn(CustomOp op) {
        switch (this.profilingMode) {
            case ALL: {
                OpProfiler.getInstance().processOpCall(op);
                break;
            }
            case METHODS: {
                break;
            }
            case OPERATIONS: {
                OpProfiler.getInstance().processOpCall(op);
                break;
            }
            case SCOPE_PANIC: {
                this.checkForWorkspaces(op);
                return 0L;
            }
            default: {
                return 0L;
            }
        }
        return System.nanoTime();
    }

    @Deprecated
    public void profilingHookOut(Op op, long timeStart) {
        switch (this.profilingMode) {
            case ALL: {
                OpProfiler.getInstance().processStackCall(op, timeStart);
                OpProfiler.getInstance().timeOpCall(op, timeStart);
                break;
            }
            case METHODS: {
                OpProfiler.getInstance().processStackCall(op, timeStart);
                break;
            }
            case OPERATIONS: {
                OpProfiler.getInstance().timeOpCall(op, timeStart);
                break;
            }
            case NAN_PANIC: {
                OpExecutionerUtil.checkForNaN(op);
                break;
            }
            case INF_PANIC: {
                OpExecutionerUtil.checkForInf(op);
                break;
            }
            case ANY_PANIC: {
                OpExecutionerUtil.checkForNaN(op);
                OpExecutionerUtil.checkForInf(op);
                break;
            }
        }
        if (Nd4j.getExecutioner().isVerbose() && op.z() != null) {
            log.info("Op name: {}; Z shapeInfo: {}; Z values: {}", new Object[]{op.opName(), op.z().shapeInfoJava(), DefaultOpExecutioner.firstX(op.z(), 10)});
        }
    }

    @Deprecated
    public void profilingHookOut(CustomOp op, long timeStart) {
        switch (this.profilingMode) {
            case ALL: {
                OpProfiler.getInstance().processStackCall(op, timeStart);
                OpProfiler.getInstance().timeOpCall(op, timeStart);
                break;
            }
            case METHODS: {
                OpProfiler.getInstance().processStackCall(op, timeStart);
                break;
            }
            case OPERATIONS: {
                OpProfiler.getInstance().timeOpCall(op, timeStart);
                break;
            }
            case NAN_PANIC: {
                OpExecutionerUtil.checkForNaN(op);
                break;
            }
            case INF_PANIC: {
                OpExecutionerUtil.checkForInf(op);
                break;
            }
            case ANY_PANIC: {
                OpExecutionerUtil.checkForNaN(op);
                OpExecutionerUtil.checkForInf(op);
                break;
            }
        }
    }

    public long profilingConfigurableHookIn(CustomOp op) {
        if (OpProfiler.getInstance().getConfig() == null) {
            return System.nanoTime();
        }
        if (OpProfiler.getInstance().getConfig().isStackTrace() || OpProfiler.getInstance().getConfig().isCheckElapsedTime()) {
            OpProfiler.getInstance().processOpCall(op);
        }
        if (OpProfiler.getInstance().getConfig().isCheckWorkspaces()) {
            this.checkForWorkspaces(op);
        }
        return System.nanoTime();
    }

    public long profilingConfigurableHookIn(Op op, DataBuffer ... tadBuffers) {
        if (OpProfiler.getInstance().getConfig() == null) {
            return System.nanoTime();
        }
        if (OpProfiler.getInstance().getConfig().isStackTrace() || OpProfiler.getInstance().getConfig().isCheckElapsedTime()) {
            OpProfiler.getInstance().processOpCall(op);
        }
        if (OpProfiler.getInstance().getConfig().isNotOptimalTAD()) {
            OpProfiler.getInstance().processOpCall(op, tadBuffers);
        }
        if (OpProfiler.getInstance().getConfig().isCheckWorkspaces()) {
            this.checkForWorkspaces(op);
        }
        return System.nanoTime();
    }

    public void profilingConfigurableHookOut(Op op, long timeStart) {
        if (OpProfiler.getInstance().getConfig() == null) {
            return;
        }
        if (OpProfiler.getInstance().getConfig().isStackTrace()) {
            OpProfiler.getInstance().processStackCall(op, timeStart);
        }
        if (OpProfiler.getInstance().getConfig().isCheckElapsedTime()) {
            OpProfiler.getInstance().timeOpCall(op, timeStart);
        }
        if (OpProfiler.getInstance().getConfig().isCheckForNAN()) {
            OpExecutionerUtil.checkForNaN(op);
        }
        if (OpProfiler.getInstance().getConfig().isCheckForINF()) {
            OpExecutionerUtil.checkForInf(op);
        }
        if (OpProfiler.getInstance().getConfig().isNativeStatistics() && op.z() != null) {
            INDArrayStatistics stat = this.inspectArray(op.z());
            OpProfiler.getInstance().setStatistics(stat);
            log.info("Op name: {}; Z shapeInfo: {}; Statistics: min:{} max:{} mean:{} stdev:{} pos:{}, neg:{} zero:{} inf:{} nan:{}", new Object[]{op.opName(), op.z().shapeInfoJava(), stat.getMinValue(), stat.getMaxValue(), stat.getMeanValue(), stat.getStdDevValue(), stat.getCountPositive(), stat.getCountNegative(), stat.getCountZero(), stat.getCountInf(), stat.getCountNaN()});
        }
        if (Nd4j.getExecutioner().isVerbose() && op.z() != null) {
            log.info("Op name: {}; Z shapeInfo: {}; Z values: {}", new Object[]{op.opName(), op.z().shapeInfoJava(), DefaultOpExecutioner.firstX(op.z(), 10)});
        }
    }

    public void profilingConfigurableHookOut(CustomOp op, long timeStart) {
        if (OpProfiler.getInstance().getConfig() == null) {
            return;
        }
        if (OpProfiler.getInstance().getConfig().isStackTrace()) {
            OpProfiler.getInstance().processStackCall(op, timeStart);
        }
        if (OpProfiler.getInstance().getConfig().isCheckElapsedTime()) {
            OpProfiler.getInstance().timeOpCall(op, timeStart);
        }
        if (OpProfiler.getInstance().getConfig().isCheckForNAN()) {
            OpExecutionerUtil.checkForNaN(op);
        }
        if (OpProfiler.getInstance().getConfig().isCheckForINF()) {
            OpExecutionerUtil.checkForInf(op);
        }
    }

    public static void validateDataType(DataType expectedType, Op op) {
        if (op.x() != null && !Shape.isEmpty(op.x().shapeInfoJava()) && op.x().data().dataType() == DataType.COMPRESSED) {
            Nd4j.getCompressor().decompressi(op.x());
        }
        if (op.y() != null && !Shape.isEmpty(op.y().shapeInfoJava()) && op.y().data().dataType() == DataType.COMPRESSED) {
            Nd4j.getCompressor().decompressi(op.y());
        }
        if (op.z() != null && !Shape.isEmpty(op.z().shapeInfoJava()) && op.z().data().dataType() == DataType.COMPRESSED) {
            Nd4j.getCompressor().decompressi(op.z());
        }
        if (op.y() != null && !Shape.isEmpty(op.y().shapeInfoJava()) && op.y().data().dataType() != expectedType) {
            throw new ND4JIllegalStateException("op.Y dataType is [" + op.y().data().dataType() + "] instead of expected [" + expectedType + "] - x.shape = " + Arrays.toString(op.x().shape()) + (op.y() != null ? ", y.shape=" + Arrays.toString(op.y().shape()) : "") + ", z.shape=" + Arrays.toString(op.z().shape()) + " - op: " + op.getClass().getName());
        }
        if (Nd4j.getExecutioner().isVerbose()) {
            log.info("Reporting [{}]", (Object)op.opName());
            if (op.x() != null) {
                log.info("X shapeInfo: {}; X values: {}", (Object)op.x().shapeInfoJava(), (Object)DefaultOpExecutioner.firstX(op.x(), 10));
            }
            if (op.y() != null) {
                log.info("Y shapeInfo: {}; Y values: {}", (Object)op.y().shapeInfoJava(), (Object)DefaultOpExecutioner.firstX(op.y(), 10));
            }
        }
    }

    protected static String firstX(INDArray array, int x) {
        StringBuilder builder = new StringBuilder("[");
        int limit = (int)Math.min((long)x, array.length());
        for (int e = 0; e < limit; ++e) {
            builder.append(array.getDouble((long)e));
            if (e >= limit - 1) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    public static void validateDataType(DataType expectedType, Object op, INDArray ... operands) {
        if (operands == null || operands.length == 0) {
            return;
        }
        int cnt = 0;
        for (INDArray operand : operands) {
            if (operand == null) continue;
            if (operand.data().dataType() != expectedType) {
                throw new ND4JIllegalStateException("INDArray [" + cnt + "] dataType is [" + operand.data().dataType() + "] instead of expected [" + expectedType + "]" + (op != null ? " op: " + op.getClass().getName() : ""));
            }
            ++cnt;
        }
    }

    @Override
    public TADManager getTADManager() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties getEnvironmentInformation() {
        Properties environment = new Properties();
        environment.put("cores", (Object)Runtime.getRuntime().availableProcessors());
        environment.put("memory.available", (Object)Runtime.getRuntime().maxMemory());
        environment.put("os", System.getProperty("os.name"));
        return environment;
    }

    @Override
    public void printEnvironmentInformation() {
        Properties env = this.getEnvironmentInformation();
        double memory = (double)((Long)env.get("memory.available")).longValue() / 1024.0 / 1024.0 / 1024.0;
        String fm = String.format("%.1f", memory);
        log.info("Backend used: [{}]; OS: [{}]", env.get("backend"), env.get("os"));
        log.info("Cores: [{}]; Memory: [{}GB];", env.get("cores"), (Object)fm);
        log.info("Blas vendor: [{}]", env.get("blas.vendor"));
    }

    @Override
    public void push() {
    }

    @Override
    public void commit() {
    }

    @Override
    public INDArray thresholdEncode(INDArray input, double threshold) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public INDArray thresholdEncode(INDArray input, double threshold, Integer boundary) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public INDArray thresholdDecode(INDArray encoded, INDArray target) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public long bitmapEncode(INDArray indArray, INDArray target, double threshold) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public INDArray bitmapEncode(INDArray indArray, double threshold) {
        DataBuffer buffer = Nd4j.getDataBufferFactory().createInt(indArray.length() / 16L + 5L);
        INDArray ret = Nd4j.createArrayFromShapeBuffer(buffer, indArray.shapeInfoDataBuffer());
        this.bitmapEncode(indArray, ret, threshold);
        return ret;
    }

    @Override
    public INDArray bitmapDecode(INDArray encoded, INDArray target) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Map<String, CustomOpDescriptor> getCustomOperations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CustomOp execAndReturn(CustomOp op) {
        this.exec(op);
        return op;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(CustomOp op) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray[] allocateOutputArrays(CustomOp op) {
        List<LongShapeDescriptor> shapes = this.calculateOutputShape(op);
        INDArray[] out = new INDArray[shapes.size()];
        for (int i = 0; i < shapes.size(); ++i) {
            out[i] = Nd4j.create(shapes.get(i));
        }
        return out;
    }

    @Override
    public void enableDebugMode(boolean reallyEnable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void enableVerboseMode(boolean reallyEnable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerGraph(long id, Pointer graph) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Map<String, INDArray> executeGraph(long id, Map<String, INDArray> map, Map<String, Integer> reverseMap) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void forgetGraph(long id) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void setElementsThreshold(int threshold) {
    }

    @Override
    public void setTadThreshold(int threshold) {
    }

    @Override
    public boolean isVerbose() {
        return this.verbose.get();
    }

    @Override
    public boolean isDebug() {
        return this.debug.get();
    }

    @Override
    public OpExecutioner.ExecutionerType type() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(Utf8Buffer buffer, long index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void scatterUpdate(ScatterUpdate.UpdateOp op, INDArray array, INDArray indices, INDArray updates, int[] axis) {
        throw new UnsupportedOperationException();
    }

    public String opInfoString(Op op, Optional<int[]> dimensions) {
        if (op == null) {
            return "<NULL OP>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Class: ").append(op.getClass().getName()).append("; opNum: ").append(op.opNum()).append("; opName: ").append(op.opName());
        if (op instanceof DifferentialFunction) {
            sb.append("; opType: ").append((Object)((DifferentialFunction)((Object)op)).opType());
        }
        if (dimensions != null) {
            sb.append("; dimensions: ");
            if (dimensions.isPresent()) {
                sb.append(Arrays.toString((int[])dimensions.get()));
            } else {
                sb.append("<null>");
            }
        }
        INDArray x = op.x();
        INDArray y = op.y();
        INDArray z = op.z();
        Object[] extraArgs = op.extraArgs();
        sb.append("\n");
        sb.append("x: ").append(this.arrayInfo(x)).append("; ");
        sb.append("y: ").append(this.arrayInfo(y)).append("; ");
        sb.append("z: ").append(this.arrayInfo(z)).append("; ");
        if (x == y && x != null) {
            sb.append("(x == y)");
        }
        if (x == z && x != null) {
            sb.append("(x == z)");
        }
        if (y == z && y != null) {
            sb.append("(y == z)");
        }
        sb.append("\n");
        sb.append("; extraArgs: ").append(Preconditions.formatArray((Object)extraArgs));
        return sb.toString();
    }

    public String arrayInfo(INDArray arr) {
        if (arr == null) {
            return "<null>";
        }
        if (arr.isEmpty()) {
            return "(empty NDArray)";
        }
        return arr.shapeInfoToString().replaceAll("\n", "");
    }

    @Override
    public boolean isExperimentalMode() {
        return false;
    }

    @Override
    public OpContext buildContext() {
        throw new UnsupportedOperationException("OpContext is available only on native backends");
    }

    @Override
    public INDArray[] exec(CustomOp op, OpContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArrayStatistics inspectArray(INDArray array) {
        throw new UnsupportedOperationException();
    }
}

