/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.ShapeInfoProvider;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseShapeInfoProvider
implements ShapeInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(BaseShapeInfoProvider.class);
    protected AtomicLong bytes = new AtomicLong(0L);

    @Override
    public Pair<DataBuffer, long[]> createShapeInformation(long[] shape, DataType dataType) {
        char order = Nd4j.order().charValue();
        return this.createShapeInformation(shape, order, dataType);
    }

    @Override
    public Pair<DataBuffer, long[]> createShapeInformation(long[] shape, char order, DataType dataType) {
        long[] stride = Nd4j.getStrides(shape, order);
        int ews = 1;
        return this.createShapeInformation(shape, stride, (long)ews, order, dataType);
    }

    @Override
    public Pair<DataBuffer, long[]> createShapeInformation(long[] shape, long[] stride, long elementWiseStride, char order, DataType dataType) {
        DataBuffer buffer = Shape.createShapeInformation(shape, stride, elementWiseStride, order, dataType);
        buffer.setConstant(true);
        return Pair.create((Object)buffer, (Object)buffer.asLong());
    }

    @Override
    public Pair<DataBuffer, long[]> createShapeInformation(long[] shape, long[] stride, long elementWiseStride, char order, long extras) {
        DataBuffer buffer = Shape.createShapeInformation(shape, stride, elementWiseStride, order, extras);
        buffer.setConstant(true);
        return Pair.create((Object)buffer, (Object)buffer.asLong());
    }

    @Override
    public long getCachedBytes() {
        return this.bytes.get();
    }
}

