/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.imports.tensorflow;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.converters.DifferentialFunctionClassHolder;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.imports.tensorflow.TFImportStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class TensorFlowImportValidator {
    private static final Logger log = LoggerFactory.getLogger(TensorFlowImportValidator.class);

    public static TFImportStatus checkAllModelsForImport(File directory) throws IOException {
        Preconditions.checkState((boolean)directory.isDirectory(), (String)"Specified directory %s is not actually a directory", (Object)directory);
        Collection files = FileUtils.listFiles((File)directory, (String[])new String[]{"pb"}, (boolean)true);
        Preconditions.checkState((!files.isEmpty() ? 1 : 0) != 0, (String)"No .pb files found in directory %s", (Object)directory);
        TFImportStatus status = null;
        for (File f : files) {
            if (status == null) {
                status = TensorFlowImportValidator.checkModelForImport(f);
                continue;
            }
            status = status.merge(TensorFlowImportValidator.checkModelForImport(f));
        }
        return status;
    }

    public static TFImportStatus checkModelForImport(File file) throws IOException {
        TFGraphMapper m = TFGraphMapper.getInstance();
        try {
            int opCount = 0;
            HashSet<String> opNames = new HashSet<String>();
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                GraphDef graphDef = m.parseGraphFrom(is);
                List<NodeDef> nodes = m.getNodeList(graphDef);
                for (NodeDef nd : nodes) {
                    if (m.isVariableNode(nd) || m.isPlaceHolderNode(nd)) continue;
                    String op = nd.getOp();
                    opNames.add(op);
                    ++opCount;
                }
            }
            HashSet<String> importSupportedOpNames = new HashSet<String>();
            HashSet<String> unsupportedOpNames = new HashSet<String>();
            for (String s : opNames) {
                if (DifferentialFunctionClassHolder.getInstance().getOpWithTensorflowName(s) != null) {
                    importSupportedOpNames.add(s);
                    continue;
                }
                unsupportedOpNames.add(s);
            }
            return new TFImportStatus(Collections.singletonList(file.getPath()), unsupportedOpNames.size() > 0 ? Collections.singletonList(file.getPath()) : Collections.emptyList(), Collections.emptyList(), opCount, opNames.size(), opNames, importSupportedOpNames, unsupportedOpNames);
        }
        catch (Throwable t) {
            log.warn("Failed to import model: " + file.getPath(), t);
            return new TFImportStatus(Collections.emptyList(), Collections.emptyList(), Collections.singletonList(file.getPath()), 0, 0, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
    }
}

