/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.transform;

import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SameDiff;

public abstract class OpPredicate {
    public abstract boolean matches(SameDiff var1, DifferentialFunction var2);

    public static OpPredicate nameEquals(final String name) {
        return new OpPredicate(){

            @Override
            public boolean matches(SameDiff sameDiff, DifferentialFunction function) {
                return function.getOwnName().equals(name);
            }
        };
    }

    public static OpPredicate opNameEquals(final String opName) {
        return new OpPredicate(){

            @Override
            public boolean matches(SameDiff sameDiff, DifferentialFunction function) {
                return function.opName().equals(opName);
            }
        };
    }

    public static OpPredicate nameMatches(final String regex) {
        return new OpPredicate(){

            @Override
            public boolean matches(SameDiff sameDiff, DifferentialFunction function) {
                return function.getOwnName().matches(regex);
            }
        };
    }

    public static OpPredicate opNameMatches(final String regex) {
        return new OpPredicate(){

            @Override
            public boolean matches(SameDiff sameDiff, DifferentialFunction function) {
                return function.getOwnName().matches(regex);
            }
        };
    }

    public static OpPredicate classEquals(final Class<?> c) {
        return new OpPredicate(){

            @Override
            public boolean matches(SameDiff sameDiff, DifferentialFunction function) {
                return function.getClass() == c;
            }
        };
    }
}

