/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.list.compat;

import java.util.ArrayList;
import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TensorList {
    private static final Logger log = LoggerFactory.getLogger(TensorList.class);
    private final String name;
    private ArrayList<INDArray> list = new ArrayList();

    public TensorList(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        this.name = name;
    }

    public TensorList(@NonNull String name, @NonNull INDArray source) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked @NonNull but is null");
        }
        this.name = name;
    }

    public INDArray get(int index) {
        return this.list.get(index);
    }

    public void put(int index, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked @NonNull but is null");
        }
        this.list.ensureCapacity(index + 1);
        this.list.add(index, array.dup());
    }

    public INDArray stack() {
        return Nd4j.pile(this.list);
    }

    public INDArray gather(INDArray indices) {
        if (indices.length() == 1L && indices.getInt(0) == -1) {
            return this.stack();
        }
        int[] idxs = indices.reshape(indices.length()).toIntVector();
        ArrayList<INDArray> newList = new ArrayList<INDArray>();
        for (int id : idxs) {
            newList.add(this.list.get(id));
        }
        return Nd4j.pile(newList);
    }

    public INDArray concat() {
        return Nd4j.concat(0, (INDArray[])this.list.toArray());
    }

    public int size() {
        return this.list.size();
    }

    public String getName() {
        return this.name;
    }
}

