/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.blas.Blas;
import org.nd4j.linalg.api.blas.Lapack;
import org.nd4j.linalg.api.blas.Level1;
import org.nd4j.linalg.api.blas.Level2;
import org.nd4j.linalg.api.blas.Level3;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.NDArrayFactory;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.util.ArrayUtil;

public abstract class BaseNDArrayFactory
implements NDArrayFactory {
    protected char order;
    protected Blas blas;
    protected Level1 level1;
    protected Level2 level2;
    protected Level3 level3;
    protected Lapack lapack;

    public BaseNDArrayFactory() {
    }

    @Override
    public Lapack lapack() {
        if (this.lapack == null) {
            this.createLapack();
        }
        return this.lapack;
    }

    @Override
    public Blas blas() {
        if (this.blas == null) {
            this.createBlas();
        }
        return this.blas;
    }

    @Override
    public Level1 level1() {
        if (this.level1 == null) {
            this.createLevel1();
        }
        return this.level1;
    }

    @Override
    public Level2 level2() {
        if (this.level2 == null) {
            this.createLevel2();
        }
        return this.level2;
    }

    @Override
    public Level3 level3() {
        if (this.level3 == null) {
            this.createLevel3();
        }
        return this.level3;
    }

    protected BaseNDArrayFactory(DataBuffer.Type dtype, Character order) {
        if (Character.toLowerCase(order.charValue()) != 'c' && Character.toLowerCase(order.charValue()) != 'f') {
            throw new IllegalArgumentException("Order must either be c or f");
        }
        this.order = Character.toLowerCase(order.charValue());
    }

    protected BaseNDArrayFactory(DataBuffer.Type dtype, char order) {
        if (Character.toLowerCase(order) != 'c' && Character.toLowerCase(order) != 'f') {
            throw new IllegalArgumentException("Order must either be c or f");
        }
        this.order = Character.toLowerCase(order);
    }

    @Override
    public void setOrder(char order) {
        Preconditions.checkArgument((order == 'c' || order == 'f' ? 1 : 0) != 0, (String)"Order specified must be either c or f: got %s", (Object)String.valueOf(order));
        this.order = order;
    }

    @Override
    public INDArray rand(long[] shape, double min, double max, Random rng) {
        Nd4j.getRandom().setSeed(rng.getSeed());
        return Nd4j.getDistributions().createUniform(min, max).sample(shape);
    }

    @Override
    public INDArray rand(int[] shape, double min, double max, Random rng) {
        Nd4j.getRandom().setSeed(rng.getSeed());
        return Nd4j.getDistributions().createUniform(min, max).sample(shape);
    }

    @Override
    public INDArray rand(long rows, long columns, double min, double max, Random rng) {
        Nd4j.getRandom().setSeed(rng.getSeed());
        return this.rand(new long[]{rows, columns}, min, max, rng);
    }

    @Override
    public void setDType(DataBuffer.Type dtype) {
        assert (dtype == DataBuffer.Type.DOUBLE || dtype == DataBuffer.Type.FLOAT || dtype == DataBuffer.Type.INT) : "Invalid opType passed, must be float or double";
    }

    @Override
    public INDArray create(int[] shape, DataBuffer.Type dataType) {
        return this.create(shape, Nd4j.createBuffer(shape, dataType));
    }

    @Override
    public char order() {
        return this.order;
    }

    @Override
    public DataBuffer.Type dtype() {
        return Nd4j.dataType();
    }

    @Override
    public INDArray linspace(int lower, int upper, int num) {
        double[] data = new double[num];
        for (int i = 0; i < num; ++i) {
            double t = (double)i / (double)(num - 1);
            data[i] = (double)lower * (1.0 - t) + t * (double)upper;
        }
        INDArray ret = Nd4j.create(data.length);
        if (ret.isScalar()) {
            return ret;
        }
        int i = 0;
        while ((long)i < ret.length()) {
            ret.putScalar((long)i, data[i]);
            ++i;
        }
        return ret;
    }

    @Override
    public INDArray create(int[] ints, int[] ints1, int[] stride, long offset) {
        return this.create(Nd4j.createBuffer(ints), ints1, stride, offset);
    }

    @Override
    public INDArray create(long rows, long columns, char ordering) {
        return this.create(new long[]{rows, columns}, ordering);
    }

    @Override
    public INDArray toFlattened(Collection<INDArray> matrices) {
        int length = 0;
        for (INDArray m : matrices) {
            length = (int)((long)length + m.length());
        }
        INDArray ret = Nd4j.create(1, length);
        int linearIndex = 0;
        for (INDArray d : matrices) {
            INDArray vector = d.reshape(d.length());
            ret.put(new INDArrayIndex[]{NDArrayIndex.interval((long)linearIndex, (long)linearIndex + d.length())}, vector);
            linearIndex = (int)((long)linearIndex + d.length());
        }
        return ret;
    }

    @Override
    public INDArray toFlattened(int length, Iterator<? extends INDArray> ... matrices) {
        ArrayList<INDArray> arr = new ArrayList<INDArray>();
        for (Iterator<? extends INDArray> arrs : matrices) {
            while (arrs.hasNext()) {
                arr.add(arrs.next());
            }
        }
        return this.toFlattened(arr);
    }

    @Override
    public INDArray bilinearProducts(INDArray curr, INDArray in) {
        Preconditions.checkArgument((curr.rank() == 3 ? 1 : 0) != 0, (String)"Argument 'curr' must be rank 3. Got input with rank: %s", (int)curr.rank());
        if (in.columns() != 1) {
            throw new AssertionError((Object)"Expected a column vector");
        }
        if ((long)in.rows() != curr.size(curr.shape().length - 1)) {
            throw new AssertionError((Object)"Number of rows in the input does not match number of columns in tensor");
        }
        if (curr.size(curr.shape().length - 2) != curr.size(curr.shape().length - 1)) {
            throw new AssertionError((Object)"Can only perform this operation on a SimpleTensor with square slices");
        }
        INDArray ret = Nd4j.create(curr.slices(), 1L);
        INDArray inT = in.transpose();
        int i = 0;
        while ((long)i < curr.slices()) {
            INDArray slice = curr.slice(i);
            INDArray inTTimesSlice = inT.mmul(slice);
            ret.putScalar((long)i, Nd4j.getBlasWrapper().dot(inTTimesSlice, in));
            ++i;
        }
        return ret;
    }

    @Override
    public INDArray toFlattened(INDArray ... matrices) {
        return this.toFlattened(Nd4j.order().charValue(), Arrays.asList(matrices));
    }

    @Override
    public INDArray toFlattened(char order, INDArray ... matrices) {
        return this.toFlattened(order, Arrays.asList(matrices));
    }

    @Override
    public INDArray eye(long n) {
        INDArray ret = Nd4j.create(n, n);
        int i = 0;
        while ((long)i < n) {
            ret.put(i, i, 1.0);
            ++i;
        }
        return ret.reshape(n, n);
    }

    @Override
    public void rot90(INDArray toRotate) {
        if (!toRotate.isMatrix()) {
            throw new IllegalArgumentException("Only rotating matrices");
        }
        INDArray start = toRotate.transpose();
        for (int i = 0; i < start.rows(); ++i) {
            start.putRow(i, this.reverse(start.getRow(i)));
        }
    }

    @Override
    public INDArray rot(INDArray reverse) {
        INDArray ret = Nd4j.create(reverse.shape());
        if (reverse.isVector()) {
            return this.reverse(reverse);
        }
        int i = 0;
        while ((long)i < reverse.slices()) {
            ret.putSlice(i, this.reverse(reverse.slice(i)));
            ++i;
        }
        return ret.reshape(reverse.shape());
    }

    @Override
    public INDArray reverse(INDArray reverse) {
        INDArray rev = reverse.linearView();
        INDArray ret = Nd4j.create(rev.shape());
        int count = 0;
        for (long i = rev.length() - 1L; i >= 0L; --i) {
            ret.putScalar((long)count++, rev.getFloat(i));
        }
        return ret.reshape(reverse.shape());
    }

    @Override
    public INDArray arange(double begin, double end) {
        return Nd4j.create(ArrayUtil.toDoubles((int[])ArrayUtil.range((int)((int)begin), (int)((int)end))));
    }

    @Override
    public void copy(INDArray a, INDArray b) {
        b.assign(a);
    }

    @Override
    public INDArray rand(int[] shape, float min, float max, Random rng) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return Nd4j.getDistributions().createUniform(min, max).sample(shape);
    }

    @Override
    public INDArray rand(long[] shape, float min, float max, Random rng) {
        if (shape.length == 1 && shape[0] == 0L) {
            shape = new long[]{1L, 1L};
        }
        return Nd4j.getDistributions().createUniform(min, max).sample(shape);
    }

    @Override
    public INDArray rand(long rows, long columns, float min, float max, Random rng) {
        return this.rand(new long[]{rows, columns}, min, max, rng);
    }

    @Override
    public INDArray appendBias(INDArray ... vectors) {
        int size = 0;
        for (INDArray vector : vectors) {
            size += vector.rows();
        }
        INDArray result = Nd4j.create(size + 1, vectors[0].columns());
        int index = 0;
        for (INDArray vector : vectors) {
            INDArray put = this.toFlattened(vector, Nd4j.ones(1));
            result.put(new INDArrayIndex[]{NDArrayIndex.interval(index, index + vector.rows() + 1), NDArrayIndex.interval(0, vectors[0].columns())}, put);
            index += vector.rows();
        }
        return result;
    }

    @Override
    public INDArray rand(long rows, long columns, Random r) {
        return this.rand(new long[]{rows, columns}, r);
    }

    @Override
    public INDArray rand(long rows, long columns, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.rand(new long[]{rows, columns}, Nd4j.getRandom());
    }

    @Override
    public INDArray rand(long rows, long columns) {
        return this.rand(new long[]{rows, columns}, System.currentTimeMillis());
    }

    @Override
    public INDArray rand(char order, long rows, long columns) {
        Shape.assertValidOrder(order);
        return Nd4j.getRandom().nextDouble(order, new long[]{rows, columns});
    }

    @Override
    public INDArray randn(long rows, long columns, Random r) {
        return this.randn(new long[]{rows, columns}, r);
    }

    @Override
    public INDArray randn(long rows, long columns) {
        return this.randn(new long[]{rows, columns}, System.currentTimeMillis());
    }

    @Override
    public INDArray randn(char order, long rows, long columns) {
        Shape.assertValidOrder(order);
        return Nd4j.getRandom().nextGaussian(order, new long[]{rows, columns});
    }

    @Override
    public INDArray randn(long rows, long columns, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.randn(new long[]{rows, columns}, Nd4j.getRandom());
    }

    @Override
    public INDArray rand(int[] shape, Distribution r) {
        INDArray ret = r.sample(shape);
        return ret;
    }

    @Override
    public INDArray rand(int[] shape, Random r) {
        INDArray ret = r.nextDouble(shape);
        return ret;
    }

    @Override
    public INDArray rand(long[] shape, Random r) {
        INDArray ret = r.nextDouble(shape);
        return ret;
    }

    @Override
    public INDArray rand(int[] shape, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.rand(shape, Nd4j.getRandom());
    }

    @Override
    public INDArray rand(long[] shape, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.rand(shape, Nd4j.getRandom());
    }

    @Override
    public INDArray rand(int[] shape) {
        return this.rand(shape, System.currentTimeMillis());
    }

    @Override
    public INDArray rand(long[] shape) {
        return this.rand(shape, System.currentTimeMillis());
    }

    @Override
    public INDArray rand(char order, int[] shape) {
        Shape.assertValidOrder(order);
        return Nd4j.getRandom().nextDouble(order, shape);
    }

    @Override
    public INDArray rand(char order, long[] shape) {
        Shape.assertValidOrder(order);
        return Nd4j.getRandom().nextDouble(order, shape);
    }

    @Override
    public INDArray randn(int[] shape, Random r) {
        return r.nextGaussian(shape);
    }

    @Override
    public INDArray randn(long[] shape, Random r) {
        return r.nextGaussian(shape);
    }

    @Override
    public INDArray randn(char order, int[] shape) {
        Shape.assertValidOrder(order);
        return Nd4j.getRandom().nextGaussian(order, shape);
    }

    @Override
    public INDArray randn(char order, long[] shape) {
        Shape.assertValidOrder(order);
        return Nd4j.getRandom().nextGaussian(order, shape);
    }

    @Override
    public INDArray randn(int[] shape) {
        return this.randn(shape, System.currentTimeMillis());
    }

    @Override
    public INDArray randn(long[] shape) {
        return this.randn(shape, System.currentTimeMillis());
    }

    @Override
    public INDArray randn(int[] shape, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.randn(shape, Nd4j.getRandom());
    }

    @Override
    public INDArray randn(long[] shape, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.randn(shape, Nd4j.getRandom());
    }

    @Override
    public INDArray create(double[] data) {
        return this.create(data, new int[]{1, data.length});
    }

    @Override
    public INDArray create(float[] data) {
        return this.create(data, new int[]{1, data.length});
    }

    @Override
    public INDArray create(long columns) {
        return this.create(new long[]{1L, columns});
    }

    @Override
    public INDArray zeros(long rows, long columns) {
        return this.zeros(new long[]{rows, columns});
    }

    @Override
    public INDArray pullRows(INDArray source, int sourceDimension, int[] indexes, char order) {
        Shape.assertValidOrder(order);
        long vectorLength = source.shape()[sourceDimension];
        INDArray ret = Nd4j.createUninitialized(new long[]{indexes.length, vectorLength}, order);
        for (int cnt = 0; cnt < indexes.length; ++cnt) {
            ret.putRow(cnt, source.tensorAlongDimension(indexes[cnt], sourceDimension));
        }
        return ret;
    }

    @Override
    public INDArray pullRows(INDArray source, int sourceDimension, int[] indexes) {
        return this.pullRows(source, sourceDimension, indexes, Nd4j.order().charValue());
    }

    @Override
    public INDArray zeros(long columns) {
        return this.zeros(new long[]{1L, columns});
    }

    @Override
    public INDArray valueArrayOf(int[] shape, double value) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        ret.assign(value);
        return ret;
    }

    @Override
    public INDArray valueArrayOf(long[] shape, double value) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        ret.assign(value);
        return ret;
    }

    @Override
    public INDArray create(int[] shape, int[] stride, long offset, char ordering) {
        Shape.assertValidOrder(ordering);
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.create(Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape)), shape, stride, offset, ordering);
    }

    @Override
    public INDArray valueArrayOf(long rows, long columns, double value) {
        INDArray create = this.createUninitialized(new long[]{rows, columns}, Nd4j.order().charValue());
        create.assign(value);
        return create;
    }

    @Override
    public INDArray ones(long rows, long columns) {
        return this.ones(new long[]{rows, columns});
    }

    @Override
    public INDArray ones(long columns) {
        return this.ones(new long[]{1L, columns});
    }

    @Override
    public INDArray create(float[] data, int[] shape, char ordering) {
        Shape.assertValidOrder(ordering);
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.create(Nd4j.createBuffer(data), shape, Nd4j.getStrides(shape, ordering), 0L, ordering);
    }

    @Override
    public INDArray concat(int dimension, INDArray ... toConcat) {
        if (toConcat.length == 1) {
            return toConcat[0];
        }
        int sumAlongDim = 0;
        boolean allC = toConcat[0].ordering() == 'c';
        long[] outputShape = ArrayUtil.copy((long[])toConcat[0].shape());
        outputShape[dimension] = sumAlongDim;
        for (int i = 0; i < toConcat.length; ++i) {
            sumAlongDim = (int)((long)sumAlongDim + toConcat[i].size(dimension));
            allC = allC && toConcat[i].ordering() == 'c';
            for (int j = 0; j < toConcat[i].rank(); ++j) {
                if (j == dimension || toConcat[i].size(j) == outputShape[j] || toConcat[i].isVector()) continue;
                throw new IllegalArgumentException("Illegal concatenation at array " + i + " and shape element " + j);
            }
        }
        long[] sortedStrides = Nd4j.getStrides(outputShape);
        INDArray ret = Nd4j.create(outputShape, sortedStrides);
        allC &= ret.ordering() == 'c';
        if (toConcat[0].isScalar()) {
            INDArray retLinear = ret.linearView();
            int i = 0;
            while ((long)i < retLinear.length()) {
                retLinear.putScalar((long)i, toConcat[i].getDouble(0L));
                ++i;
            }
            return ret;
        }
        if (dimension == 0 && allC) {
            int currBuffer = 0;
            int currBufferOffset = 0;
            int i = 0;
            while ((long)i < ret.length()) {
                ret.data().put((long)i, toConcat[currBuffer].data().getDouble(toConcat[currBuffer].offset() + (long)currBufferOffset++));
                if ((long)currBufferOffset >= toConcat[currBuffer].length()) {
                    ++currBuffer;
                    currBufferOffset = 0;
                }
                ++i;
            }
            return ret;
        }
        int arrOffset = 0;
        INDArray[] retAlongDimensionArrays = new INDArray[(int)ret.tensorssAlongDimension(dimension)];
        for (int i = 0; i < retAlongDimensionArrays.length; ++i) {
            retAlongDimensionArrays[i] = ret.tensorAlongDimension(i, dimension);
        }
        for (INDArray arr : toConcat) {
            long arrTensorLength = -1L;
            if (arr.tensorssAlongDimension(dimension) != ret.tensorssAlongDimension(dimension)) {
                throw new IllegalStateException("Illegal concatenate. Tensors along dimension must be same length.");
            }
            int i = 0;
            while ((long)i < arr.tensorssAlongDimension(dimension)) {
                INDArray retLinear = retAlongDimensionArrays[i];
                INDArray arrTensor = arr.tensorAlongDimension(i, dimension);
                arrTensorLength = arrTensor.length();
                int j = 0;
                while ((long)j < arrTensor.length()) {
                    int idx = j + arrOffset;
                    retLinear.putScalar((long)idx, arrTensor.getDouble((long)j));
                    ++j;
                }
                ++i;
            }
            arrOffset = (int)((long)arrOffset + arrTensorLength);
        }
        return ret;
    }

    @Override
    public INDArray hstack(INDArray ... arrs) {
        return Nd4j.concat(1, arrs);
    }

    @Override
    public INDArray vstack(INDArray ... arrs) {
        return Nd4j.concat(0, arrs);
    }

    @Override
    public INDArray zeros(int[] shape) {
        INDArray ret = this.create(shape);
        return ret;
    }

    @Override
    public INDArray zeros(long[] shape) {
        INDArray ret = this.create(shape);
        return ret;
    }

    @Override
    public INDArray ones(int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        INDArray ret = this.create(shape);
        ret.assign(1);
        return ret;
    }

    @Override
    public INDArray ones(long[] shape) {
        INDArray ret = this.create(shape);
        ret.assign(1);
        return ret;
    }

    @Override
    public INDArray create(float[] data, long rows, long columns, int[] stride, long offset) {
        return this.create(data, new long[]{rows, columns}, ArrayUtil.toLongArray((int[])stride), offset);
    }

    @Override
    public abstract INDArray create(float[] var1, int[] var2, int[] var3, long var4);

    @Override
    public INDArray create(double[] data, int[] shape) {
        return this.create(data, shape, Nd4j.getStrides(shape), 0L);
    }

    @Override
    public INDArray create(float[] data, int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.create(data, shape, Nd4j.getStrides(shape), 0L);
    }

    @Override
    public INDArray create(float[] data, long[] shape) {
        if (shape.length == 1 && shape[0] == 0L) {
            shape = new long[]{1L, 1L};
        }
        return this.create(data, shape, Nd4j.getStrides(shape), 0L);
    }

    @Override
    public INDArray create(double[] data, long[] shape) {
        if (shape.length == 1 && shape[0] == 0L) {
            shape = new long[]{1L, 1L};
        }
        return this.create(data, shape, Nd4j.getStrides(shape), 0L);
    }

    @Override
    public INDArray create(double[] data, long rows, long columns, int[] stride, long offset) {
        return this.create(data, new long[]{rows, columns}, ArrayUtil.toLongArray((int[])stride), offset);
    }

    @Override
    public abstract INDArray create(double[] var1, int[] var2, int[] var3, long var4);

    @Override
    public abstract INDArray create(List<INDArray> var1, int[] var2);

    @Override
    public INDArray create(long rows, long columns, int[] stride, long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray create(int[] shape, int[] stride, long offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        DataBuffer buffer = Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape));
        return this.create(buffer, shape, stride, offset);
    }

    @Override
    public INDArray create(long[] shape, long[] stride, long offset) {
        if (shape.length == 1 && shape[0] == 0L) {
            shape = new long[]{1L, 1L};
        }
        DataBuffer buffer = Nd4j.createBuffer(ArrayUtil.prodLong((long[])shape));
        return this.create(buffer, shape, stride, offset);
    }

    @Override
    public INDArray create(long rows, long columns, int[] stride) {
        return this.create(new long[]{rows, columns}, ArrayUtil.toLongArray((int[])stride));
    }

    @Override
    public INDArray create(long[] shape, long[] stride) {
        return this.create(shape, stride, 0L, Nd4j.order().charValue());
    }

    @Override
    public INDArray create(long[] shape, long[] stride, long offset, char ordering) {
        Shape.assertValidOrder(ordering);
        if (shape.length == 1 && shape[0] == 0L) {
            shape = new long[]{1L, 1L};
        }
        return this.create(Nd4j.createBuffer(ArrayUtil.prodLong((long[])shape)), shape, stride, offset, ordering);
    }

    @Override
    public INDArray create(int[] shape, int[] stride) {
        return this.create(shape, stride, 0L);
    }

    @Override
    public INDArray create(long rows, long columns) {
        return this.create(new long[]{rows, columns});
    }

    @Override
    public INDArray create(long[] shape) {
        return this.create(shape, Nd4j.getStrides(shape), 0L);
    }

    @Override
    public INDArray create(int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.create(shape, Nd4j.getStrides(shape), 0L);
    }

    @Override
    public INDArray scalar(Number value, long offset) {
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.scalar(value.doubleValue(), offset);
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT || Nd4j.dataType() == DataBuffer.Type.HALF) {
            return this.scalar(value.floatValue(), offset);
        }
        if (Nd4j.dataType() == DataBuffer.Type.INT) {
            return this.scalar(value.intValue(), offset);
        }
        throw new IllegalStateException("Illegal data opType " + Nd4j.dataType());
    }

    @Override
    public INDArray scalar(float value, long offset) {
        return this.create(new float[]{value}, new int[]{1, 1}, new int[]{1, 1}, offset);
    }

    @Override
    public INDArray scalar(double value, long offset) {
        return this.create(new double[]{value}, new int[]{1, 1}, new int[]{1, 1}, offset);
    }

    @Override
    public INDArray trueScalar(Number value) {
        DataBuffer.Type dtype = Nd4j.dataType();
        switch (dtype) {
            case DOUBLE: {
                return this.create(new double[]{value.doubleValue()}, new int[0], new int[0], 0L);
            }
            case FLOAT: {
                return this.create(new float[]{value.floatValue()}, new int[0], new int[0], 0L);
            }
            case HALF: {
                return this.create(new float[]{value.floatValue()}, new int[0], new int[0], 0L);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: [" + dtype + "]");
    }

    @Override
    public INDArray trueVector(float[] data) {
        return this.create(data, new int[]{data.length}, new int[]{1}, 0L);
    }

    @Override
    public INDArray trueVector(double[] data) {
        return this.create(data, new int[]{data.length}, new int[]{1}, 0L);
    }

    @Override
    public INDArray scalar(int value, long offset) {
        return this.create(new int[]{value}, new int[]{1, 1}, new int[]{1, 1}, offset);
    }

    @Override
    public INDArray scalar(Number value) {
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.scalar(value.doubleValue(), 0L);
        }
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT || Nd4j.dataType() == DataBuffer.Type.HALF) {
            return this.scalar(value.floatValue(), 0L);
        }
        if (Nd4j.dataType() == DataBuffer.Type.INT) {
            return this.scalar(value.intValue(), 0L);
        }
        throw new IllegalStateException("Illegal data opType " + Nd4j.dataType());
    }

    @Override
    public INDArray scalar(float value) {
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT || Nd4j.dataType() == DataBuffer.Type.HALF) {
            return this.create(new float[]{value}, new int[]{1, 1}, new int[]{1, 1}, 0L);
        }
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.scalar((double)value);
        }
        return this.scalar((int)value);
    }

    @Override
    public INDArray scalar(double value) {
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            return this.create(new double[]{value}, new int[]{1, 1}, new int[]{1, 1}, 0L);
        }
        return this.scalar((float)value);
    }

    @Override
    public INDArray create(float[] data, int[] shape, long offset) {
        return this.create(Nd4j.createBuffer(data), shape, offset);
    }

    @Override
    public INDArray create(float[] data, char order) {
        Shape.assertValidOrder(order);
        int[] shape = new int[]{1, data.length};
        return this.create(Nd4j.createBuffer(data), shape, Nd4j.getStrides(shape, order), order, 0L);
    }

    @Override
    public INDArray create(float[] data, int[] shape, int[] stride, char order, long offset) {
        return this.create(Nd4j.createBuffer(data), shape, stride, order, offset);
    }

    @Override
    public INDArray create(double[] data, char order) {
        Shape.assertValidOrder(order);
        return this.create(data, new int[]{1, data.length}, Nd4j.getStrides(new int[]{1, data.length}, order), order, 0L);
    }

    @Override
    public INDArray create(double[] data, int[] shape, int[] stride, char order, long offset) {
        return this.create(Nd4j.createBuffer(data), shape, stride, order, offset);
    }

    @Override
    public INDArray create(DataBuffer buffer, int[] shape, int[] stride, char order, long offset) {
        Shape.assertValidOrder(order);
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.create(buffer, shape, stride, offset, order);
    }

    @Override
    public INDArray create(int[] data, int[] shape, int[] stride, char order, long offset) {
        Shape.assertValidOrder(order);
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return this.create(Nd4j.createBuffer(data), shape, stride, order, offset);
    }
}

