/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.functions.DifferentialFunctionFactory;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;

public class Entropy
extends BaseAccumulation {
    public Entropy(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public Entropy() {
    }

    public Entropy(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Entropy(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public Entropy(INDArray x) {
        super(x);
    }

    public Entropy(INDArray x, INDArray y) {
        super(x, y);
    }

    public Entropy(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    @Override
    public int opNum() {
        return 16;
    }

    @Override
    public String opName() {
        return "entropy";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "entropy";
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.REDUCE;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Entropy.grad(this.f(), this.arg(), f1.get(0), this.dimensions);
    }

    public static List<SDVariable> grad(DifferentialFunctionFactory f, SDVariable arg, SDVariable grad, int[] dimensions) {
        SDVariable logx = f.log(arg);
        SDVariable xLogX = arg.mul(logx);
        SDVariable sumBp = f.sumBp(xLogX, grad.neg(), false, dimensions);
        return Collections.singletonList(sumBp.mul(logx.add(1.0)));
    }
}

