/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.params;

import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.BaseSparseNDArrayCOO;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.SparseFormat;
import org.nd4j.linalg.factory.Nd4j;

public class SparseCOOGemvParameters {
    private int m;
    private int nnz;
    DataBuffer val;
    DataBuffer rowInd;
    DataBuffer colInd;
    private INDArray a;
    private INDArray x;
    private INDArray y;
    private char aOrdering = (char)78;

    public SparseCOOGemvParameters(INDArray a, INDArray x, INDArray y) {
        this.a = a;
        this.x = x;
        this.y = y;
        if (a.isMatrix() && a.getFormat() == SparseFormat.COO) {
            BaseSparseNDArrayCOO coo = (BaseSparseNDArrayCOO)a;
            this.val = coo.getIncludedValues();
            this.nnz = coo.nnz();
            this.m = coo.rows();
            this.setIndexes(coo, false);
        }
    }

    private void setIndexes(BaseSparseNDArrayCOO coo, boolean oneBased) {
        int incr = oneBased ? 1 : 0;
        int[] idx = coo.getIncludedIndices().asInt();
        int[] rows = new int[this.nnz];
        int[] cols = new int[this.nnz];
        for (int i = 0; i < this.nnz; ++i) {
            rows[i] = idx[i * 2] + incr;
            cols[i] = idx[i * 2 + 1] + incr;
        }
        this.rowInd = Nd4j.createBuffer(rows);
        this.colInd = Nd4j.createBuffer(cols);
    }

    public int getM() {
        return this.m;
    }

    public int getNnz() {
        return this.nnz;
    }

    public DataBuffer getVal() {
        return this.val;
    }

    public DataBuffer getRowInd() {
        return this.rowInd;
    }

    public DataBuffer getColInd() {
        return this.colInd;
    }

    public INDArray getA() {
        return this.a;
    }

    public INDArray getX() {
        return this.x;
    }

    public INDArray getY() {
        return this.y;
    }

    public char getAOrdering() {
        return this.aOrdering;
    }

    public void setM(int m) {
        this.m = m;
    }

    public void setNnz(int nnz) {
        this.nnz = nnz;
    }

    public void setVal(DataBuffer val) {
        this.val = val;
    }

    public void setRowInd(DataBuffer rowInd) {
        this.rowInd = rowInd;
    }

    public void setColInd(DataBuffer colInd) {
        this.colInd = colInd;
    }

    public void setA(INDArray a) {
        this.a = a;
    }

    public void setX(INDArray x) {
        this.x = x;
    }

    public void setY(INDArray y) {
        this.y = y;
    }

    public void setAOrdering(char aOrdering) {
        this.aOrdering = aOrdering;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SparseCOOGemvParameters)) {
            return false;
        }
        SparseCOOGemvParameters other = (SparseCOOGemvParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getM() != other.getM()) {
            return false;
        }
        if (this.getNnz() != other.getNnz()) {
            return false;
        }
        DataBuffer this$val = this.getVal();
        DataBuffer other$val = other.getVal();
        if (this$val == null ? other$val != null : !this$val.equals(other$val)) {
            return false;
        }
        DataBuffer this$rowInd = this.getRowInd();
        DataBuffer other$rowInd = other.getRowInd();
        if (this$rowInd == null ? other$rowInd != null : !this$rowInd.equals(other$rowInd)) {
            return false;
        }
        DataBuffer this$colInd = this.getColInd();
        DataBuffer other$colInd = other.getColInd();
        if (this$colInd == null ? other$colInd != null : !this$colInd.equals(other$colInd)) {
            return false;
        }
        INDArray this$a = this.getA();
        INDArray other$a = other.getA();
        if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
            return false;
        }
        INDArray this$x = this.getX();
        INDArray other$x = other.getX();
        if (this$x == null ? other$x != null : !this$x.equals(other$x)) {
            return false;
        }
        INDArray this$y = this.getY();
        INDArray other$y = other.getY();
        if (this$y == null ? other$y != null : !this$y.equals(other$y)) {
            return false;
        }
        return this.getAOrdering() == other.getAOrdering();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SparseCOOGemvParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getM();
        result = result * 59 + this.getNnz();
        DataBuffer $val = this.getVal();
        result = result * 59 + ($val == null ? 43 : $val.hashCode());
        DataBuffer $rowInd = this.getRowInd();
        result = result * 59 + ($rowInd == null ? 43 : $rowInd.hashCode());
        DataBuffer $colInd = this.getColInd();
        result = result * 59 + ($colInd == null ? 43 : $colInd.hashCode());
        INDArray $a = this.getA();
        result = result * 59 + ($a == null ? 43 : $a.hashCode());
        INDArray $x = this.getX();
        result = result * 59 + ($x == null ? 43 : $x.hashCode());
        INDArray $y = this.getY();
        result = result * 59 + ($y == null ? 43 : $y.hashCode());
        result = result * 59 + this.getAOrdering();
        return result;
    }

    public String toString() {
        return "SparseCOOGemvParameters(m=" + this.getM() + ", nnz=" + this.getNnz() + ", val=" + this.getVal() + ", rowInd=" + this.getRowInd() + ", colInd=" + this.getColInd() + ", a=" + this.getA() + ", x=" + this.getX() + ", y=" + this.getY() + ", aOrdering=" + this.getAOrdering() + ")";
    }
}

