/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.evaluation;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.nd4j.evaluation.EvaluationUtils;
import org.nd4j.evaluation.IEvaluation;
import org.nd4j.evaluation.classification.Evaluation;
import org.nd4j.evaluation.classification.EvaluationBinary;
import org.nd4j.evaluation.classification.EvaluationCalibration;
import org.nd4j.evaluation.classification.ROC;
import org.nd4j.evaluation.classification.ROCBinary;
import org.nd4j.evaluation.classification.ROCMultiClass;
import org.nd4j.evaluation.regression.RegressionEvaluation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.AtomicBoolean;
import org.nd4j.linalg.primitives.AtomicDouble;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.primitives.serde.JsonDeserializerAtomicBoolean;
import org.nd4j.linalg.primitives.serde.JsonDeserializerAtomicDouble;
import org.nd4j.linalg.primitives.serde.JsonSerializerAtomicBoolean;
import org.nd4j.linalg.primitives.serde.JsonSerializerAtomicDouble;
import org.nd4j.shade.jackson.annotation.JsonAutoDetect;
import org.nd4j.shade.jackson.core.JsonFactory;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonSerializer;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.Module;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.module.SimpleModule;
import org.nd4j.shade.jackson.dataformat.yaml.YAMLFactory;

public abstract class BaseEvaluation<T extends BaseEvaluation>
implements IEvaluation<T> {
    private static ObjectMapper objectMapper = BaseEvaluation.configureMapper(new ObjectMapper());
    private static ObjectMapper yamlMapper = BaseEvaluation.configureMapper(new ObjectMapper((JsonFactory)new YAMLFactory()));

    private static ObjectMapper configureMapper(ObjectMapper ret) {
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, false);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        SimpleModule atomicModule = new SimpleModule();
        atomicModule.addSerializer(AtomicDouble.class, (JsonSerializer)new JsonSerializerAtomicDouble());
        atomicModule.addSerializer(AtomicBoolean.class, (JsonSerializer)new JsonSerializerAtomicBoolean());
        atomicModule.addDeserializer(AtomicDouble.class, (JsonDeserializer)new JsonDeserializerAtomicDouble());
        atomicModule.addDeserializer(AtomicBoolean.class, (JsonDeserializer)new JsonDeserializerAtomicBoolean());
        ret.registerModule((Module)atomicModule);
        ret.setVisibilityChecker(ret.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        return ret;
    }

    @Override
    public void evalTimeSeries(INDArray labels, INDArray predicted) {
        this.evalTimeSeries(labels, predicted, null);
    }

    @Override
    public void evalTimeSeries(INDArray labels, INDArray predictions, INDArray labelsMask) {
        Pair<INDArray, INDArray> pair = EvaluationUtils.extractNonMaskedTimeSteps(labels, predictions, labelsMask);
        if (pair == null) {
            return;
        }
        INDArray labels2d = (INDArray)pair.getFirst();
        INDArray predicted2d = (INDArray)pair.getSecond();
        this.eval(labels2d, predicted2d);
    }

    @Override
    public void eval(INDArray labels, INDArray networkPredictions, List<? extends Serializable> recordMetaData) {
        this.eval(labels, networkPredictions);
    }

    @Override
    public void eval(INDArray labels, INDArray networkPredictions, INDArray maskArray) {
        if (maskArray == null) {
            if (labels.rank() == 3) {
                this.evalTimeSeries(labels, networkPredictions, maskArray);
            } else {
                this.eval(labels, networkPredictions);
            }
            return;
        }
        if (labels.rank() == 3 && maskArray.rank() == 2) {
            this.evalTimeSeries(labels, networkPredictions, maskArray);
            return;
        }
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support per-output masking");
    }

    @Override
    public String toJson() {
        try {
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toYaml() {
        try {
            return yamlMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends IEvaluation> T fromYaml(String yaml, Class<T> clazz) {
        try {
            return (T)((IEvaluation)yamlMapper.readValue(yaml, clazz));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends IEvaluation> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)((IEvaluation)objectMapper.readValue(json, clazz));
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("Invalid type id")) {
                try {
                    return BaseEvaluation.attempFromLegacyFromJson(json, e);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Cannot deserialize from JSON - JSON is invalid?", t);
                }
            }
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends IEvaluation> T attempFromLegacyFromJson(String json, IllegalArgumentException originalException) {
        if (json.contains("org.deeplearning4j.eval.Evaluation")) {
            String newJson = json.replaceAll("org.deeplearning4j.eval.Evaluation", "org.nd4j.evaluation.classification.Evaluation");
            return (T)BaseEvaluation.fromJson(newJson, Evaluation.class);
        }
        if (json.contains("org.deeplearning4j.eval.EvaluationBinary")) {
            String newJson = json.replaceAll("org.deeplearning4j.eval.EvaluationBinary", "org.nd4j.evaluation.classification.EvaluationBinary").replaceAll("org.deeplearning4j.eval.ROC", "org.nd4j.evaluation.classification.ROC").replaceAll("org.deeplearning4j.eval.curves.", "org.nd4j.evaluation.curves.");
            return (T)BaseEvaluation.fromJson(newJson, EvaluationBinary.class);
        }
        if (json.contains("org.deeplearning4j.eval.EvaluationCalibration")) {
            String newJson = json.replaceAll("org.deeplearning4j.eval.EvaluationCalibration", "org.nd4j.evaluation.classification.EvaluationCalibration").replaceAll("org.deeplearning4j.eval.curves.", "org.nd4j.evaluation.curves.");
            return (T)BaseEvaluation.fromJson(newJson, EvaluationCalibration.class);
        }
        if (json.contains("org.deeplearning4j.eval.ROCBinary")) {
            String newJson = json.replaceAll("org.deeplearning4j.eval.ROCBinary", "org.nd4j.evaluation.classification.ROCBinary").replaceAll("org.deeplearning4j.eval.ROC", "org.nd4j.evaluation.classification.ROC").replaceAll("org.deeplearning4j.eval.curves.", "org.nd4j.evaluation.curves.");
            return (T)BaseEvaluation.fromJson(newJson, ROCBinary.class);
        }
        if (json.contains("org.deeplearning4j.eval.ROCMultiClass")) {
            String newJson = json.replaceAll("org.deeplearning4j.eval.ROCMultiClass", "org.nd4j.evaluation.classification.ROCMultiClass").replaceAll("org.deeplearning4j.eval.ROC", "org.nd4j.evaluation.classification.ROC").replaceAll("org.deeplearning4j.eval.curves.", "org.nd4j.evaluation.curves.");
            return (T)BaseEvaluation.fromJson(newJson, ROCMultiClass.class);
        }
        if (json.contains("org.deeplearning4j.eval.ROC")) {
            String newJson = json.replaceAll("org.deeplearning4j.eval.ROC", "org.nd4j.evaluation.classification.ROC").replaceAll("org.deeplearning4j.eval.curves.", "org.nd4j.evaluation.curves.");
            return (T)BaseEvaluation.fromJson(newJson, ROC.class);
        }
        if (json.contains("org.deeplearning4j.eval.RegressionEvaluation")) {
            String newJson = json.replaceAll("org.deeplearning4j.eval.RegressionEvaluation", "org.nd4j.evaluation.regression.RegressionEvaluation");
            return (T)BaseEvaluation.fromJson(newJson, RegressionEvaluation.class);
        }
        throw originalException;
    }

    public String toString() {
        return this.stats();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseEvaluation)) {
            return false;
        }
        BaseEvaluation other = (BaseEvaluation)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseEvaluation;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static ObjectMapper getYamlMapper() {
        return yamlMapper;
    }
}

