/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.serde.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonNode;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLegacyDeserializer<T>
extends JsonDeserializer<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseLegacyDeserializer.class);

    public abstract Map<String, String> getLegacyNamesMap();

    public abstract ObjectMapper getLegacyJsonMapper();

    public abstract Class<?> getDeserializedType();

    public T deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        Class<?> lClass;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Iterator nodes = node.fields();
        ArrayList list = new ArrayList();
        while (nodes.hasNext()) {
            list.add(nodes.next());
        }
        if (list.size() != 1) {
            return null;
        }
        String name = (String)((Map.Entry)list.get(0)).getKey();
        JsonNode value = (JsonNode)((Map.Entry)list.get(0)).getValue();
        Map<String, String> legacyNamesMap = this.getLegacyNamesMap();
        String layerClass = legacyNamesMap.get(name);
        if (layerClass == null) {
            throw new IllegalStateException("Cannot deserialize " + this.getDeserializedType() + " with name \"" + name + "\": legacy class mapping with this name is unknown");
        }
        try {
            lClass = Class.forName(layerClass);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find class for deserialization of \"" + name + "\" of type " + this.getDeserializedType() + ": class " + layerClass + " is not on the classpath?", e);
        }
        ObjectMapper m = this.getLegacyJsonMapper();
        if (m == null) {
            throw new IllegalStateException("Cannot deserialize unknown subclass of type " + this.getDeserializedType() + ": no legacy JSON mapper has been set");
        }
        String nodeAsString = value.toString();
        try {
            Object t = m.readValue(nodeAsString, lClass);
            return (T)t;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot deserialize legacy JSON format of object with name \"" + name + "\" of type " + this.getDeserializedType().getName(), e);
        }
    }
}

