/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import java.util.Arrays;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.accum.AMax;
import org.nd4j.linalg.api.ops.impl.accum.AMin;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAMax;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAMin;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAddOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastCopyOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastEqualTo;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastGreaterThan;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastGreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastLessThan;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastLessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMax;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMin;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMulOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastNotEqual;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRSubOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastSubOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.CopyOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldAddOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldDivOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldMulOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldRDivOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.OldSubOp;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldEqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldGreaterThan;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldGreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldLessThan;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldLessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldMax;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldMin;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.OldNotEqualTo;
import org.nd4j.linalg.factory.Nd4j;

public class Broadcast {
    private Broadcast() {
    }

    public static INDArray add(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldAddOp(x, y, z));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastAddOp(x, y, z, dimensions));
    }

    public static INDArray copy(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new CopyOp(x, y, z));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastCopyOp(x, y, z, dimensions));
    }

    public static INDArray div(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldDivOp(x, y, z));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastDivOp(x, y, z, dimensions));
    }

    public static INDArray eq(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldEqualTo(x, y, z, x.length()));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastEqualTo(x, y, z, dimensions));
    }

    public static INDArray gt(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldGreaterThan(x, y, z, x.length()));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastGreaterThan(x, y, z, dimensions));
    }

    public static INDArray gte(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldGreaterThanOrEqual(x, y, z, x.length()));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastGreaterThanOrEqual(x, y, z, dimensions));
    }

    public static INDArray lt(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldLessThan(x, y, z, x.length()));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastLessThan(x, y, z, dimensions));
    }

    public static INDArray lte(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldLessThanOrEqual(x, y, z, x.length()));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastLessThanOrEqual(x, y, z, dimensions));
    }

    public static INDArray mul(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldMulOp(x, y, z, x.length()));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastMulOp(x, y, z, dimensions));
    }

    public static INDArray neq(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldNotEqualTo(x, y, z, x.length()));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastNotEqual(x, y, z, dimensions));
    }

    public static INDArray rdiv(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldRDivOp(x, y, z, x.length()));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastRDivOp(x, y, z, dimensions));
    }

    public static INDArray rsub(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldSubOp(x, y, z, x.length()));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastRSubOp(x, y, z, dimensions));
    }

    public static INDArray sub(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldSubOp(x, y, z, x.length()));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastSubOp(x, y, z, dimensions));
    }

    public static INDArray max(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldMax(x, y, z, x.length()));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastMax(x, y, z, dimensions));
    }

    public static INDArray min(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new OldMin(x, y, z, x.length()));
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastMin(x, y, z, dimensions));
    }

    public static INDArray amax(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new AMax(x, y, z, x.length())).z();
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastAMax(x, y, z, dimensions));
    }

    public static INDArray amin(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        if (dimensions == null || dimensions.length == 0) {
            Broadcast.validateShapesNoDimCase(x, y, z);
            return Nd4j.getExecutioner().execAndReturn(new AMin(x, y, z, x.length())).z();
        }
        return Nd4j.getExecutioner().execAndReturn(new BroadcastAMin(x, y, z, dimensions));
    }

    public static void validateShapesNoDimCase(INDArray x, INDArray y, INDArray z) {
        Preconditions.checkArgument((boolean)x.equalShapes(y), (String)"When no dimensions are provided, X and Y shapes must be equal (x shape: %s, y shape: %s)", (Object)x.shape(), (Object)y.shape());
        Preconditions.checkArgument((boolean)x.equalShapes(z), (String)"When no dimensions are provided, X and Z (result) shapes must be equal (x shape: %s, z shape: %s)", (Object)x.shape(), (Object)z.shape());
    }

    public static void validateBroadcastDims(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        Preconditions.checkArgument((x == z || x.equalShapes(z) ? 1 : 0) != 0, (String)"X and Z arrays must be equal shape. X shape: %s, Z shape: %s", (Object)x.shape(), (Object)z.shape());
        long[] sx = x.shape();
        long[] sy = y.shape();
        if (dimensions.length == 1 && sy.length == 2 && (sy[0] == 1L || sy[1] == 1L)) {
            int d2;
            int n = d2 = dimensions[0] < 0 ? dimensions[0] + sx.length : dimensions[0];
            if (sy[0] == 1L) {
                Preconditions.checkState((sx[d2] == sy[1] ? 1 : 0) != 0, (String)"Shapes do not match: dimensions[0] - x[%s] must match y[%s], x shape %s, y shape %s, dimensions %s", (Object)dimensions[0], (Object)1, (Object)sx, (Object)sy, (Object)dimensions);
            } else {
                Preconditions.checkState((sx[d2] == sy[0] ? 1 : 0) != 0, (String)"Shapes do not match: dimensions[0] - x[%s] must match y[%s], x shape %s, y shape %s, dimensions %s", (Object)dimensions[0], (Object)0, (Object)sx, (Object)sy, (Object)dimensions);
            }
        } else if (sx.length == sy.length) {
            for (int d : dimensions) {
                int d2 = d < 0 ? d + sx.length : d;
                Preconditions.checkState((sx[d2] == sy[d2] ? 1 : 0) != 0, (String)"Dimensions mismatch on dimension %s: x shape %s, y shape %s", (Object)d, (Object)sx, (Object)sy);
            }
        } else if (dimensions.length == sy.length) {
            for (int i = 0; i < dimensions.length; ++i) {
                int d2 = dimensions[i] < 0 ? dimensions[i] + sx.length : dimensions[i];
                Preconditions.checkState((sx[d2] == sy[i] ? 1 : 0) != 0, (String)"Shapes do not match: dimensions[%s] - x[%s] must match y[%s], x shape %s, y shape %s, dimensions %s", (Object)i, (Object)d2, (Object)i, (Object)sx, (Object)sy, (Object)dimensions);
            }
        } else {
            throw new IllegalStateException("Invalid broadcast dimensions: x shape " + Arrays.toString(sx) + ", y shape " + Arrays.toString(sy) + ", dimensions " + Arrays.toString(dimensions));
        }
    }
}

