/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;

public class BinomialDistribution
extends BaseRandomOp {
    private int trials;
    private double probability;

    public BinomialDistribution(SameDiff sd, int trials, double probability, long[] shape) {
        super(sd, shape);
        this.trials = trials;
        this.probability = probability;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    public BinomialDistribution() {
    }

    public BinomialDistribution(@NonNull INDArray z, int trials, double probability) {
        if (z == null) {
            throw new NullPointerException("z is marked @NonNull but is null");
        }
        this.init(z, z, z, z.lengthLong());
        this.trials = trials;
        this.probability = probability;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    public BinomialDistribution(@NonNull INDArray z, int trials, @NonNull INDArray probabilities) {
        if (z == null) {
            throw new NullPointerException("z is marked @NonNull but is null");
        }
        if (probabilities == null) {
            throw new NullPointerException("probabilities is marked @NonNull but is null");
        }
        if ((long)trials > probabilities.lengthLong()) {
            throw new IllegalStateException("Number of trials is > then amount of probabilities provided");
        }
        if (probabilities.elementWiseStride() < 1) {
            throw new IllegalStateException("Probabilities array shouldn't have negative elementWiseStride");
        }
        this.init(z, probabilities, z, z.lengthLong());
        this.trials = trials;
        this.probability = 0.0;
        this.extraArgs = new Object[]{(double)this.trials, this.probability};
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("trials", this.trials);
        ret.put("probability", this.probability);
        return ret;
    }

    public BinomialDistribution(@NonNull INDArray z, @NonNull INDArray probabilities) {
        this(z, (int)probabilities.length(), probabilities);
        if (z == null) {
            throw new NullPointerException("z is marked @NonNull but is null");
        }
        if (probabilities == null) {
            throw new NullPointerException("probabilities is marked @NonNull but is null");
        }
    }

    @Override
    public int opNum() {
        return 8;
    }

    @Override
    public String opName() {
        return "distribution_binomial";
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.emptyList();
    }

    @Override
    public void setZ(INDArray z) {
        this.x = z;
        this.y = z;
        this.z = z;
    }
}

