/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape.tensorops;

import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.list.compat.TensorList;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public abstract class BaseTensorOp
extends DynamicCustomOp {
    public BaseTensorOp(String name, SameDiff sameDiff, SDVariable[] args) {
        super(name, sameDiff, args);
    }

    public BaseTensorOp(SameDiff sameDiff, SDVariable[] args) {
        super(null, sameDiff, args);
    }

    public BaseTensorOp() {
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        String inputOne = nodeDef.getInput(1);
        SDVariable varFor = initWith.getVariable(inputOne);
        NodeDef nodeWithIndex = TFGraphMapper.getInstance().getNodeWithNameFromGraph(graph, inputOne);
        INDArray var = TFGraphMapper.getInstance().getArrayFrom(nodeWithIndex, graph);
        if (var != null) {
            int idx = var.getInt(0);
            this.addIArgument(idx);
        }
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Differentiation not supported yet.");
    }

    public abstract TensorList execute(SameDiff var1);

    protected INDArray getArgumentArray(int index) {
        SDVariable arg = this.arg(index);
        INDArray array = this.sameDiff.getArrForVarName(arg.getVarName());
        return array;
    }

    protected TensorList getList(SameDiff sameDiff) {
        SDVariable arg0 = this.arg(0);
        String tName = arg0.getVarName();
        TensorList list = sameDiff.getListByName(tName);
        if (list == null) {
            if (sameDiff.getParent() != null && sameDiff.getParent().getListByName(tName) != null) {
                return sameDiff.getParent().getListByName(tName);
            }
            throw new ND4JIllegalStateException("There's no TensorList with name [" + tName + "] registered");
        }
        return list;
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op name found for " + this.opName());
    }

    @Override
    public String toString() {
        return this.opName();
    }
}

